/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.settings;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.tencent.code.intel.impl.CopilotSettingsService;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.settings.IConfigurable;
import com.tencent.code.intel.settings.SettingsForm;
import com.tencent.code.intel.util.ColorUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NotNull;

public class CommitMessageStyleSetting
extends JBPanel<CommitMessageStyleSetting>
implements IConfigurable {
    private ComboBox<SettingsForm.ComboBoxItem> styleComboBox;
    private ComboBox<SettingsForm.ComboBoxItem> languageComboBox;
    private JBCheckBox tapdEnableToggle;
    private String commitMessageStyle;
    private String commitMessageLanguage;
    private Boolean commitMessageTAPDEnable;
    SettingsForm.ComboBoxItem[] promptStyleItems = new SettingsForm.ComboBoxItem[]{new SettingsForm.ComboBoxItem(LocaleManager.get("ui.settings.commitMessageStyle.option.default"), "default"), new SettingsForm.ComboBoxItem(LocaleManager.get("ui.settings.commitMessageStyle.option.conventional"), "conventional"), new SettingsForm.ComboBoxItem(LocaleManager.get("ui.settings.commitMessageStyle.option.auto"), "auto")};
    SettingsForm.ComboBoxItem[] commitMessageLanguageItems = new SettingsForm.ComboBoxItem[]{new SettingsForm.ComboBoxItem(LocaleManager.get("ui.settings.commitMessageLanguage.option.en.text"), LocaleManager.get("ui.settings.commitMessageLanguage.option.en.value")), new SettingsForm.ComboBoxItem(LocaleManager.get("ui.settings.commitMessageLanguage.option.zh.text"), LocaleManager.get("ui.settings.commitMessageLanguage.option.zh.value"))};

    public CommitMessageStyleSetting() {
        this.initSetting();
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 10));
        this.initCommitMessageStyle();
    }

    private void initSetting() {
        if (this.disabled()) {
            return;
        }
        String style = CopilotSettingsService.getInstance().getCommitMessageStyle();
        this.commitMessageStyle = TextUtils.isBlank((CharSequence)style) ? "auto" : style;
        CopilotSettingsService.getInstance().setCommitMessageStyle(this.commitMessageStyle);
        String language = CopilotSettingsService.getInstance().getCommitMessageLanguage();
        this.commitMessageLanguage = TextUtils.isBlank((CharSequence)language) ? "zh_CN" : language;
        CopilotSettingsService.getInstance().setCommitMessageLanguage(this.commitMessageLanguage);
    }

    @Override
    public void apply() throws ConfigurationException {
        if (this.disabled()) {
            return;
        }
        CopilotSettingsService.getInstance().setCommitMessageStyle(this.commitMessageStyle);
        CopilotSettingsService.getInstance().setCommitMessageLanguage(this.commitMessageLanguage);
    }

    @Override
    public void reset() {
        if (this.disabled()) {
            return;
        }
        IntStream.range(0, this.promptStyleItems.length).filter(i -> this.promptStyleItems[i].getValue().equals(this.commitMessageStyle)).findFirst().ifPresent(arg_0 -> this.styleComboBox.setSelectedIndex(arg_0));
        IntStream.range(0, this.promptStyleItems.length).filter(i -> this.promptStyleItems[i].getValue().equals(this.commitMessageLanguage)).findFirst().ifPresent(arg_0 -> this.languageComboBox.setSelectedIndex(arg_0));
    }

    @Override
    public boolean isModified() {
        if (this.disabled()) {
            return false;
        }
        return !this.commitMessageStyle.equals(CopilotSettingsService.getInstance().getCommitMessageStyle()) || !this.commitMessageLanguage.equals(CopilotSettingsService.getInstance().getCommitMessageLanguage());
    }

    private void initCommitMessageStyle() {
        TitledSeparator titledSeparator = new TitledSeparator(LocaleManager.get("ui.settings.commitMessageStyle.title"));
        this.add((Component)titledSeparator);
        this.styleComboBox = this.createComboBox(this.promptStyleItems, selectedItem -> {
            this.commitMessageStyle = selectedItem.getValue();
        });
        JBPanel<?> panelCommitMessageStyle = this.createSettingPanel(LocaleManager.get("ui.settings.commitMessageStyle.label"), this.styleComboBox, this.promptStyleItems, this.commitMessageStyle);
        this.add((Component)panelCommitMessageStyle);
        this.languageComboBox = this.createComboBox(this.commitMessageLanguageItems, selectedItem -> {
            this.commitMessageLanguage = selectedItem.getValue();
        });
        JBPanel<?> panelLanguageSetting = this.createSettingPanel(LocaleManager.get("ui.settings.commitMessageLanguage.label"), this.languageComboBox, this.commitMessageLanguageItems, this.commitMessageLanguage);
        this.add((Component)panelLanguageSetting);
    }

    private void initTAPDSettingComponent() {
        this.tapdEnableToggle = new JBCheckBox(LocaleManager.get("ui.settings.commitMessageLanguage.tapd.enable.title"), this.commitMessageTAPDEnable.booleanValue());
        this.tapdEnableToggle.addChangeListener(e -> {
            this.commitMessageTAPDEnable = this.tapdEnableToggle.isSelected();
        });
        JBPanel tapdEnablePanel = new JBPanel((LayoutManager)new BorderLayout());
        tapdEnablePanel.add((Component)this.tapdEnableToggle, (Object)"North");
        JBTextArea textPane = new JBTextArea();
        textPane.setEditable(false);
        textPane.setForeground(Color.GRAY);
        textPane.setBackground(ColorUtils.getBackgroundColor());
        textPane.setBorder((Border)JBUI.Borders.empty((int)5, (int)22));
        textPane.setLineWrap(true);
        textPane.setText(LocaleManager.get("ui.settings.commitMessageLanguage.tapd.enable.description"));
        textPane.setFont(UIUtil.getLabelFont());
        tapdEnablePanel.add((Component)textPane, (Object)"Center");
        this.add((Component)tapdEnablePanel);
    }

    private JBPanel<?> createSettingPanel(String labelText, ComboBox<SettingsForm.ComboBoxItem> comboBox, SettingsForm.ComboBoxItem[] items, String selectedValue) {
        JBPanel panel = new JBPanel((LayoutManager)new BorderLayout());
        JBLabel label = new JBLabel(labelText);
        panel.add((Component)label, (Object)"West");
        JPanel comboBoxPanel = new JPanel();
        comboBoxPanel.setLayout(new BoxLayout(comboBoxPanel, 0));
        comboBoxPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        IntStream.range(0, items.length).filter(i -> items[i].getValue().equals(selectedValue)).findFirst().ifPresent(arg_0 -> comboBox.setSelectedIndex(arg_0));
        comboBoxPanel.add((Component)comboBox);
        panel.add((Component)comboBoxPanel, (Object)"Center");
        return panel;
    }

    @NotNull
    private ComboBox<SettingsForm.ComboBoxItem> createComboBox(SettingsForm.ComboBoxItem[] items, Consumer<SettingsForm.ComboBoxItem> onSelectAction) {
        ComboBox comboBox = new ComboBox((Object[])items);
        comboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof SettingsForm.ComboBoxItem) {
                    this.setText(((SettingsForm.ComboBoxItem)value).getText());
                }
                return this;
            }
        });
        comboBox.addActionListener(e -> {
            SettingsForm.ComboBoxItem selectedItem = (SettingsForm.ComboBoxItem)comboBox.getSelectedItem();
            if (selectedItem != null) {
                onSelectAction.accept(selectedItem);
            }
        });
        Dimension preferredSize = comboBox.getPreferredSize();
        preferredSize.width = 320;
        comboBox.setMaximumSize(preferredSize);
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            CommitMessageStyleSetting.$$$reportNull$$$0(0);
        }
        return comboBox2;
    }

    private boolean disabled() {
        return false;
    }

    public String getCommitMessageStyle() {
        return this.commitMessageStyle;
    }

    public String getCommitMessageLanguage() {
        return this.commitMessageLanguage;
    }

    public Boolean getCommitMessageTAPDEnable() {
        return this.commitMessageTAPDEnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/tencent/code/intel/settings/CommitMessageStyleSetting", "createComboBox"));
    }
}

