/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.settings;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.JBColor;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.tencent.code.intel.impl.CopilotSettingsService;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.settings.IConfigurable;
import com.tencent.code.intel.settings.SettingsForm;
import com.tencent.code.intel.ui.pane.RoundPanel;
import com.tencent.code.intel.ui.pane.RoundedLineBorder;
import com.tencent.code.intel.util.ColorUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NotNull;

public class CompletionLanguageSetting
extends JBPanel
implements IConfigurable {
    private HashMap<String, Boolean> disableLanguages;
    private ComboBox<SettingsForm.ComboBoxItem> newLanguageComboBox;
    private JBTextField textLanguage;
    private JPanel languageCheckboxPane = new RoundPanel(new GridLayout(0, 1));
    private final SettingsForm.ComboBoxItem[] selectItems = new SettingsForm.ComboBoxItem[]{new SettingsForm.ComboBoxItem(LocaleManager.get("ui.settings.completion.language.disable"), ENABLE_ITEM.DISABLE.toString()), new SettingsForm.ComboBoxItem(LocaleManager.get("ui.settings.completion.language.enable"), ENABLE_ITEM.ENABLE.toString())};

    public CompletionLanguageSetting() {
        this.initSetting();
        this.setLayout(new BorderLayout());
        this.createCodeStylePan();
    }

    private void initSetting() {
        this.disableLanguages = new HashMap<String, Boolean>(CopilotSettingsService.getInstance().getDisabledLanguages());
        if (!this.disableLanguages.containsKey("markdown")) {
            this.disableLanguages.put("markdown", false);
            CopilotSettingsService.getInstance().setDisabledLanguages(this.disableLanguages);
        }
    }

    private void createCodeStylePan() {
        TitledSeparator titledSeparator = new TitledSeparator(LocaleManager.get("ui.settings.completion.language.title"));
        this.add((Component)titledSeparator, "North");
        JBTextArea textPane = new JBTextArea();
        textPane.setEditable(false);
        textPane.setForeground((Color)JBColor.GRAY);
        textPane.setBackground(ColorUtils.getBackgroundColor());
        textPane.setLineWrap(true);
        textPane.setText(LocaleManager.get("ui.settings.completion.language.desc"));
        textPane.setFont(UIUtil.getLabelFont());
        this.add((Component)textPane, "Center");
        textPane.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)10, (int)0));
        JPanel languageContainerPane = new JPanel(new BorderLayout());
        JBColor inputBorderColor = new JBColor(new Color(11382450), new Color(9671831));
        CompoundBorder border = BorderFactory.createCompoundBorder(new RoundedLineBorder((Color)inputBorderColor, 1, true, 4), JBUI.Borders.empty((int)6));
        this.languageCheckboxPane.setBorder(border);
        this.refreshLanguage();
        languageContainerPane.add((Component)this.languageCheckboxPane, "North");
        JPanel addLanguagePane = new JPanel(new BorderLayout());
        addLanguagePane.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        this.textLanguage = new JBTextField();
        this.textLanguage.setPreferredSize(new Dimension(300, 30));
        this.textLanguage.getEmptyText().setText(LocaleManager.get("ui.settings.completion.language.hint"));
        addLanguagePane.add((Component)this.textLanguage, "West");
        addLanguagePane.add(this.createComboBox(this.selectItems), "Center");
        JButton button = new JButton(LocaleManager.get("ui.settings.completion.language.add"));
        button.setCursor(Cursor.getPredefinedCursor(12));
        button.addActionListener(this.createAddActionListener());
        addLanguagePane.add((Component)button, "East");
        languageContainerPane.add((Component)addLanguagePane, "Center");
        this.add(languageContainerPane, "South");
    }

    private void refreshLanguage() {
        this.languageCheckboxPane.removeAll();
        for (String language : this.disableLanguages.keySet()) {
            JCheckBox checkBox = new JCheckBox(language);
            checkBox.setSelected(Optional.ofNullable(this.disableLanguages.get(language)).orElse(false));
            checkBox.addActionListener(e -> this.disableLanguages.put(language, checkBox.isSelected()));
            this.languageCheckboxPane.add(checkBox);
        }
    }

    private ActionListener createAddActionListener() {
        return e -> {
            String language = this.textLanguage.getText();
            if (TextUtils.isEmpty((CharSequence)language)) {
                return;
            }
            boolean enable = ENABLE_ITEM.ENABLE.toString().equals(((SettingsForm.ComboBoxItem)this.newLanguageComboBox.getSelectedItem()).getValue());
            this.disableLanguages.put(language, enable);
            this.textLanguage.setText("");
            this.newLanguageComboBox.setSelectedItem((Object)this.selectItems[0]);
            ThreadManager.getInstance().runUiThread(this::refreshLanguage);
        };
    }

    @NotNull
    private JComboBox<SettingsForm.ComboBoxItem> createComboBox(SettingsForm.ComboBoxItem[] items) {
        this.newLanguageComboBox = new ComboBox((Object[])items);
        this.newLanguageComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof SettingsForm.ComboBoxItem) {
                    this.setText(((SettingsForm.ComboBoxItem)value).getText());
                }
                return this;
            }
        });
        Dimension preferredSize = this.newLanguageComboBox.getPreferredSize();
        preferredSize.width = 100;
        this.newLanguageComboBox.setPreferredSize(preferredSize);
        this.newLanguageComboBox.setMaximumSize(preferredSize);
        ComboBox<SettingsForm.ComboBoxItem> comboBox = this.newLanguageComboBox;
        if (comboBox == null) {
            CompletionLanguageSetting.$$$reportNull$$$0(0);
        }
        return comboBox;
    }

    @Override
    public void apply() throws ConfigurationException {
        CopilotSettingsService.getInstance().setDisabledLanguages(this.disableLanguages);
    }

    @Override
    public void reset() {
        this.disableLanguages = new HashMap<String, Boolean>(CopilotSettingsService.getInstance().getDisabledLanguages());
        this.refreshLanguage();
        for (Component component : this.languageCheckboxPane.getComponents()) {
            if (!(component instanceof JCheckBox)) continue;
            JCheckBox checkBox = (JCheckBox)component;
            checkBox.setSelected(Optional.ofNullable(this.disableLanguages.get(checkBox.getText())).orElse(false));
        }
    }

    @Override
    public boolean isModified() {
        return !this.disableLanguages.equals(CopilotSettingsService.getInstance().getDisabledLanguages());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/tencent/code/intel/settings/CompletionLanguageSetting", "createComboBox"));
    }

    public static enum ENABLE_ITEM {
        ENABLE("enable"),
        DISABLE("disable");

        private final String name;

        private ENABLE_ITEM(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

