/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.settings;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.tencent.code.intel.apibridge.util.FusionActionUtils;
import com.tencent.code.intel.impl.CopilotSettingsService;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.settings.IConfigurable;
import com.tencent.code.intel.ui.pane.RoundLabel;
import com.tencent.code.intel.util.ColorUtils;
import com.tencent.code.intel.util.ShortCutUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import javax.swing.JTextPane;
import javax.swing.border.Border;

public class CompletionSetting
extends JBPanel
implements IConfigurable {
    private static final JBColor TEXT_COLOR = new JBColor(7304058, 7304058);
    private boolean autoCompletionEnabled;
    private boolean sideBySideEnable;
    private boolean inlayTipsEnable;
    private boolean inlayToolEnable;
    private boolean preferInlineCompletionEnable;
    private boolean nextEditSuggestionEnable;
    private boolean c2cEnable;
    private boolean isSmartAdaptiveSpeedEnable;
    private JBCheckBox autoCompletionToggle;
    private JBCheckBox sideBySideToggle;
    private JBCheckBox preferInlineCompletionToggle;
    private JBCheckBox inlayTipCloseToggle;
    private JBCheckBox inlayToolToggle;
    private JBCheckBox nextEditSuggestionToggle;
    private JBCheckBox c2cToggle;
    private JBCheckBox smartAdaptiveSpeedToggle;

    public CompletionSetting() {
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 0));
        TitledSeparator titledSeparator = new TitledSeparator(LocaleManager.get("code.completion"));
        this.add((Component)titledSeparator);
        this.autoCompletionEnabled = CopilotSettingsService.getInstance().isActivate();
        this.sideBySideEnable = CopilotSettingsService.getInstance().isSideBySideEnable();
        this.inlayTipsEnable = CopilotSettingsService.getInstance().isInlayTipEnable();
        this.inlayToolEnable = CopilotSettingsService.getInstance().isShowInlayTool();
        this.preferInlineCompletionEnable = CopilotSettingsService.getInstance().isPreferInlineCompletionEnable();
        this.nextEditSuggestionEnable = CopilotSettingsService.getInstance().isNextEditSuggestionEnable();
        this.c2cEnable = CopilotSettingsService.getInstance().isC2CEnable();
        this.isSmartAdaptiveSpeedEnable = CopilotSettingsService.getInstance().isSmartAdaptiveCompletionSpeed();
        this.initCompletionComponent();
        this.initSideBySideComponent();
        this.initInlayComponent();
        this.initInlayToolComponent();
        this.initNextEditComponent();
    }

    private void initSmartSpeedComponent() {
        JBPanel panelSmart = new JBPanel((LayoutManager)new BorderLayout());
        this.smartAdaptiveSpeedToggle = new JBCheckBox(LocaleManager.get("setting.completion.smart_adaptive_peed_title"), this.isSmartAdaptiveSpeedEnable);
        this.smartAdaptiveSpeedToggle.addChangeListener(e -> {
            this.isSmartAdaptiveSpeedEnable = this.smartAdaptiveSpeedToggle.isSelected();
        });
        panelSmart.add((Component)this.smartAdaptiveSpeedToggle, (Object)"North");
        this.add((Component)panelSmart);
    }

    private void initC2CComponent() {
        JBPanel panelC2C = new JBPanel((LayoutManager)new BorderLayout());
        this.c2cToggle = new JBCheckBox(LocaleManager.get("setting.completion.with.deepseek.title"), this.c2cEnable);
        this.c2cToggle.addChangeListener(e -> {
            this.c2cEnable = this.c2cToggle.isSelected();
        });
        panelC2C.add((Component)this.c2cToggle, (Object)"North");
        this.add((Component)panelC2C);
    }

    private void initCompletionComponent() {
        JBPanel panelCompletion = new JBPanel((LayoutManager)new BorderLayout());
        this.autoCompletionToggle = new JBCheckBox(LocaleManager.get("ui.settings.autoComplete.toggle.text"), this.autoCompletionEnabled);
        this.autoCompletionToggle.addChangeListener(e -> {
            this.autoCompletionEnabled = this.autoCompletionToggle.isSelected();
        });
        panelCompletion.add((Component)this.autoCompletionToggle, (Object)"North");
        JBTextArea textPane = new JBTextArea();
        textPane.setEditable(false);
        textPane.setForeground(Color.GRAY);
        textPane.setBackground(ColorUtils.getBackgroundColor());
        textPane.setBorder((Border)JBUI.Borders.empty((int)5, (int)22));
        textPane.setLineWrap(true);
        String triggerActionId = FusionActionUtils.getInternalCommandId("codingcopilot.completions.trigger");
        String shortcut = ShortCutUtils.getShortcutText(triggerActionId, "Alt/Option + \\");
        textPane.setText(LocaleManager.get("ui.settings.autoComplete.toggle.desc", shortcut));
        textPane.setFont(UIUtil.getLabelFont());
        panelCompletion.add((Component)textPane, (Object)"Center");
        this.add((Component)panelCompletion);
    }

    private void initInlayComponent() {
        JBPanel panelInlayTips = new JBPanel((LayoutManager)new BorderLayout());
        this.inlayTipCloseToggle = new JBCheckBox(LocaleManager.get("inlay.accept.tips.close"), !this.inlayTipsEnable);
        this.inlayTipCloseToggle.addChangeListener(e -> {
            this.inlayTipsEnable = !this.inlayTipCloseToggle.isSelected();
        });
        panelInlayTips.add((Component)this.inlayTipCloseToggle, (Object)"North");
        this.add((Component)panelInlayTips);
    }

    private void initInlayToolComponent() {
        JBPanel panelInlayTool = new JBPanel((LayoutManager)new BorderLayout());
        this.inlayToolToggle = new JBCheckBox(LocaleManager.get("inlay.tool.completion.tips"), this.inlayToolEnable);
        this.inlayToolToggle.addChangeListener(e -> {
            this.inlayToolEnable = this.inlayToolToggle.isSelected();
        });
        panelInlayTool.add((Component)this.inlayToolToggle, (Object)"North");
        this.add((Component)panelInlayTool);
    }

    private void initSideBySideComponent() {
        JBPanel panelSideBySide = new JBPanel((LayoutManager)new BorderLayout());
        this.sideBySideToggle = new JBCheckBox(LocaleManager.get("ui.settings.sideBySide.toggle.text"), this.sideBySideEnable);
        this.sideBySideToggle.addChangeListener(e -> {
            this.sideBySideEnable = this.sideBySideToggle.isSelected();
            if (this.sideBySideEnable) {
                panelSideBySide.add((Component)this.preferInlineCompletionToggle, (Object)"South");
            } else {
                panelSideBySide.remove((Component)this.preferInlineCompletionToggle);
            }
        });
        panelSideBySide.add((Component)this.sideBySideToggle, (Object)"North");
        JTextPane textSideBySidePane = new JTextPane();
        textSideBySidePane.setEditable(false);
        textSideBySidePane.setForeground(Color.GRAY);
        textSideBySidePane.setBackground(ColorUtils.getBackgroundColor());
        textSideBySidePane.setBorder((Border)JBUI.Borders.empty((int)5, (int)22));
        textSideBySidePane.setText(LocaleManager.get("ui.settings.sideBySide.toggle.desc"));
        panelSideBySide.add((Component)textSideBySidePane, (Object)"Center");
        this.preferInlineCompletionToggle = new JBCheckBox(LocaleManager.get("ui.settings.sideBySide.acceptCopilot.toggle.text"), this.preferInlineCompletionEnable);
        this.preferInlineCompletionToggle.addChangeListener(e -> {
            this.preferInlineCompletionEnable = this.preferInlineCompletionToggle.isSelected();
        });
        this.preferInlineCompletionToggle.setBorder((Border)JBUI.Borders.empty((int)5, (int)22));
        if (this.sideBySideEnable) {
            panelSideBySide.add((Component)this.preferInlineCompletionToggle, (Object)"South");
        }
        this.add((Component)panelSideBySide);
    }

    private void initNextEditComponent() {
        JBPanel nextEditPanel = new JBPanel((LayoutManager)new FlowLayout(0, 0, 0));
        this.nextEditSuggestionToggle = new JBCheckBox(LocaleManager.get("next.edit.suggestion.tips"), this.nextEditSuggestionEnable);
        this.nextEditSuggestionToggle.addChangeListener(e -> {
            this.nextEditSuggestionEnable = this.nextEditSuggestionToggle.isSelected();
        });
        nextEditPanel.add((Component)this.nextEditSuggestionToggle);
        RoundLabel roundLabel = new RoundLabel(5);
        roundLabel.setFont(roundLabel.getFont().deriveFont(10.0f));
        roundLabel.setText(LocaleManager.get("pre"));
        roundLabel.setBorder(JBUI.Borders.empty((int)3));
        roundLabel.setBackground((Color)JBColor.GRAY);
        roundLabel.setForeground((Color)ColorUtils.getWhiteColor());
        nextEditPanel.add((Component)roundLabel);
        this.add((Component)nextEditPanel);
    }

    @Override
    public void apply() throws ConfigurationException {
        CopilotSettingsService.getInstance().setActivate(this.autoCompletionEnabled);
        CopilotSettingsService.getInstance().setSideBySideEnable(this.sideBySideEnable);
        if (this.inlayTipsEnable != CopilotSettingsService.getInstance().isInlayTipEnable()) {
            CopilotSettingsService.getInstance().setInlayTipEnable(this.inlayTipsEnable);
        }
        CopilotSettingsService.getInstance().setShowInlayTool(this.inlayToolEnable);
        CopilotSettingsService.getInstance().setPreferInlineCompletionEnable(this.preferInlineCompletionEnable);
        CopilotSettingsService.getInstance().setNextEditSuggestionEnable(this.nextEditSuggestionEnable);
    }

    @Override
    public void reset() {
        this.autoCompletionToggle.setSelected(this.autoCompletionEnabled);
        this.sideBySideToggle.setSelected(this.sideBySideEnable);
        this.inlayTipCloseToggle.setSelected(!this.inlayTipsEnable);
        this.inlayToolToggle.setSelected(this.inlayToolEnable);
        if (this.nextEditSuggestionToggle != null) {
            this.nextEditSuggestionToggle.setSelected(this.nextEditSuggestionEnable);
        }
        if (this.smartAdaptiveSpeedToggle != null) {
            this.smartAdaptiveSpeedToggle.setSelected(this.isSmartAdaptiveSpeedEnable);
        }
    }

    @Override
    public boolean isModified() {
        boolean isCompletionModified = this.autoCompletionEnabled != CopilotSettingsService.getInstance().isActivate();
        boolean isSideBySideModified = this.sideBySideEnable != CopilotSettingsService.getInstance().isSideBySideEnable();
        boolean isInlayTipsModified = this.inlayTipsEnable != CopilotSettingsService.getInstance().isInlayTipEnable();
        boolean isInlayToolModified = this.inlayToolEnable != CopilotSettingsService.getInstance().isShowInlayTool();
        boolean isSideBySideAcceptCopilotModified = this.preferInlineCompletionEnable != CopilotSettingsService.getInstance().isPreferInlineCompletionEnable();
        boolean isNextEditModified = this.nextEditSuggestionEnable != CopilotSettingsService.getInstance().isNextEditSuggestionEnable();
        boolean isC2CEnableModified = this.c2cEnable != CopilotSettingsService.getInstance().isC2CEnable();
        return isCompletionModified || isSideBySideModified || isInlayTipsModified || isInlayToolModified || isSideBySideAcceptCopilotModified || isNextEditModified || isC2CEnableModified;
    }

    public boolean isAutoCompletionEnabled() {
        return this.autoCompletionEnabled;
    }

    public boolean isSideBySideEnable() {
        return this.sideBySideEnable;
    }

    public boolean isInlayTipsEnable() {
        return this.inlayTipsEnable;
    }

    public boolean isInlayToolEnable() {
        return this.inlayToolEnable;
    }

    public boolean isPreferInlineCompletionEnable() {
        return this.preferInlineCompletionEnable;
    }

    public boolean isNextEditSuggestionEnable() {
        return this.nextEditSuggestionEnable;
    }

    public boolean isC2cEnable() {
        return this.c2cEnable;
    }

    public boolean isSmartAdaptiveSpeedEnable() {
        return this.isSmartAdaptiveSpeedEnable;
    }
}

