/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.settings;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBUI;
import com.tencent.code.intel.impl.CopilotSettingsService;
import com.tencent.code.intel.settings.IConfigurable;
import com.tencent.code.intel.settings.SettingsForm;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.stream.IntStream;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class EnvSetting
extends JBPanel
implements IConfigurable {
    private JBTextField endpointField;
    private JBPanel endpointPanel;
    private ComboBox<SettingsForm.ComboBoxItem> envRouteModeBox;
    private JBTextField envRouteCustomField;
    private JBPanel envRouteCustomPanel;
    private final SettingsForm.ComboBoxItem[] routeItems = new SettingsForm.ComboBoxItem[]{new SettingsForm.ComboBoxItem("production", "production"), new SettingsForm.ComboBoxItem("canary", "canary"), new SettingsForm.ComboBoxItem("staging", "staging"), new SettingsForm.ComboBoxItem("custom", "custom")};
    private String endpoint;
    private String envRouteMode;
    private String envRouteCustom;

    public EnvSetting() {
        this.initEvnSetting();
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 0));
        this.setupUI();
    }

    private void initEvnSetting() {
        this.endpoint = CopilotSettingsService.getInstance().getEnvEndpoint();
        this.envRouteMode = CopilotSettingsService.getInstance().getEnvRouteMode();
        if (this.envRouteMode == null) {
            this.envRouteMode = "production";
        }
        this.envRouteCustom = CopilotSettingsService.getInstance().getEnvRouteCustom();
    }

    private void setupUI() {
        TitledSeparator titledSeparator = new TitledSeparator("\u73af\u5883\u8bbe\u7f6e");
        this.add((Component)titledSeparator);
        this.add((Component)this.createEndpointPanel());
        this.add((Component)this.createEnvRouteModePan());
        this.add((Component)this.createEnvRouteCustomPanel());
    }

    private JBPanel createEndpointPanel() {
        this.endpointPanel = new JBPanel((LayoutManager)new FlowLayout(0, 0, 0));
        this.endpointPanel.setVisible(true);
        JBLabel labProxyName = new JBLabel("Endpoint: ");
        this.endpointPanel.add((Component)labProxyName);
        JBPanel panTextProxy = new JBPanel((LayoutManager)new FlowLayout(0));
        panTextProxy.setBorder((Border)JBUI.Borders.empty((int)0, (int)10, (int)0, (int)0));
        this.endpointField = new JBTextField(this.endpoint);
        this.endpointField.setPreferredSize(new Dimension(320, 30));
        this.endpointField.setMinimumSize(new Dimension(320, 30));
        this.endpointField.getEmptyText().setText("https://copilot.tencent.com");
        panTextProxy.add((Component)this.endpointField);
        this.endpointPanel.add((Component)panTextProxy);
        return this.endpointPanel;
    }

    private JBPanel createEnvRouteModePan() {
        JBPanel panProxyType = new JBPanel((LayoutManager)new FlowLayout(0, 0, 0));
        JBLabel labProxyTypeName = new JBLabel("Env Route Mode: ");
        panProxyType.add((Component)labProxyTypeName);
        JBPanel panCBProxyType = new JBPanel((LayoutManager)new FlowLayout());
        panCBProxyType.setBorder((Border)JBUI.Borders.empty((int)0, (int)10, (int)0, (int)0));
        JComboBox<SettingsForm.ComboBoxItem> cbProxyType = this.createEnvRouteModeBox(this.routeItems);
        panCBProxyType.add(cbProxyType);
        panProxyType.add((Component)panCBProxyType);
        return panProxyType;
    }

    @NotNull
    private JComboBox<SettingsForm.ComboBoxItem> createEnvRouteModeBox(SettingsForm.ComboBoxItem[] items) {
        this.envRouteModeBox = new ComboBox((Object[])items);
        this.envRouteModeBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof SettingsForm.ComboBoxItem) {
                    this.setText(((SettingsForm.ComboBoxItem)value).getText());
                }
                return this;
            }
        });
        this.envRouteModeBox.addActionListener(e -> {
            SettingsForm.ComboBoxItem selectedItem = (SettingsForm.ComboBoxItem)this.envRouteModeBox.getSelectedItem();
            if (selectedItem != null) {
                this.envRouteMode = selectedItem.getValue();
            }
        });
        Dimension preferredSize = this.envRouteModeBox.getPreferredSize();
        preferredSize.width = 320;
        this.envRouteModeBox.setPreferredSize(preferredSize);
        this.envRouteModeBox.setMaximumSize(preferredSize);
        IntStream.range(0, items.length).filter(i -> items[i].getValue().equals(this.envRouteMode)).findFirst().ifPresent(arg_0 -> this.envRouteModeBox.setSelectedIndex(arg_0));
        ComboBox<SettingsForm.ComboBoxItem> comboBox = this.envRouteModeBox;
        if (comboBox == null) {
            EnvSetting.$$$reportNull$$$0(0);
        }
        return comboBox;
    }

    private JBPanel createEnvRouteCustomPanel() {
        this.envRouteCustomPanel = new JBPanel((LayoutManager)new FlowLayout(0, 0, 0));
        this.envRouteCustomPanel.setVisible(true);
        JBLabel labProxyName = new JBLabel("Env Route Custom: ");
        this.envRouteCustomPanel.add((Component)labProxyName);
        JBPanel panTextProxy = new JBPanel((LayoutManager)new FlowLayout(0));
        panTextProxy.setBorder((Border)JBUI.Borders.empty((int)0, (int)10, (int)0, (int)0));
        this.envRouteCustomField = new JBTextField(this.endpoint);
        this.envRouteCustomField.setPreferredSize(new Dimension(320, 30));
        this.envRouteCustomField.setMinimumSize(new Dimension(320, 30));
        this.envRouteCustomField.getEmptyText().setText("");
        panTextProxy.add((Component)this.envRouteCustomField);
        this.envRouteCustomPanel.add((Component)panTextProxy);
        return this.envRouteCustomPanel;
    }

    @Override
    public void apply() throws ConfigurationException {
        CopilotSettingsService.getInstance().setEnvEndpoint(this.endpoint);
        CopilotSettingsService.getInstance().setEnvRouteMode(this.envRouteMode);
        CopilotSettingsService.getInstance().setEnvRouteCustom(this.envRouteCustom);
    }

    @Override
    public void reset() {
        this.endpointField.setText(this.endpoint);
        this.envRouteModeBox.setSelectedItem(Arrays.stream(this.routeItems).filter(item -> item.getValue().equals(this.envRouteMode)).findFirst().orElse(null));
        this.envRouteCustomField.setText(this.envRouteCustom);
    }

    @Override
    public boolean isModified() {
        String srcEndpoint = CopilotSettingsService.getInstance().getEnvEndpoint();
        String srcEnvRouteMode = CopilotSettingsService.getInstance().getEnvRouteMode();
        String srcEnvRouteCustom = CopilotSettingsService.getInstance().getEnvRouteCustom();
        this.endpoint = this.endpointField.getText();
        this.envRouteMode = ((SettingsForm.ComboBoxItem)this.envRouteModeBox.getSelectedItem()).getValue();
        this.envRouteCustom = this.envRouteCustomField.getText();
        if (this.endpoint != null && !this.endpoint.equals(srcEndpoint)) {
            return true;
        }
        if (this.envRouteMode != null && !this.envRouteMode.equals(srcEnvRouteMode)) {
            return true;
        }
        return this.envRouteCustom != null && !this.envRouteCustom.equals(srcEnvRouteCustom);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getEnvRouteMode() {
        return this.envRouteMode;
    }

    public String getEnvRouteCustom() {
        return this.envRouteCustom;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/tencent/code/intel/settings/EnvSetting", "createEnvRouteModeBox"));
    }
}

