/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.settings;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBUI;
import com.tencent.code.intel.bean.proxy.ProxyConfiguration;
import com.tencent.code.intel.impl.CopilotSettingsService;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.settings.IConfigurable;
import com.tencent.code.intel.settings.SettingsForm;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.stream.IntStream;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NotNull;

public class NetworkProxySetting
extends JBPanel
implements IConfigurable {
    private JBTextField textProxyAddress;
    private ComboBox<SettingsForm.ComboBoxItem> proxyComboBox;
    private String proxyType;
    private String proxyAddress;
    private JBPanel panProxyAddress;
    private final SettingsForm.ComboBoxItem[] netItems = new SettingsForm.ComboBoxItem[]{new SettingsForm.ComboBoxItem(LocaleManager.get("ui.settings.network.proxy.system"), ProxyConfiguration.HttpProxySettings.SYSTEM.getValue()), new SettingsForm.ComboBoxItem(LocaleManager.get("ui.settings.network.proxy.manual"), ProxyConfiguration.HttpProxySettings.MANUAL.getValue())};

    public NetworkProxySetting() {
        this.initSetting();
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 10));
        this.init();
    }

    private void initSetting() {
        String srcProxyAddress = CopilotSettingsService.getInstance().getNetworkProxyAddress();
        String srcProxyType = CopilotSettingsService.getInstance().getNetworkProxyType();
        if (TextUtils.isBlank((CharSequence)srcProxyType)) {
            this.proxyType = ProxyConfiguration.HttpProxySettings.MANUAL.getValue();
            CopilotSettingsService.getInstance().setNetworkProxyType(this.proxyType);
        }
        if (TextUtils.isBlank((CharSequence)srcProxyAddress)) {
            this.proxyAddress = "";
            CopilotSettingsService.getInstance().setNetworkProxyAddress(this.proxyAddress);
        }
    }

    private void init() {
        TitledSeparator titledSeparator = new TitledSeparator(LocaleManager.get("ui.settings.network.proxy.title"));
        this.add((Component)titledSeparator);
        this.panProxyAddress = this.createManualProxyAddressPan();
        this.add((Component)this.createProxyTypePan());
        this.add((Component)this.panProxyAddress);
    }

    private JBPanel createProxyTypePan() {
        JBPanel panProxyType = new JBPanel((LayoutManager)new FlowLayout(0, 0, 0));
        JBLabel labProxyTypeName = new JBLabel(LocaleManager.get("ui.settings.network.proxy.type.title"));
        panProxyType.add((Component)labProxyTypeName);
        JBPanel panCBProxyType = new JBPanel((LayoutManager)new FlowLayout());
        panCBProxyType.setBorder((Border)JBUI.Borders.empty((int)0, (int)10, (int)0, (int)0));
        JComboBox<SettingsForm.ComboBoxItem> cbProxyType = this.createProxyTypeComboBox(this.netItems);
        panCBProxyType.add(cbProxyType);
        panProxyType.add((Component)panCBProxyType);
        return panProxyType;
    }

    @NotNull
    private JComboBox<SettingsForm.ComboBoxItem> createProxyTypeComboBox(SettingsForm.ComboBoxItem[] items) {
        this.proxyComboBox = new ComboBox((Object[])items);
        this.proxyComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof SettingsForm.ComboBoxItem) {
                    this.setText(((SettingsForm.ComboBoxItem)value).getText());
                }
                return this;
            }
        });
        this.proxyComboBox.addActionListener(e -> {
            SettingsForm.ComboBoxItem selectedItem = (SettingsForm.ComboBoxItem)this.proxyComboBox.getSelectedItem();
            if (selectedItem != null) {
                this.proxyType = selectedItem.getValue();
                this.toggleManualProxyPan();
            }
        });
        Dimension preferredSize = this.proxyComboBox.getPreferredSize();
        preferredSize.width = 320;
        this.proxyComboBox.setPreferredSize(preferredSize);
        this.proxyComboBox.setMaximumSize(preferredSize);
        IntStream.range(0, items.length).filter(i -> items[i].getValue().equals(this.proxyType)).findFirst().ifPresent(arg_0 -> this.proxyComboBox.setSelectedIndex(arg_0));
        ComboBox<SettingsForm.ComboBoxItem> comboBox = this.proxyComboBox;
        if (comboBox == null) {
            NetworkProxySetting.$$$reportNull$$$0(0);
        }
        return comboBox;
    }

    private JBPanel createManualProxyAddressPan() {
        this.panProxyAddress = new JBPanel((LayoutManager)new FlowLayout(0, 0, 0));
        this.panProxyAddress.setVisible(false);
        JBLabel labProxyName = new JBLabel(LocaleManager.get("ui.settings.network.proxy.path"));
        this.panProxyAddress.add((Component)labProxyName);
        JBPanel panTextProxy = new JBPanel((LayoutManager)new FlowLayout(0));
        panTextProxy.setBorder((Border)JBUI.Borders.empty((int)0, (int)10, (int)0, (int)0));
        this.textProxyAddress = new JBTextField(this.proxyAddress);
        this.textProxyAddress.setPreferredSize(new Dimension(320, 30));
        this.textProxyAddress.setMinimumSize(new Dimension(320, 30));
        this.textProxyAddress.getEmptyText().setText(LocaleManager.get("ui.settings.network.proxy.path.desc"));
        panTextProxy.add((Component)this.textProxyAddress);
        this.panProxyAddress.add((Component)panTextProxy);
        return this.panProxyAddress;
    }

    private void toggleManualProxyPan() {
        if (this.proxyType.equals(ProxyConfiguration.HttpProxySettings.MANUAL.getValue())) {
            this.panProxyAddress.setVisible(true);
            return;
        }
        this.panProxyAddress.setVisible(false);
    }

    @Override
    public void apply() throws ConfigurationException {
        CopilotSettingsService.getInstance().setNetworkProxyType(this.proxyType);
        CopilotSettingsService.getInstance().setNetworkProxyAddress(this.proxyAddress);
    }

    @Override
    public void reset() {
        String srcProxyType = CopilotSettingsService.getInstance().getNetworkProxyType();
        IntStream.range(0, this.netItems.length).filter(i -> this.netItems[i].getValue().equals(srcProxyType)).findFirst().ifPresent(arg_0 -> this.proxyComboBox.setSelectedIndex(arg_0));
        String srcProxyPath = CopilotSettingsService.getInstance().getNetworkProxyAddress();
        this.textProxyAddress.setText(srcProxyPath);
    }

    @Override
    public boolean isModified() {
        String srcProxyType = CopilotSettingsService.getInstance().getNetworkProxyType();
        this.proxyType = ((SettingsForm.ComboBoxItem)this.proxyComboBox.getSelectedItem()).getValue();
        String srcProxyPath = CopilotSettingsService.getInstance().getNetworkProxyAddress();
        this.proxyAddress = this.textProxyAddress.getText();
        if (srcProxyType == null || srcProxyPath == null) {
            return false;
        }
        return !srcProxyType.equals(this.proxyType) || !srcProxyPath.equals(this.proxyAddress);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/tencent/code/intel/settings/NetworkProxySetting", "createProxyTypeComboBox"));
    }
}

