/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.ui.cr;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.JBUI;
import com.tencent.code.intel.bean.item.CodeReviewComment;
import com.tencent.code.intel.bean.item.CodeReviewTaskResultLevelEnum;
import com.tencent.code.intel.common.SdkIcons;
import com.tencent.code.intel.impl.CodeReviewCommentInLayService;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.ui.sidebar.conversation.chat.notifier.CodeReviewCommentUpdateNotifier;
import com.tencent.code.intel.ui.sidebar.conversation.chat.store.AICRCommentsPersistState;
import com.tencent.code.intel.util.ColorUtils;
import com.tencent.code.intel.util.URLUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;

public class CommentInLayPanel
extends JPanel
implements EditorCustomElementRenderer,
Disposable,
CodeReviewCommentUpdateNotifier {
    public static final int PANEL_RIGHT_OFFSET = 93;
    public static final int COMMENT_CONTENT__RIGHT_OFFSET = 113;
    private Editor editor;
    private final JPanel mainPanel = new JPanel(new BorderLayout());
    private JEditorPane commentContent;
    private boolean isShowInlay = false;
    private final CodeReviewComment comment;
    private Inlay<?> inlay;

    public CommentInLayPanel(Editor editor, CodeReviewComment comment) {
        super(new BorderLayout());
        this.editor = editor;
        this.comment = comment;
        this.setBorder(this.createBorder());
        this.populateMainPanel();
        this.add((Component)this.mainPanel, "Center");
        this.revalidate();
        this.repaint();
        editor.getComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CommentInLayPanel.this.redraw();
            }
        });
        editor.getScrollingModel().addVisibleAreaListener(e -> this.checkInlayVisibility(), (Disposable)this);
        Project project = editor.getProject();
        if (project != null) {
            MessageBus messageBus = project.getMessageBus();
            messageBus.connect((Disposable)this).subscribe(CodeReviewCommentUpdateNotifier.TOPIC, (Object)this);
        }
    }

    private void checkInlayVisibility() {
        if (this.inlay == null) {
            return;
        }
        Rectangle visibleArea = this.editor.getScrollingModel().getVisibleArea();
        Rectangle inlayBounds = this.inlay.getBounds();
        if (inlayBounds == null) {
            return;
        }
        boolean isInVisibleArea = visibleArea.intersects(inlayBounds);
        this.setVisible(isInVisibleArea);
    }

    public void populateMainPanel() {
        this.mainPanel.removeAll();
        this.mainPanel.setBackground((Color)ColorUtils.getEditorBackground());
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)this.createHeaderPanel(), "North");
        northPanel.add((Component)this.createTitleAndFeedbackPanel(), "South");
        this.mainPanel.add((Component)northPanel, "North");
        this.mainPanel.add((Component)this.createContentPanel(), "Center");
        this.mainPanel.add((Component)this.createOperatePanel(), "South");
    }

    private JPanel createOperatePanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        JButton fixButton = new JButton(LocaleManager.get("ui.code.review.action.fix"));
        JButton ignoreButton = new JButton(LocaleManager.get("ui.chat.ai.cr.inlay.comment.ignore.title"));
        fixButton.setCursor(Cursor.getPredefinedCursor(12));
        ignoreButton.addActionListener(e -> {
            CodeReviewCommentInLayService.getInstance().removeCommentInlay(this.comment.getEditor(), this.comment);
            CodeReviewCommentInLayService.getInstance().removeGutter(this.comment.getEditor(), this.comment);
            AICRCommentsPersistState.getInstance().removeCommentById(this.comment.getId());
            Project project = this.editor.getProject();
            if (project != null) {
                ((CodeReviewCommentUpdateNotifier)project.getMessageBus().syncPublisher(CodeReviewCommentUpdateNotifier.TOPIC)).refresh(project);
            }
        });
        ignoreButton.setCursor(Cursor.getPredefinedCursor(12));
        panel.add(ignoreButton);
        panel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        return panel;
    }

    private JPanel createHeaderPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel commentIndexLabel = new JLabel(LocaleManager.get("ui.chat.ai.cr.inlay.comment.index.title", AICRCommentsPersistState.getInstance().getCommentIndex(this.comment) + 1, AICRCommentsPersistState.getInstance().getCommentCount(this.comment)));
        panel.add((Component)commentIndexLabel, "West");
        PreviousCodeReviewCommentAction prevAction = new PreviousCodeReviewCommentAction(this.editor, this.comment);
        Presentation prevPresentation = prevAction.getTemplatePresentation().clone();
        ActionButton prevButton = new ActionButton((AnAction)prevAction, prevPresentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        prevButton.setBorder((Border)JBUI.Borders.empty());
        prevButton.setCursor(Cursor.getPredefinedCursor(12));
        NextCodeReviewCommentAction nextAction = new NextCodeReviewCommentAction(this.editor, this.comment);
        Presentation nextPresentation = nextAction.getTemplatePresentation().clone();
        ActionButton nextButton = new ActionButton((AnAction)nextAction, nextPresentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        nextButton.setBorder((Border)JBUI.Borders.empty());
        nextButton.setCursor(Cursor.getPredefinedCursor(12));
        CollapseCodeReviewCommentAction collapseAction = new CollapseCodeReviewCommentAction(this.editor, this.comment);
        Presentation collapsePresentation = collapseAction.getTemplatePresentation().clone();
        ActionButton closeButton = new ActionButton((AnAction)collapseAction, collapsePresentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        closeButton.setBorder((Border)JBUI.Borders.empty());
        closeButton.setCursor(Cursor.getPredefinedCursor(12));
        JPanel navigationPanel = new JPanel(new FlowLayout(2));
        navigationPanel.add((Component)prevButton);
        navigationPanel.add((Component)nextButton);
        navigationPanel.add((Component)closeButton);
        panel.add((Component)navigationPanel, "East");
        return panel;
    }

    private JComponent createContentPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.commentContent = new JEditorPane();
        this.commentContent.setContentType("text/html");
        String s = this.buildCommentContentHtml(this.comment);
        this.commentContent.setText(s);
        this.commentContent.setCursor(Cursor.getPredefinedCursor(12));
        this.commentContent.setEditable(false);
        this.commentContent.setFocusable(false);
        this.commentContent.setCaretPosition(0);
        this.commentContent.setBackground(ColorUtils.getBackgroundColor());
        this.commentContent.addHyperlinkListener(event -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(event.getEventType())) {
                try {
                    URLUtils.browse(event.getURL().toString());
                }
                catch (Exception e) {
                    LogManager.error(this.getClass(), "Failed to open URL: " + event.getURL().toString() + ", " + e.getMessage());
                }
            }
        });
        this.commentContentSetPreferredSize();
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.add((Component)this.commentContent, "Center");
        textPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)2, (int)5, (int)8));
        panel.add((Component)textPanel, "Center");
        panel.setBorder((Border)JBUI.Borders.emptyLeft((int)12));
        return panel;
    }

    private void commentContentSetPreferredSize() {
        View rootView = this.commentContent.getUI().getRootView(this.commentContent);
        rootView.setSize(this.editor.getComponent().getWidth() - JBUI.scale((int)113), 32767.0f);
        int preferredHeight = (int)rootView.getPreferredSpan(1);
        this.commentContent.setPreferredSize(new Dimension(0, preferredHeight));
    }

    private JPanel createTitleAndFeedbackPanel() {
        JLabel titleLabel = new JLabel(this.buildCommentTitleHtml());
        titleLabel.setIcon(SdkIcons.COPILOT_TOOLS_WINDOW);
        JLabel iconLabel = new JLabel();
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.add((Component)iconLabel, "West");
        titlePanel.add((Component)titleLabel, "East");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)titlePanel, "West");
        return panel;
    }

    private String buildCommentTitleHtml() {
        Document document = Document.createShell((String)"");
        document.outputSettings().prettyPrint(false);
        Element title = new Element(Tag.valueOf((String)"html"), "");
        Element bold = new Element(Tag.valueOf((String)"b"), "");
        bold.text(LocaleManager.get("plugin.copilot.name"));
        title.appendChild((Node)bold);
        return title.outerHtml();
    }

    private String buildCommentContentHtml(CodeReviewComment comment) {
        Document document = Document.createShell((String)"");
        document.outputSettings().prettyPrint(false);
        Element container = new Element(Tag.valueOf((String)"html"), "");
        String category = comment.getResult().getCategory();
        String ruleText = comment.getResult().getCrPointRuleText();
        String ruleUrl = comment.getResult().getCrPointRuleUrl();
        if (category != null && !category.isEmpty()) {
            Element categoryElement = this.buildCategoryElement(comment, category);
            container.appendChild((Node)categoryElement);
        }
        Element content = new Element(Tag.valueOf((String)"span"), "");
        content.text(comment.getResult().getContent());
        container.appendChild((Node)content);
        if (ruleText != null && !ruleText.isEmpty() && ruleUrl != null && !ruleUrl.isEmpty()) {
            container.appendChild((Node)this.buildCRPointTextElement(ruleText, ruleUrl));
        }
        document.body().appendChild((Node)container);
        return document.body().html();
    }

    private Element buildCategoryElement(CodeReviewComment comment, String category) {
        Element categoryElement = new Element(Tag.valueOf((String)"span"), "");
        if (CodeReviewTaskResultLevelEnum.SERIOUS.equals((Object)CodeReviewTaskResultLevelEnum.fromCode(comment.getResult().getLevel()))) {
            categoryElement.attr("style", "color: #D32F2F;");
        } else {
            categoryElement.attr("style", "color: #FFA500;");
        }
        categoryElement.text("\u3010" + category + "\u3011");
        return categoryElement;
    }

    private Element buildCRPointTextElement(String ruleText, String ruleUrl) {
        Element container = new Element(Tag.valueOf((String)"span"), "");
        Element ruleLink = new Element(Tag.valueOf((String)"a"), "");
        ruleLink.attr("href", ruleUrl);
        ruleLink.attr("style", "color:#2196F3;");
        ruleLink.text(ruleText);
        container.appendChild((Node)ruleLink);
        return container;
    }

    public void createInlay(int offset) {
        this.inlay = this.editor.getInlayModel().addBlockElement(offset, false, false, 1, (EditorCustomElementRenderer)this);
    }

    private Border createBorder() {
        RoundedLineBorder roundedLineBorder = new RoundedLineBorder(ColorUtils.getBackgroundColor(), 8, 1);
        return BorderFactory.createCompoundBorder((Border)JBUI.Borders.emptyLeft((int)5), BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder((Border)JBUI.Borders.empty(), (Border)roundedLineBorder), BorderFactory.createCompoundBorder((Border)new RoundedLineBorder(ColorUtils.getBackgroundColor(), 8, 1), BorderFactory.createMatteBorder(2, 2, 2, 2, ColorUtils.getBackgroundColor()))));
    }

    public int calcWidthInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            CommentInLayPanel.$$$reportNull$$$0(0);
        }
        int width = this.editor.getComponent().getWidth() - JBUI.scale((int)93);
        return Math.max(width, 1);
    }

    public int calcHeightInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            CommentInLayPanel.$$$reportNull$$$0(1);
        }
        int height = this.getPreferredSize().height;
        return this.isShowInlay ? Math.max(height, 1) : 0;
    }

    public void toggleVisibility() {
        this.isShowInlay = !this.isShowInlay;
        this.showInlay();
    }

    public void showInlay() {
        this.setVisible(this.isShowInlay);
        if (this.inlay != null) {
            this.inlay.update();
        }
    }

    public void paint(@NotNull Inlay inlay, @NotNull Graphics2D g, @NotNull Rectangle2D targetRegion, @NotNull TextAttributes textAttributes) {
        Rectangle it;
        if (inlay == null) {
            CommentInLayPanel.$$$reportNull$$$0(2);
        }
        if (g == null) {
            CommentInLayPanel.$$$reportNull$$$0(3);
        }
        if (targetRegion == null) {
            CommentInLayPanel.$$$reportNull$$$0(4);
        }
        if (textAttributes == null) {
            CommentInLayPanel.$$$reportNull$$$0(5);
        }
        if ((it = inlay.getBounds()) == null || this.getBounds().equals(it)) {
            return;
        }
        this.setBounds(it);
        this.revalidate();
        this.repaint();
    }

    public void redraw() {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.commentContentSetPreferredSize();
            int newWidth = this.editor.getComponent().getWidth() - JBUI.scale((int)93);
            this.setSize(new Dimension(newWidth, this.getPreferredSize().height));
            Inlay<?> inlay = this.getInlay();
            if (inlay != null) {
                inlay.update();
            }
            this.revalidate();
            this.repaint();
        });
    }

    public void dispose() {
        if (this.inlay != null) {
            this.inlay.dispose();
        }
    }

    @Override
    public void refresh(@Nullable Project project) {
        if (project == null) {
            return;
        }
        if (this.inlay == null) {
            return;
        }
        ThreadManager.getInstance().runUiThread(() -> {
            this.populateMainPanel();
            SwingUtilities.updateComponentTreeUI(this);
            this.repaint();
            this.revalidate();
            this.redraw();
            this.showInlay();
        });
    }

    @Override
    public void clear() {
    }

    public void setEditor(Editor editor) {
        this.editor = editor;
    }

    public void setShowInlay(boolean isShowInlay) {
        this.isShowInlay = isShowInlay;
    }

    public boolean isShowInlay() {
        return this.isShowInlay;
    }

    public CodeReviewComment getComment() {
        return this.comment;
    }

    public void setInlay(Inlay<?> inlay) {
        this.inlay = inlay;
    }

    public Inlay<?> getInlay() {
        return this.inlay;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRegion";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
        }
        objectArray2[1] = "com/tencent/code/intel/ui/cr/CommentInLayPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calcWidthInPixels";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calcHeightInPixels";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class NextCodeReviewCommentAction
    extends AnAction {
        private final CodeReviewComment comment;

        public NextCodeReviewCommentAction(Editor editor, CodeReviewComment comment) {
            super(LocaleManager.get("ui.chat.ai.cr.inlay.comment.next.title"), LocaleManager.get("ui.chat.ai.cr.inlay.comment.next.title"), AllIcons.Actions.FindAndShowNextMatchesSmall);
            this.comment = comment;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                NextCodeReviewCommentAction.$$$reportNull$$$0(0);
            }
            CodeReviewCommentInLayService.getInstance().navigateToNext(this.comment);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/tencent/code/intel/ui/cr/CommentInLayPanel$NextCodeReviewCommentAction", "actionPerformed"));
        }
    }

    public static class PreviousCodeReviewCommentAction
    extends AnAction {
        private final CodeReviewComment comment;

        public PreviousCodeReviewCommentAction(Editor editor, CodeReviewComment comment) {
            super(LocaleManager.get("ui.chat.ai.cr.inlay.comment.previous.title"), LocaleManager.get("ui.chat.ai.cr.inlay.comment.previous.title"), AllIcons.Actions.FindAndShowPrevMatchesSmall);
            this.comment = comment;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                PreviousCodeReviewCommentAction.$$$reportNull$$$0(0);
            }
            CodeReviewCommentInLayService.getInstance().navigateToPrevious(this.comment);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/tencent/code/intel/ui/cr/CommentInLayPanel$PreviousCodeReviewCommentAction", "actionPerformed"));
        }
    }

    public class CollapseCodeReviewCommentAction
    extends AnAction {
        private final CodeReviewComment comment;

        public CollapseCodeReviewCommentAction(Editor editor, CodeReviewComment comment) {
            super(LocaleManager.get("ui.chat.ai.cr.inlay.comment.collapse.title"), LocaleManager.get("ui.chat.ai.cr.inlay.comment.collapse.title"), AllIcons.General.CollapseComponentHover);
            this.comment = comment;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CollapseCodeReviewCommentAction.$$$reportNull$$$0(0);
            }
            CommentInLayPanel.this.toggleVisibility();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/tencent/code/intel/ui/cr/CommentInLayPanel$CollapseCodeReviewCommentAction", "actionPerformed"));
        }
    }
}

