/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.ui.hintpop;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.util.Disposer;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.ExtHostLanguageFeatures;
import com.tencent.code.intel.apibridge.util.FusionActionUtils;
import com.tencent.code.intel.impl.InlayService;
import com.tencent.code.intel.listener.CopilotLookupManagerListener;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.ui.hintpop.PopUpPanel;
import com.tencent.code.intel.util.CollectionUtils;
import com.tencent.code.intel.util.ColorUtils;
import com.tencent.code.intel.util.HintUtils;
import com.tencent.code.intel.util.ShortCutUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NotNull;

public class CompletionPreviewInsertionHint
implements Disposable,
EditorMouseMotionListener,
EditorMouseListener {
    private final Editor editor;
    private int offset;
    private boolean isShowing = false;
    private PopUpPanel popUpPanel;
    private boolean isDispose;

    public CompletionPreviewInsertionHint(Editor editor, Inlay<?> inlay, int offset) {
        this.editor = editor;
        this.offset = offset;
        this.popUpPanel = CompletionPreviewInsertionHint.createCopilotPopUpPanel(editor);
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)this);
        editor.addEditorMouseListener((EditorMouseListener)this);
        this.isDispose = false;
        Disposer.register(inlay, (Disposable)this);
    }

    public void mouseExited(@NotNull EditorMouseEvent event) {
        if (event == null) {
            CompletionPreviewInsertionHint.$$$reportNull$$$0(0);
        }
        super.mouseExited(event);
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        String remainText;
        if (e == null) {
            CompletionPreviewInsertionHint.$$$reportNull$$$0(1);
        }
        if (TextUtils.isEmpty((CharSequence)(remainText = ExtHostLanguageFeatures.remainText.get(this.editor.getProject())))) {
            return;
        }
        if (CopilotLookupManagerListener.hasLookUp(this.editor)) {
            return;
        }
        MouseEvent mouseEvent = e.getMouseEvent();
        Point point = mouseEvent.getPoint();
        if (e.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        if (!this.canShow(point)) {
            this.hideHint();
        } else {
            if (this.isShowing) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)remainText)) {
                this.hideHint();
                try {
                    Point newPoint = this.editor.offsetToXY(this.offset);
                    this.popUpPanel.updateDisplay();
                    SwingUtilities.updateComponentTreeUI((Component)((Object)this.popUpPanel));
                    HintUtils.createAndShowHint(newPoint, this.editor.getContentComponent(), (JComponent)((Object)this.popUpPanel));
                    this.isShowing = true;
                }
                catch (Exception e2) {
                    LogManager.warn(CompletionPreviewInsertionHint.class, "show hint error:" + String.valueOf(e2));
                }
            }
        }
    }

    public void dispose() {
        if (!this.isDispose) {
            this.editor.removeEditorMouseMotionListener((EditorMouseMotionListener)this);
            this.editor.removeEditorMouseListener((EditorMouseListener)this);
        }
        this.isDispose = true;
    }

    private boolean canShow(Point p) {
        List<Inlay<?>> inlays = InlayService.getInstance().getAllInlays();
        if (CollectionUtils.isEmpty(inlays)) {
            return false;
        }
        boolean isInPreview = inlays.stream().anyMatch(inlay -> Optional.ofNullable(inlay).map(Inlay::getBounds).filter(bounds -> bounds.contains(p)).isPresent());
        if (isInPreview) {
            return true;
        }
        int maxOffset = this.editor.getDocument().getTextLength();
        if (this.offset > maxOffset) {
            return false;
        }
        int mouseLine = this.editor.xyToLogicalPosition((Point)p).line;
        int lineNumber = this.editor.getDocument().getLineNumber(this.offset);
        return mouseLine == lineNumber;
    }

    public void hideHint() {
        this.isShowing = false;
        HintUtils.hideHint();
    }

    private static PopUpPanel createCopilotPopUpPanel(final @NotNull Editor editor) {
        if (editor == null) {
            CompletionPreviewInsertionHint.$$$reportNull$$$0(2);
        }
        final DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
        PopUpPanel panel = new PopUpPanel(editor.getProject());
        panel.setBackground(ColorUtils.getBackgroundColor());
        panel.setActionListener(new PopUpPanel.ActionListener(){

            @Override
            public void next() {
            }

            @Override
            public void previous() {
            }

            @Override
            public void line() {
                if (editor == null || editor.getProject() == null) {
                    return;
                }
                String actionId = FusionActionUtils.getInternalCommandId("codingcopilot.completions.accept.line");
                FusionActionUtils.shortCutPerformAction(actionId, dataContext);
            }

            @Override
            public void word() {
                if (editor == null || editor.getProject() == null) {
                    return;
                }
                String actionId = FusionActionUtils.getInternalCommandId("codingcopilot.completions.accept.word");
                FusionActionUtils.shortCutPerformAction(actionId, dataContext);
            }

            @Override
            public void esc() {
                ShortCutUtils.performActionHandler("EditorEscape", editor, dataContext);
            }

            @Override
            public void accept() {
                if (editor == null || editor.getProject() == null) {
                    return;
                }
                String actionId = FusionActionUtils.getInternalCommandId("codingcopilot.completions.accept.all");
                FusionActionUtils.shortCutPerformAction(actionId, dataContext);
            }

            @Override
            public void feedback(boolean good) {
            }
        });
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/tencent/code/intel/ui/hintpop/CompletionPreviewInsertionHint";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseExited";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseMoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createCopilotPopUpPanel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

