/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.ui.hintpop;

import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.tencent.code.intel.common.SdkIcons;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.ui.pane.HoverButton;
import com.tencent.code.intel.util.ColorUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;

public class DiffPopUpPanel
extends BorderLayoutPanel {
    private JBPanel<?> totalPanel;
    private static final int TEXT_AREA_GAP = 5;
    private static final int TEXT_AREA_GAP_SHORT = 2;
    private static final int BUTTON_GAP = 16;
    private ActionListener actionListener;

    public DiffPopUpPanel(Project project) {
        this.initPanel(project);
    }

    private void initPanel(Project project) {
        this.totalPanel = new JBPanel();
        this.totalPanel.setBackground(ColorUtils.getBackgroundColor());
        this.totalPanel.setLayout((LayoutManager)new BoxLayout((Container)this.totalPanel, 3));
        this.totalPanel.setAlignmentX(0.0f);
        JBPanel diffPanel = new JBPanel((LayoutManager)new FlowLayout(0, 0, 0));
        diffPanel.setAlignmentX(0.0f);
        diffPanel.setBackground(ColorUtils.getBackgroundColor());
        diffPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        HoverButton codeExplainBt = new HoverButton(LocaleManager.get("code_explain"), null, 16, e -> {
            if (this.actionListener != null) {
                this.actionListener.explain();
            }
        });
        HoverButton codeCompletionBt = new HoverButton(LocaleManager.get("code_completion"), null, 16, e -> {
            if (this.actionListener != null) {
                this.actionListener.completion();
            }
        });
        HoverButton codeOptimizationBt = new HoverButton(LocaleManager.get("code_optimization"), null, 16, e -> {
            if (this.actionListener != null) {
                this.actionListener.optimization();
            }
        });
        HoverButton unitTestingBt = new HoverButton(LocaleManager.get("unit_testing"), null, 16, e -> {
            if (this.actionListener != null) {
                this.actionListener.test();
            }
        });
        HoverButton defectInspectionBt = new HoverButton(LocaleManager.get("defect_inspection"), null, 16, e -> {
            if (this.actionListener != null) {
                this.actionListener.inspection();
            }
        });
        JBLabel logoLb = new JBLabel("", SdkIcons.COPILOT_ACTIVATE, 2);
        logoLb.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        diffPanel.add((Component)logoLb);
        diffPanel.add((Component)codeExplainBt);
        diffPanel.add((Component)codeCompletionBt);
        diffPanel.add((Component)codeOptimizationBt);
        diffPanel.add((Component)unitTestingBt);
        diffPanel.add((Component)defectInspectionBt);
        this.totalPanel.add((Component)diffPanel);
        this.addToTop((Component)this.totalPanel);
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public static interface ActionListener {
        public void explain();

        public void completion();

        public void optimization();

        public void test();

        public void inspection();
    }
}

