/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.ui.hintpop;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.tencent.code.intel.apibridge.util.FusionActionUtils;
import com.tencent.code.intel.common.SdkIcons;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.ui.pane.HoverButton;
import com.tencent.code.intel.util.ColorUtils;
import com.tencent.code.intel.util.PluginUtils;
import com.tencent.code.intel.util.ShortCutUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;

public class PopUpPanel
extends BorderLayoutPanel {
    private JBLabel indexLb;
    private JBPanel<?> totalPanel;
    private JButton leftBt;
    private JButton rightBt;
    private static final int TEXT_AREA_GAP = 5;
    private static final int TEXT_AREA_GAP_SHORT = 2;
    private static final int BUTTON_GAP = 16;
    private ActionListener actionListener;
    private Project project;

    public PopUpPanel(Project project) {
        this.initPanel(project);
    }

    private void initPanel(Project project) {
        this.project = project;
        boolean isMac = PluginUtils.isMac();
        this.totalPanel = new JBPanel();
        this.totalPanel.setBackground(ColorUtils.getBackgroundColor());
        this.totalPanel.setLayout((LayoutManager)new BoxLayout((Container)this.totalPanel, 3));
        this.totalPanel.setAlignmentX(0.0f);
        JBPanel suggestionPanel = new JBPanel((LayoutManager)new FlowLayout(0, 0, 0));
        suggestionPanel.setAlignmentX(0.0f);
        suggestionPanel.setBackground(ColorUtils.getBackgroundColor());
        suggestionPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 4));
        this.indexLb = new JBLabel("2/2 "){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = ShortCutUtils.getTextLength("2/2") + 10;
                return size;
            }
        };
        this.indexLb.setForeground((Color)ColorUtils.getTextColor());
        this.indexLb.setBackground(ColorUtils.getBackgroundColor());
        this.indexLb.setHorizontalAlignment(0);
        Icon leftIcon = SdkIcons.COPILOT_LEFT;
        this.leftBt = new HoverButton("", leftIcon, 0, e -> {
            if (this.actionListener != null) {
                this.actionListener.previous();
            }
            ThreadManager.getInstance().runUiThreadSave(this::updateDisplay);
        });
        Icon rightIcon = SdkIcons.COPILOT_RIGHT;
        this.rightBt = new HoverButton("", rightIcon, 0, e -> {
            if (this.actionListener != null) {
                this.actionListener.next();
            }
            ThreadManager.getInstance().runUiThreadSave(this::updateDisplay);
        });
        String acceptActionId = FusionActionUtils.getInternalCommandId("codingcopilot.completions.accept.all");
        String acceptTitle = LocaleManager.get("all_accept") + " (" + ShortCutUtils.getShortcutText(acceptActionId, LocaleManager.get("tab")) + ")";
        HoverButton acceptShortBt = new HoverButton(acceptTitle, null, 16, e -> {
            if (this.actionListener != null) {
                this.actionListener.accept();
            }
        });
        String lineShort = isMac ? "\u2303\u2318\u2192" : LocaleManager.get("ctrl") + " " + LocaleManager.get("alt") + " \u2192";
        String lineActionId = FusionActionUtils.getInternalCommandId("codingcopilot.completions.accept.line");
        String lineAcceptTitle = LocaleManager.get("accept_by_line") + " (" + ShortCutUtils.getShortcutText(lineActionId, lineShort) + ")";
        HoverButton lineAcceptShortBt = new HoverButton(lineAcceptTitle, null, 16, e -> {
            if (this.actionListener != null) {
                this.actionListener.line();
            }
        });
        String wordShort = isMac ? "\u2318\u2192" : LocaleManager.get("ctrl") + " \u2192";
        String wordActionId = FusionActionUtils.getInternalCommandId("codingcopilot.completions.accept.word");
        AnAction anAction = ActionManager.getInstance().getAction(wordActionId);
        String wordAcceptTitle = LocaleManager.get("accept_by_word") + " (" + ShortCutUtils.getShortcutText(wordActionId, wordShort) + ")";
        HoverButton wordAcceptShortBt = new HoverButton(wordAcceptTitle, null, 16, e -> {
            if (this.actionListener != null) {
                this.actionListener.word();
            }
        });
        String cancelTitle = LocaleManager.get("cancel") + " (" + LocaleManager.get("esc") + ")";
        HoverButton cancelLbShortBt = new HoverButton(cancelTitle, null, 16, e -> {
            if (this.actionListener != null) {
                this.actionListener.esc();
            }
        });
        JBLabel logoLb = new JBLabel("", SdkIcons.COPILOT_ACTIVATE, 2);
        logoLb.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        HoverButton approveBt = new HoverButton(LocaleManager.get("approve"), SdkIcons.COPILOT_THUMBS_UP, 16, e -> {
            if (this.actionListener != null) {
                this.actionListener.feedback(true);
            }
        });
        HoverButton trampleBt = new HoverButton(LocaleManager.get("trample"), SdkIcons.COPILOT_THUMBS_DOWN, 16, e -> {
            if (this.actionListener != null) {
                this.actionListener.feedback(false);
            }
        });
        suggestionPanel.add((Component)logoLb);
        suggestionPanel.add((Component)acceptShortBt);
        suggestionPanel.add((Component)lineAcceptShortBt);
        suggestionPanel.add((Component)wordAcceptShortBt);
        suggestionPanel.add((Component)cancelLbShortBt);
        suggestionPanel.add(Box.createHorizontalStrut(5));
        this.totalPanel.add((Component)suggestionPanel);
        this.addToTop((Component)this.totalPanel);
        ApplicationManager.getApplication().invokeLater(this::updateDisplay);
    }

    public void updateDisplay() {
        this.leftBt.setEnabled(false);
        this.rightBt.setEnabled(false);
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public static interface ActionListener {
        public void next();

        public void previous();

        public void line();

        public void word();

        public void esc();

        public void accept();

        public void feedback(boolean var1);
    }
}

