/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.ui.inlay;

import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.tencent.code.intel.bean.item.InlayColorItem;
import com.tencent.code.intel.common.Indent;
import com.tencent.code.intel.common.SdkIcons;
import com.tencent.code.intel.impl.InlayService;
import com.tencent.code.intel.util.CollectionUtils;
import com.tencent.code.intel.util.PaintUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopilotInlayRender
implements EditorCustomElementRenderer {
    private final String source;
    private final List<String> solutions;
    private final int tabSize;
    private Color bgColor;
    private Color fgColor;
    private int offsetX;
    private List<List<InlayColorItem>> inlayColorItems;
    private final Icon logo = SdkIcons.COPILOT_ACTIVATE_10;
    private boolean isShowLogo;
    private int borderWidth;
    private Color borderColor;

    public int calcWidthInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            CopilotInlayRender.$$$reportNull$$$0(0);
        }
        return InlayService.getInstance().calculateWidth(inlay.getEditor(), this.source, this.solutions.stream().map(s -> s.replaceAll(Indent.Tab.toString(), Indent.Space.toString().repeat(this.tabSize))).collect(Collectors.toList()));
    }

    public int calcHeightInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            CopilotInlayRender.$$$reportNull$$$0(1);
        }
        return inlay.getEditor().getLineHeight() * this.solutions.size();
    }

    public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle region, @NotNull TextAttributes textAttributes) {
        if (inlay == null) {
            CopilotInlayRender.$$$reportNull$$$0(2);
        }
        if (g == null) {
            CopilotInlayRender.$$$reportNull$$$0(3);
        }
        if (region == null) {
            CopilotInlayRender.$$$reportNull$$$0(4);
        }
        if (textAttributes == null) {
            CopilotInlayRender.$$$reportNull$$$0(5);
        }
        if (!TextUtils.isEmpty((CharSequence)this.source) && !CollectionUtils.isEmpty(this.solutions)) {
            double lineHeight = inlay.getEditor().getLineHeight();
            Rectangle clipBounds = g.getClipBounds();
            int iconXOffset = this.isShowLogo && this.logo != null ? this.logo.getIconWidth() + 2 : 0;
            int iconYOffset = this.isShowLogo && this.logo != null ? ((int)lineHeight - this.logo.getIconHeight()) / 2 : 0;
            Rectangle newRegion = new Rectangle(region.x, region.y, region.width + 2 + iconXOffset, region.height);
            if (this.offsetX > 0) {
                newRegion.x = this.offsetX + newRegion.x;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            GraphicsUtil.setupAAPainting((Graphics)g2);
            Font font = InlayService.getInstance().getFont(inlay.getEditor(), String.join((CharSequence)System.lineSeparator(), this.solutions));
            g2.setFont(font);
            FontMetrics metrics = InlayService.getInstance().getFontMetrics(inlay.getEditor(), font);
            double fontBaseline = Math.ceil(font.createGlyphVector(metrics.getFontRenderContext(), "Alb").getVisualBounds().getHeight());
            double linePadding = (lineHeight - fontBaseline) / 2.0;
            double offsetX = newRegion.getX() + (double)iconXOffset;
            double offsetY = newRegion.getY() + fontBaseline + linePadding;
            int lineOffset = 0;
            g2.setClip(clipBounds != null && !clipBounds.equals(newRegion) ? newRegion.createIntersection(clipBounds) : newRegion);
            for (int i = 0; i < this.solutions.size(); ++i) {
                List<InlayColorItem> items;
                String solution = this.solutions.get(i);
                solution = solution.replaceAll(Indent.Tab.toString(), Indent.Space.toString().repeat(this.tabSize));
                this.renderBackground(g2, this.bgColor == null ? textAttributes.getBackgroundColor() : this.bgColor, offsetX, newRegion.getY() + (double)lineOffset, newRegion.getWidth(), lineHeight);
                if (CollectionUtils.isNotEmpty(this.inlayColorItems) && this.inlayColorItems.size() > i && (items = this.inlayColorItems.get(i)) != null) {
                    for (InlayColorItem item : items) {
                        if (item.getTargetPosition() + item.getTargetLength() > solution.length()) continue;
                        String offsetString = solution.substring(0, Math.min(item.getTargetPosition(), solution.length()));
                        String inlayString = solution.substring(item.getTargetPosition(), item.getTargetPosition() + item.getTargetLength());
                        this.renderBackground(g2, item.getBgColor(), offsetX + (double)metrics.stringWidth(offsetString), newRegion.getY() + (double)lineOffset, metrics.stringWidth(inlayString), lineHeight);
                        this.renderBorder(g2, offsetX + (double)metrics.stringWidth(offsetString), newRegion.getY() + (double)lineOffset, metrics.stringWidth(inlayString), lineHeight);
                    }
                }
                g2.setColor((Color)(this.fgColor == null ? JBColor.GRAY : this.fgColor));
                g2.drawString(solution, (float)offsetX, (float)(offsetY + (double)lineOffset));
                if (inlay.getEditor() instanceof EditorImpl) {
                    PaintUtils.renderEffect(g2, offsetX, offsetY + (double)lineOffset, metrics.stringWidth(solution), ((EditorImpl)inlay.getEditor()).getCharHeight(), ((EditorImpl)inlay.getEditor()).getDescent(), textAttributes, font);
                }
                lineOffset = (int)((double)lineOffset + lineHeight);
            }
            if (this.isShowLogo && this.logo != null) {
                this.logo.paintIcon(null, g2, newRegion.x, newRegion.y + iconYOffset);
            }
            g2.dispose();
        }
    }

    @Nullable
    @NonNls
    public String getContextMenuGroupId(@NotNull Inlay inlay) {
        if (inlay == null) {
            CopilotInlayRender.$$$reportNull$$$0(6);
        }
        return "tencent.code.copilot.inlayMenu";
    }

    private void renderBackground(Graphics2D g, Color color, double x, double y, double width, double height) {
        if (color != null) {
            g.setColor(color);
            g.fillRoundRect((int)x, (int)y, (int)width, (int)height, 1, 1);
        }
    }

    private void renderBorder(Graphics2D g, double x, double y, double width, double height) {
        if (this.borderWidth > 0 && this.borderColor != null) {
            g.setColor(this.borderColor);
            for (int i = 0; i < this.borderWidth; ++i) {
                g.drawRoundRect((int)x + i, (int)y + i, (int)width - 2 * i, (int)height - 2 * i, 1, 1);
            }
        }
    }

    CopilotInlayRender(String source, List<String> solutions, int tabSize, Color bgColor, Color fgColor, int offsetX, List<List<InlayColorItem>> inlayColorItems, boolean isShowLogo, int borderWidth, Color borderColor) {
        this.source = source;
        this.solutions = solutions;
        this.tabSize = tabSize;
        this.bgColor = bgColor;
        this.fgColor = fgColor;
        this.offsetX = offsetX;
        this.inlayColorItems = inlayColorItems;
        this.isShowLogo = isShowLogo;
        this.borderWidth = borderWidth;
        this.borderColor = borderColor;
    }

    public static CopilotInlayRenderBuilder builder() {
        return new CopilotInlayRenderBuilder();
    }

    public List<String> getSolutions() {
        return this.solutions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
        }
        objectArray2[1] = "com/tencent/code/intel/ui/inlay/CopilotInlayRender";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calcWidthInPixels";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calcHeightInPixels";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextMenuGroupId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CopilotInlayRenderBuilder {
        private String source;
        private List<String> solutions;
        private int tabSize;
        private Color bgColor;
        private Color fgColor;
        private int offsetX;
        private List<List<InlayColorItem>> inlayColorItems;
        private boolean isShowLogo;
        private int borderWidth;
        private Color borderColor;

        CopilotInlayRenderBuilder() {
        }

        public CopilotInlayRenderBuilder source(String source) {
            this.source = source;
            return this;
        }

        public CopilotInlayRenderBuilder solutions(List<String> solutions) {
            this.solutions = solutions;
            return this;
        }

        public CopilotInlayRenderBuilder tabSize(int tabSize) {
            this.tabSize = tabSize;
            return this;
        }

        public CopilotInlayRenderBuilder bgColor(Color bgColor) {
            this.bgColor = bgColor;
            return this;
        }

        public CopilotInlayRenderBuilder fgColor(Color fgColor) {
            this.fgColor = fgColor;
            return this;
        }

        public CopilotInlayRenderBuilder offsetX(int offsetX) {
            this.offsetX = offsetX;
            return this;
        }

        public CopilotInlayRenderBuilder inlayColorItems(List<List<InlayColorItem>> inlayColorItems) {
            this.inlayColorItems = inlayColorItems;
            return this;
        }

        public CopilotInlayRenderBuilder isShowLogo(boolean isShowLogo) {
            this.isShowLogo = isShowLogo;
            return this;
        }

        public CopilotInlayRenderBuilder borderWidth(int borderWidth) {
            this.borderWidth = borderWidth;
            return this;
        }

        public CopilotInlayRenderBuilder borderColor(Color borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        public CopilotInlayRender build() {
            return new CopilotInlayRender(this.source, this.solutions, this.tabSize, this.bgColor, this.fgColor, this.offsetX, this.inlayColorItems, this.isShowLogo, this.borderWidth, this.borderColor);
        }

        public String toString() {
            return "CopilotInlayRender.CopilotInlayRenderBuilder(source=" + this.source + ", solutions=" + String.valueOf(this.solutions) + ", tabSize=" + this.tabSize + ", bgColor=" + String.valueOf(this.bgColor) + ", fgColor=" + String.valueOf(this.fgColor) + ", offsetX=" + this.offsetX + ", inlayColorItems=" + String.valueOf(this.inlayColorItems) + ", isShowLogo=" + this.isShowLogo + ", borderWidth=" + this.borderWidth + ", borderColor=" + String.valueOf(this.borderColor) + ")";
        }
    }
}

