/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.ui.inlayhints;

import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.JBColor;
import com.tencent.code.intel.impl.InlayService;
import com.tencent.code.intel.util.PaintUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CopilotInlayPresentation
extends BasePresentation {
    private final Editor editor;
    private final String inlayHintText;
    private final int elementTextOffset;

    public CopilotInlayPresentation(Editor editor, String inlayHintText, int elementTextOffset) {
        this.editor = editor;
        this.inlayHintText = inlayHintText;
        this.elementTextOffset = elementTextOffset;
    }

    public int getHeight() {
        return this.editor.getLineHeight();
    }

    public int getWidth() {
        return InlayService.getInstance().calculateWidth(this.editor, this.editor.getDocument().getText(), List.of(this.inlayHintText));
    }

    public void paint(@NotNull Graphics2D graphics2D, @NotNull TextAttributes textAttributes) {
        if (graphics2D == null) {
            CopilotInlayPresentation.$$$reportNull$$$0(0);
        }
        if (textAttributes == null) {
            CopilotInlayPresentation.$$$reportNull$$$0(1);
        }
        if (this.inlayHintText != null && !this.inlayHintText.isEmpty()) {
            Font font = InlayService.getInstance().getFont(this.editor, this.inlayHintText);
            font = font.deriveFont((float)font.getSize() - 2.0f);
            graphics2D.setFont(font);
            FontMetrics metrics = InlayService.getInstance().getFontMetrics(this.editor, font);
            double fontBaseline = Math.ceil(font.createGlyphVector(metrics.getFontRenderContext(), "Alb").getVisualBounds().getHeight());
            double lineHeight = this.editor.getLineHeight();
            double linePadding = (lineHeight - fontBaseline) / 2.0;
            graphics2D.setColor((Color)JBColor.GRAY);
            Point2D point2D = this.editor.offsetToPoint2D(this.elementTextOffset);
            graphics2D.drawString(this.inlayHintText, (int)point2D.getX(), (int)(fontBaseline + linePadding));
            if (this.editor instanceof EditorImpl) {
                EditorImpl editorImpl = (EditorImpl)this.editor;
                PaintUtils.renderEffect(graphics2D, point2D.getX(), fontBaseline, metrics.stringWidth(this.inlayHintText), editorImpl.getCharHeight(), editorImpl.getDescent(), textAttributes, font);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "graphics2D";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "textAttributes";
                break;
            }
        }
        objectArray[1] = "com/tencent/code/intel/ui/inlayhints/CopilotInlayPresentation";
        objectArray[2] = "paint";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

