/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.ui.inline;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.tencent.code.intel.apibridge.extension.extension.command.ExtHostCommands;
import com.tencent.code.intel.apibridge.extension.mainthread.context.MainThreadContext;
import com.tencent.code.intel.apibridge.util.FusionActionUtils;
import com.tencent.code.intel.apibridge.util.FusionTextUtils;
import com.tencent.code.intel.impl.CopilotSettingsService;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.renderer.InlineChatGutterIconRenderer;
import com.tencent.code.intel.ui.inline.GutterIconInfo;
import com.tencent.code.intel.ui.pane.RoundPanel;
import com.tencent.code.intel.util.CopilotEditorUtils;
import com.tencent.code.intel.util.ShortCutUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class InlineChatGutterIcon {
    private static final InlineChatGutterIcon INSTANCE = new InlineChatGutterIcon();
    private static final ConcurrentHashMap<Editor, GutterIconInfo> gutterIcons = new ConcurrentHashMap();
    private JBPopup popup;

    private InlineChatGutterIcon() {
    }

    public static InlineChatGutterIcon getInstance() {
        return INSTANCE;
    }

    private boolean isInlineChatEnabled(Editor editor) {
        if (MainThreadContext.getInstance(editor.getProject()) == null) {
            return false;
        }
        String key = FusionTextUtils.withPluginNamePrefix("authenticated", null);
        String value = MainThreadContext.getInstance(editor.getProject()).getContext().get(key);
        return CopilotSettingsService.getInstance().isInlineChatEnable() && Boolean.parseBoolean(value);
    }

    private MouseAdapter createMouseListener(final Editor editor) {
        return new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    InlineChatGutterIcon.this.cancelPopup();
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        boolean hasSelection = editor.getSelectionModel().hasSelection();
                        if (hasSelection && InlineChatGutterIcon.this.isInlineChatEnabled(editor) && CopilotSettingsService.getInstance().isInlinePopupEnable()) {
                            InlineChatGutterIcon.this.createPopup(editor);
                        }
                    });
                }
            }
        };
    }

    public void cancelPopup() {
        if (this.popup == null) {
            return;
        }
        this.popup.cancel();
    }

    private JButton createButton(String text, String shortcut, final RoundPanel content) {
        final JButton button = new JButton(text + " " + shortcut);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setOpaque(true);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setBackground(Color.GRAY);
                button.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setBackground(content.getBackground());
                button.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        return button;
    }

    private FlowLayout createFlowLayout() {
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setHgap(flowLayout.getHgap());
        flowLayout.setVgap(flowLayout.getVgap());
        return flowLayout;
    }

    private boolean hasEnoughEmptySpace(Editor editor, Point point, Dimension size, int selectionTop, int selectionBottom) {
        int lineHeight = editor.getLineHeight();
        Document document = editor.getDocument();
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        if (point.y + size.height > selectionTop && point.y < selectionBottom) {
            return false;
        }
        int requiredEmptyLines = (size.height + lineHeight - 1) / lineHeight;
        int startLine = editor.yToVisualLine(point.y);
        int endLine = startLine + requiredEmptyLines - 1;
        for (int visualLine = startLine; visualLine <= endLine; ++visualLine) {
            if (visualLine < 0 || visualLine >= editor.getDocument().getLineCount()) {
                return false;
            }
            LogicalPosition logicalPos = editor.visualToLogicalPosition(new VisualPosition(visualLine, 0));
            int startOffset = document.getLineStartOffset(logicalPos.line);
            int endOffset = document.getLineEndOffset(logicalPos.line);
            VisualPosition lineEndPos = editor.offsetToVisualPosition(endOffset);
            Point lineEndPoint = editor.visualPositionToXY(lineEndPos);
            if (point.x >= lineEndPoint.x + lineHeight / 2) continue;
            return false;
        }
        return true;
    }

    private Point findBestPopupLocation(Editor editor, Dimension popupSize) {
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        int horizontalGap = 20;
        int verticalGap = editor.getLineHeight();
        SelectionModel selectionModel = editor.getSelectionModel();
        CaretModel caretModel = editor.getCaretModel();
        boolean isSelectingDown = caretModel.getOffset() == selectionModel.getSelectionEnd();
        VisualPosition startVisualPos = editor.offsetToVisualPosition(selectionModel.getSelectionStart());
        VisualPosition endVisualPos = editor.offsetToVisualPosition(selectionModel.getSelectionEnd());
        Point startPoint = editor.visualPositionToXY(startVisualPos);
        Point endPoint = editor.visualPositionToXY(endVisualPos);
        Point caretPoint = editor.visualPositionToXY(caretModel.getVisualPosition());
        int rightStartX = caretPoint.x + horizontalGap;
        int maxRightX = visibleArea.x + visibleArea.width - popupSize.width;
        int caretLine = editor.yToVisualLine(caretPoint.y);
        LogicalPosition caretLogicalPos = editor.visualToLogicalPosition(new VisualPosition(caretLine, 0));
        Document document = editor.getDocument();
        int caretLineEndOffset = document.getLineEndOffset(caretLogicalPos.line);
        VisualPosition lineEndPos = editor.offsetToVisualPosition(caretLineEndOffset);
        Point lineEndPoint = editor.visualPositionToXY(lineEndPos);
        int searchStartX = Math.max(rightStartX, lineEndPoint.x + horizontalGap);
        Point rightPoint = new Point(searchStartX, caretPoint.y);
        if (rightPoint.x + popupSize.width <= visibleArea.x + visibleArea.width && this.hasEnoughEmptySpace(editor, rightPoint, popupSize, Math.min(startPoint.y, endPoint.y), Math.max(startPoint.y, endPoint.y) + editor.getLineHeight())) {
            return rightPoint;
        }
        if (isSelectingDown) {
            int baseY = Math.max(startPoint.y, endPoint.y) + verticalGap * 2;
            int lastVisualLine = editor.yToVisualLine(baseY + popupSize.height);
            int maxEndX = 0;
            for (int line = editor.yToVisualLine(baseY); line <= lastVisualLine; ++line) {
                LogicalPosition logicalPos = editor.visualToLogicalPosition(new VisualPosition(line, 0));
                if (logicalPos.line < 0 || logicalPos.line >= document.getLineCount()) continue;
                int endOffset = document.getLineEndOffset(logicalPos.line);
                VisualPosition endPos = editor.offsetToVisualPosition(endOffset);
                Point endPoint2 = editor.visualPositionToXY(endPos);
                maxEndX = Math.max(maxEndX, endPoint2.x);
            }
            int safeX = Math.max(rightStartX, maxEndX + horizontalGap);
            Point point = new Point(safeX, baseY);
            if (point.x + popupSize.width <= visibleArea.x + visibleArea.width) {
                return point;
            }
            return new Point(rightStartX, baseY + editor.getLineHeight());
        }
        int baseY = Math.min(startPoint.y, endPoint.y) - popupSize.height - verticalGap;
        int firstVisualLine = editor.yToVisualLine(baseY);
        int maxEndX = 0;
        for (int line = firstVisualLine; line <= editor.yToVisualLine(baseY + popupSize.height); ++line) {
            if (line < 0 || line >= document.getLineCount()) continue;
            LogicalPosition logicalPos = editor.visualToLogicalPosition(new VisualPosition(line, 0));
            int endOffset = document.getLineEndOffset(logicalPos.line);
            VisualPosition endPos = editor.offsetToVisualPosition(endOffset);
            Point endPoint2 = editor.visualPositionToXY(endPos);
            maxEndX = Math.max(maxEndX, endPoint2.x);
        }
        int safeX = Math.max(rightStartX, maxEndX + horizontalGap);
        Point point = new Point(safeX, baseY);
        if (point.x + popupSize.width <= visibleArea.x + visibleArea.width) {
            return point;
        }
        return new Point(rightStartX, baseY - editor.getLineHeight());
    }

    private Point findSideLocation(Editor editor, Point caretPoint, Dimension popupSize, int leftX, int rightX, int selectionTop, int selectionBottom, int minOffset, int searchRange, int step, Rectangle visibleArea) {
        int distance;
        Point point;
        int offset;
        Point bestLocation = null;
        int minDistance = Integer.MAX_VALUE;
        for (offset = minOffset; offset <= searchRange; offset += step) {
            point = new Point(leftX, caretPoint.y + offset);
            if (point.y + popupSize.height > visibleArea.y + visibleArea.height || point.y < visibleArea.y || !this.hasEnoughEmptySpace(editor, point, popupSize, selectionTop, selectionBottom) || (distance = Math.abs(caretPoint.y - point.y)) >= minDistance) continue;
            minDistance = distance;
            bestLocation = point;
        }
        for (offset = minOffset; offset <= searchRange; offset += step) {
            point = new Point(rightX, caretPoint.y + offset);
            if (point.y + popupSize.height > visibleArea.y + visibleArea.height || point.y < visibleArea.y || !this.hasEnoughEmptySpace(editor, point, popupSize, selectionTop, selectionBottom) || (distance = Math.abs(caretPoint.y - point.y)) >= minDistance) continue;
            minDistance = distance;
            bestLocation = point;
        }
        return bestLocation;
    }

    private Point calculatePopupLocation(Editor editor, JComponent content) {
        SelectionModel selectionModel = editor.getSelectionModel();
        CaretModel caretModel = editor.getCaretModel();
        if (!selectionModel.hasSelection()) {
            return null;
        }
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        Dimension popupSize = content.getPreferredSize();
        if (!CopilotSettingsService.getInstance().isLogin()) {
            VisualPosition visualPosition = editor.getSelectionModel().getSelectionStartPosition();
            String selectionText = editor.getSelectionModel().getSelectedText();
            if (visualPosition != null && selectionText != null) {
                int columnOffset = Math.min(visualPosition.column, 120);
                Point p = editor.visualPositionToXY(new VisualPosition(visualPosition.line, columnOffset));
                p.y -= this.popup.getContent().getPreferredSize().height;
                return p;
            }
            return null;
        }
        return this.findBestPopupLocation(editor, popupSize);
    }

    private void createPopup(Editor editor) {
        RoundPanel content = new RoundPanel(this.createFlowLayout());
        if (editor == null || editor.getProject() == null) {
            return;
        }
        Project project = editor.getProject();
        String openInlineChatActionID = FusionActionUtils.getInternalCommandId("codingcopilot.inlineChat.start");
        String openInlineChatShortcut = ShortCutUtils.getShortcutText(openInlineChatActionID, "");
        String adkChatActionID = FusionActionUtils.getInternalCommandId("codingcopilot.addToChat");
        String askChatShortcut = ShortCutUtils.getShortcutText(adkChatActionID, "");
        JButton addChatBtn = this.createButton(LocaleManager.get("ui.chat.inline.action.add.shortcut.tip"), askChatShortcut, content);
        JButton generateBtn = this.createButton(LocaleManager.get("ui.chat.inline.action.generate.shortcut.tip"), openInlineChatShortcut, content);
        addChatBtn.addActionListener(e -> {
            ExtHostCommands.executeCommand(project, FusionActionUtils.getInternalCommandId("codingcopilot.addToChat"), null, jsonObject -> {});
            this.cancelPopup();
        });
        generateBtn.addActionListener(e -> {
            ExtHostCommands.executeCommand(project, FusionActionUtils.getInternalCommandId("codingcopilot.inlineChat.start"), null, jsonObject -> {});
            this.cancelPopup();
        });
        content.add(addChatBtn);
        content.add(generateBtn);
        if (!CopilotSettingsService.getInstance().isLogin() && !CopilotSettingsService.getInstance().isInlinePopupEnable()) {
            return;
        }
        this.popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)content, (JComponent)addChatBtn).setProject(editor.getProject()).setMovable(true).setCancelOnOtherWindowOpen(true).setCancelOnWindowDeactivation(true).createPopup();
        Point popupLocation = this.calculatePopupLocation(editor, content);
        if (popupLocation != null) {
            this.popup.show(new RelativePoint((Component)editor.getContentComponent(), popupLocation));
        }
    }

    public void onEditorCreated(final Editor editor) {
        editor.getSelectionModel().addSelectionListener(new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                boolean hasSelection;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!(hasSelection = editor.getSelectionModel().hasSelection()) || !InlineChatGutterIcon.this.isInlineChatEnabled(editor)) {
                    InlineChatGutterIcon.this.removeGutterIcon(editor);
                    InlineChatGutterIcon.this.cancelPopup();
                    return;
                }
                int selectionStart = editor.getDocument().getLineNumber(e.getNewRange().getStartOffset());
                if (selectionStart >= 0 && selectionStart < editor.getDocument().getLineCount()) {
                    InlineChatGutterIcon.this.addGutterIcon(editor, selectionStart);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/tencent/code/intel/ui/inline/InlineChatGutterIcon$3", "selectionChanged"));
            }
        });
        editor.getContentComponent().addMouseListener(this.createMouseListener(editor));
    }

    private void addGutterIcon(final Editor editor, int line) {
        VirtualFile vf;
        GutterIconInfo info = gutterIcons.get(editor);
        if (info != null) {
            this.removeGutterIcon(editor);
        }
        if ((vf = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) {
            return;
        }
        String uri = CopilotEditorUtils.getCopilotFilePath(vf);
        if (uri != null) {
            RangeHighlighter highlighter = editor.getMarkupModel().addLineHighlighter(null, line, 0);
            highlighter.setGutterIconRenderer((GutterIconRenderer)new InlineChatGutterIconRenderer(line, new Runnable(){

                @Override
                public void run() {
                    ExtHostCommands.executeCommand(editor.getProject(), FusionActionUtils.getInternalCommandId("codingcopilot.inlineChat.start"), null, jsonObject -> {});
                }
            }));
            gutterIcons.put(editor, new GutterIconInfo(line, highlighter));
        }
    }

    private void removeGutterIcon(Editor editor) {
        GutterIconInfo info = gutterIcons.get(editor);
        if (info != null) {
            editor.getMarkupModel().removeHighlighter(info.getHighlighter());
            gutterIcons.remove(editor);
        }
    }
}

