/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.ui.pane;

import com.tencent.code.intel.util.ColorUtils;
import com.tencent.code.intel.util.ShortCutUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;
import org.apache.http.util.TextUtils;

public class HoverButton
extends JButton {
    private int widthPadding;
    private Border oldBorder;

    public HoverButton() {
        this(-1);
    }

    public HoverButton(int widthPadding) {
        this("", widthPadding);
    }

    public HoverButton(String text, int widthPadding) {
        this(text, null, widthPadding);
    }

    public HoverButton(String text, Icon icon, int widthPadding) {
        this(text, icon, widthPadding, null);
    }

    public HoverButton(String text, Icon icon, int widthPadding, ActionListener actionListener) {
        super(text, icon);
        this.widthPadding = widthPadding;
        this.setHorizontalTextPosition(2);
        this.setVerticalTextPosition(0);
        this.setBackground(ColorUtils.getBackgroundColor());
        this.setForeground((Color)ColorUtils.getTextColor());
        this.oldBorder = this.getBorder();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                HoverButton.this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 2));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HoverButton.this.setBorder(HoverButton.this.oldBorder);
            }
        });
        if (actionListener != null) {
            this.addActionListener(actionListener);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        int totalWidth = 0;
        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
            totalWidth += ShortCutUtils.getTextLength(this.getText());
        }
        if (this.getIcon() != null) {
            totalWidth += this.getIcon().getIconWidth() + 8;
        }
        if (this.widthPadding > 0) {
            totalWidth += this.widthPadding;
        }
        if (totalWidth > 0) {
            size.width = totalWidth;
        }
        return size;
    }
}

