/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.ui.pane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.LineBorder;

public class RoundedLineBorder
extends LineBorder {
    private final int radius;

    public RoundedLineBorder(Color color, int thickness, boolean roundedCorners, int radius) {
        super(color, thickness, roundedCorners);
        this.radius = radius;
    }

    @Override
    public void paintBorder(Component c, Graphics graphics, int x, int y, int width, int height) {
        if (this.thickness > 0 && graphics instanceof Graphics2D) {
            RectangularShape inner;
            RectangularShape outer;
            Color oldColor = graphics.getColor();
            graphics.setColor(this.lineColor);
            int offs = this.thickness;
            int size = offs + offs;
            if (this.roundedCorners) {
                float arc = this.radius * 2;
                outer = new RoundRectangle2D.Float(x, y, width, height, arc, arc);
                inner = new RoundRectangle2D.Float(x + offs, y + offs, width - size, height - size, arc, arc);
            } else {
                outer = new Rectangle2D.Float(x, y, width, height);
                inner = new Rectangle2D.Float(x + offs, y + offs, width - size, height - size);
            }
            Path2D.Float shape = new Path2D.Float(0);
            ((Path2D)shape).append(outer, false);
            shape.append(inner, false);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)graphics).fill(shape);
            graphics.setColor(oldColor);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.set(this.thickness, this.thickness, this.thickness, this.thickness);
        return insets;
    }
}

