/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.ui.sidebar;

import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.tencent.code.intel.common.SdkIcons;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.util.CopilotEditorUtils;
import com.tencent.code.intel.util.PluginUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;

public class CopilotDebugWindow
implements ToolWindowFactory,
DumbAware {
    private ConsoleView consoleView;
    private AtomicLong consoleId = new AtomicLong(0L);
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private String separator = System.lineSeparator();
    private static CopilotDebugWindow debugWindow;
    public static final String WINDOW_ID = "com.tencent.code.intel.ui.sidebar.CopilotDebugWindow";

    public static void registerToolWindow(@NotNull Project project) {
        if (project == null) {
            CopilotDebugWindow.$$$reportNull$$$0(0);
        }
        ThreadManager.getInstance().runUiThreadSave(() -> {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
            ToolWindow toolWindow = toolWindowManager.getToolWindow(WINDOW_ID);
            if (toolWindow == null) {
                toolWindow = toolWindowManager.registerToolWindow(WINDOW_ID, false, ToolWindowAnchor.BOTTOM);
                CopilotDebugWindow copilotFeedbackPage = new CopilotDebugWindow();
                copilotFeedbackPage.createToolWindowContent(project, toolWindow);
            }
        });
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            CopilotDebugWindow.$$$reportNull$$$0(1);
        }
        if (toolWindow == null) {
            CopilotDebugWindow.$$$reportNull$$$0(2);
        }
        debugWindow = this;
        this.consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        toolWindow.setIcon(SdkIcons.COPILOT_TOOLS_WINDOW);
        toolWindow.setStripeTitle(LocaleManager.get("debug"));
        Content content = PluginUtils.getContentFactory().createContent(this.consoleView.getComponent(), LocaleManager.get("gf_copilot"), false);
        toolWindow.getContentManager().addContent(content);
        this.consoleView.print("\u7279\u522b\u58f0\u660e\uff1a\u672c\u65e5\u5fd7\u4ec5\u4ec5\u4e3a\u3010lsp\u3011\u8f93\u5165\u8f93\u51fa\u65e5\u5fd7\uff0c\u5e76\u975e\u5168\u90e8\u65e5\u5fd7\uff0c\u8be6\u7ec6\u65e5\u5fd7\u53ef\u4ee5\u524d\u5f80\u3010Help\u3011-\u3010Show Log in Finder/Explorer\u3011\u3002\n\n", ConsoleViewContentType.USER_INPUT);
    }

    private static ToolWindow getToolWindow(Project project) {
        if (project == null) {
            project = CopilotEditorUtils.getOpenedProjects()[0];
        }
        if (project != null && !project.isDisposed()) {
            return ToolWindowManager.getInstance((Project)project).getToolWindow(WINDOW_ID);
        }
        return null;
    }

    public static void openWindow(Project project) {
        CopilotDebugWindow.registerToolWindow(project);
        ThreadManager.getInstance().runUiThread(() -> {
            ToolWindow toolWindow = CopilotDebugWindow.getToolWindow(project);
            if (toolWindow != null) {
                toolWindow.show(null);
            }
        });
    }

    public static void print(String message, Level level) {
        if (debugWindow == null) {
            return;
        }
        if (CopilotDebugWindow.debugWindow.consoleView != null) {
            String simple = String.format("[%s] %s %s", CopilotDebugWindow.debugWindow.dateTimeFormat.format(new Date()), message, CopilotDebugWindow.debugWindow.separator);
            ThreadManager.getInstance().runUiThreadSave(() -> {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                if (level == Level.SEVERE) {
                    consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
                } else if (level == Level.WARNING) {
                    consoleViewContentType = ConsoleViewContentType.LOG_ERROR_OUTPUT;
                } else if (level == Level.FINE) {
                    consoleViewContentType = ConsoleViewContentType.USER_INPUT;
                }
                CopilotDebugWindow.debugWindow.consoleView.print(simple, consoleViewContentType);
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "com/tencent/code/intel/ui/sidebar/CopilotDebugWindow";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerToolWindow";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

