/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.ui.sidebar.conversation.chat.footer.file;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.TreeFileChooser;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.ui.sidebar.conversation.chat.footer.file.CodeReviewChooseByNamePanel;
import com.tencent.code.intel.ui.sidebar.conversation.chat.footer.file.CodeReviewGotoFileModel;
import com.tencent.code.intel.util.PluginUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CodeReviewFileChooserDialog
extends DialogWrapper
implements TreeFileChooser {
    private static final int DEFAULT_WIDTH = 800;
    private static final int DEFAULT_HEIGHT = 600;
    private PsiFile mySelectedFile;
    @NotNull
    private final Project myProject;
    private CodeReviewChooseByNamePanel myGotoByNamePanel;
    @Nullable
    private final PsiFile myInitialFile;
    @Nullable
    private final TreeFileChooser.PsiFileFilter myFilter;
    @Nullable
    private final FileType myFileType;
    private final boolean myShowLibraryContents;

    public CodeReviewFileChooserDialog(@NotNull Project project, @NlsContexts.DialogTitle String title, @Nullable PsiFile initialFile, @Nullable FileType fileType, @Nullable TreeFileChooser.PsiFileFilter filter, boolean showLibraryContents) {
        if (project == null) {
            CodeReviewFileChooserDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.mySelectedFile = null;
        this.myInitialFile = initialFile;
        this.myFilter = filter;
        this.myFileType = fileType;
        this.myShowLibraryContents = showLibraryContents;
        this.setTitle(title);
        this.myProject = project;
        this.init();
        this.clearStoredDimensions();
        if (initialFile != null) {
            SwingUtilities.invokeLater(() -> this.selectFile(initialFile));
        }
        SwingUtilities.invokeLater(this::handleSelectionChanged);
    }

    protected Action @NotNull [] createActions() {
        return new Action[0];
    }

    protected JComponent createCenterPanel() {
        final JPanel dummyPanel = new JPanel(new BorderLayout());
        String name = null;
        if (this.myInitialFile != null) {
            name = this.myInitialFile.getName();
        }
        this.myGotoByNamePanel = new CodeReviewChooseByNamePanel(this.myProject, new MyGotoFileModel(this.myProject, this.myFileType, this.myShowLibraryContents), name, true, (PsiElement)this.myInitialFile){

            protected void close(boolean isOk) {
                super.close(isOk);
                if (isOk) {
                    CodeReviewFileChooserDialog.this.doOKAction();
                } else {
                    CodeReviewFileChooserDialog.this.doCancelAction();
                }
            }

            @Override
            protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
                super.initUI(callback, modalityState, allowMultipleSelection);
                dummyPanel.add((Component)CodeReviewFileChooserDialog.this.myGotoByNamePanel.getPanel(), "Center");
            }

            protected void showTextFieldPanel() {
            }

            protected void chosenElementMightChange() {
                CodeReviewFileChooserDialog.this.handleSelectionChanged();
            }
        };
        SwingUtilities.invokeLater(() -> this.myGotoByNamePanel.invoke(new MyCallback(), ModalityState.stateForComponent((Component)this.getRootPane()), false));
        return dummyPanel;
    }

    private void handleSelectionChanged() {
        PsiFile selection = this.calcSelectedClass();
        this.setOKActionEnabled(selection != null);
    }

    public Dimension getInitialSize() {
        Dimension screenSize = null;
        if (WindowManager.getInstance().getFrame(this.myProject) != null) {
            screenSize = WindowManager.getInstance().getFrame(this.myProject).getSize();
        }
        if (screenSize != null) {
            int width = screenSize.width / 2;
            int height = screenSize.height / 2;
            int finalWidth = Math.min(800, width);
            int finalHeight = Math.min(600, height);
            return new Dimension(finalWidth, finalHeight);
        }
        return new Dimension(800, 600);
    }

    private void clearStoredDimensions() {
        String dimensionKey = this.getDimensionServiceKey();
        DimensionService dimensionService = DimensionService.getInstance();
        dimensionService.setSize(dimensionKey, null, this.myProject);
        dimensionService.setLocation(dimensionKey, null, this.myProject);
    }

    protected void doOKAction() {
        this.mySelectedFile = this.calcSelectedClass();
        if (this.mySelectedFile == null) {
            return;
        }
        super.doOKAction();
    }

    public void doCancelAction() {
        this.mySelectedFile = null;
        super.doCancelAction();
    }

    public PsiFile getSelectedFile() {
        return this.mySelectedFile;
    }

    public void selectFile(@NotNull PsiFile file) {
        if (file == null) {
            CodeReviewFileChooserDialog.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeLater(() -> {}, ModalityState.stateForComponent((Component)this.getWindow()));
    }

    public void showDialog() {
        this.show();
    }

    private PsiFile calcSelectedClass() {
        return (PsiFile)this.myGotoByNamePanel.getChosenElement();
    }

    public void dispose() {
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return "#com.tencent.code.intel.ui.sidebar.conversation.chat.footer.file.CodeReviewFileChooserDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGotoByNamePanel.getPreferredFocusedComponent();
    }

    private Object[] filterFiles(Object[] list) {
        Condition condition = psiFile -> {
            if (this.myFilter != null && !this.myFilter.accept(psiFile)) {
                return false;
            }
            boolean accepted = this.myFileType == null || psiFile.getFileType() == this.myFileType;
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null && !accepted) {
                accepted = FileTypeRegistry.getInstance().isFileOfType(virtualFile, this.myFileType);
            }
            return accepted;
        };
        ArrayList<Object> result = new ArrayList<Object>(list.length);
        for (Object o : list) {
            ProjectViewNode projectViewNode;
            Object psiFile2 = o instanceof PsiFile ? (PsiFile)o : (o instanceof PsiFileNode ? (PsiFile)((PsiFileNode)o).getValue() : null);
            if (psiFile2 != null && !condition.value(psiFile2) || o instanceof ProjectViewNode && !(projectViewNode = (ProjectViewNode)o).canHaveChildrenMatching(condition)) continue;
            result.add(o);
        }
        return ArrayUtil.toObjectArray(result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/tencent/code/intel/ui/sidebar/conversation/chat/footer/file/CodeReviewFileChooserDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "selectFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyCallback
    extends ChooseByNamePopupComponent.Callback {
        private MyCallback() {
        }

        public void elementChosen(Object element) {
            CodeReviewFileChooserDialog.this.mySelectedFile = (PsiFile)element;
            CodeReviewFileChooserDialog.this.close(0);
        }
    }

    private final class MyGotoFileModel
    extends CodeReviewGotoFileModel {
        private boolean isInitialLoad;
        private final int myMaxSize;

        public MyGotoFileModel(Project project, FileType myFileType, boolean myShowLibraryContents) {
            if (project == null) {
                MyGotoFileModel.$$$reportNull$$$0(0);
            }
            super(project, myFileType, myShowLibraryContents);
            this.isInitialLoad = true;
            this.myMaxSize = this.getMainWindowWidth();
        }

        private int getMainWindowWidth() {
            IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(CodeReviewFileChooserDialog.this.myProject);
            if (ideFrame != null && ideFrame.getComponent() != null) {
                return ideFrame.getComponent().getWidth();
            }
            return 800;
        }

        private List<PsiFile> getChangedFiles() {
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)CodeReviewFileChooserDialog.this.myProject);
            List virtualFiles = changeListManager.getAffectedFiles();
            PsiManager psiManager = PsiManager.getInstance((Project)CodeReviewFileChooserDialog.this.myProject);
            ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
            for (VirtualFile virtualFile : virtualFiles) {
                PsiFile psiFile = psiManager.findFile(virtualFile);
                if (psiFile == null) continue;
                psiFiles.add(psiFile);
            }
            return psiFiles;
        }

        @Override
        public String getPromptText() {
            return PluginUtils.isGatewayClient() ? LocaleManager.get("ui.chat.gateway.file.select.prompt") : IdeBundle.message((String)"prompt.filechooser.enter.file.name", (Object[])new Object[0]);
        }

        @Override
        public String getCheckBoxName() {
            return null;
        }

        @Override
        @NotNull
        public String getNotInMessage() {
            return "";
        }

        @Override
        @NotNull
        public String getNotFoundMessage() {
            return "";
        }

        @Override
        public boolean loadInitialCheckBoxState() {
            return true;
        }

        @Override
        public void saveInitialCheckBoxState(boolean state) {
        }

        @Override
        @NotNull
        public PsiElementListCellRenderer getListCellRenderer() {
            return new GotoFileCellRenderer(this.myMaxSize);
        }

        @Override
        public boolean willOpenEditor() {
            return true;
        }

        @Override
        public String getElementName(@NotNull Object element) {
            if (element == null) {
                MyGotoFileModel.$$$reportNull$$$0(1);
            }
            if (!(element instanceof PsiFile)) {
                return null;
            }
            return ((PsiFile)element).getName();
        }

        @Override
        @Nullable
        public String getFullName(@NotNull Object element) {
            if (element == null) {
                MyGotoFileModel.$$$reportNull$$$0(2);
            }
            if (element instanceof PsiFile) {
                VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
                return virtualFile != null ? virtualFile.getPath() : null;
            }
            return this.getElementName(element);
        }

        @Override
        public String getHelpId() {
            return null;
        }

        @Override
        public String @NotNull [] getSeparators() {
            String[] stringArray = new String[]{"/", "\\"};
            if (stringArray == null) {
                MyGotoFileModel.$$$reportNull$$$0(3);
            }
            return stringArray;
        }

        @Override
        public boolean useMiddleMatching() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/tencent/code/intel/ui/sidebar/conversation/chat/footer/file/CodeReviewFileChooserDialog$MyGotoFileModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/tencent/code/intel/ui/sidebar/conversation/chat/footer/file/CodeReviewFileChooserDialog$MyGotoFileModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeparators";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementName";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFullName";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

