/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.ui.sidebar.conversation.chat.footer.file;

import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.indexing.IdFilter;
import com.tencent.code.intel.util.CollectionUtils;
import com.tencent.code.intel.util.PluginUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeReviewGotoFileModel
implements ChooseByNameModel,
DumbAware {
    private static final int DEFAULT_WIDTH = 800;
    private static final int DEFAULT_HEIGHT = 600;
    @NotNull
    private final Project myProject;
    private final FileType myFileType;
    private final boolean myShowLibraryContents;
    private boolean isInitialLoad;
    private final int myMaxSize;

    public CodeReviewGotoFileModel(@NotNull Project project, FileType myFileType, boolean myShowLibraryContents) {
        if (project == null) {
            CodeReviewGotoFileModel.$$$reportNull$$$0(0);
        }
        this.isInitialLoad = true;
        this.myMaxSize = this.getMainWindowWidth();
        this.myFileType = myFileType;
        this.myShowLibraryContents = myShowLibraryContents;
        this.myProject = project;
    }

    public void reset() {
        this.isInitialLoad = true;
    }

    public Object @NotNull [] getElementsByName(@NotNull String name, boolean checkBoxState, @NotNull String pattern) {
        if (name == null) {
            CodeReviewGotoFileModel.$$$reportNull$$$0(1);
        }
        if (pattern == null) {
            CodeReviewGotoFileModel.$$$reportNull$$$0(2);
        }
        if (this.isInitialLoad && !PluginUtils.isGatewayClient()) {
            List<PsiFile> changedFiles = this.getChangedFiles();
            this.isInitialLoad = false;
            if (!CollectionUtils.isEmpty(changedFiles)) {
                Object[] objectArray = changedFiles.toArray();
                if (objectArray == null) {
                    CodeReviewGotoFileModel.$$$reportNull$$$0(3);
                }
                return objectArray;
            }
        } else if (PluginUtils.isGatewayClient()) {
            VirtualFile[] openFiles = FileEditorManager.getInstance((Project)this.myProject).getOpenFiles();
            Object[] psiFiles = new PsiFile[openFiles.length];
            for (int i = 0; i < openFiles.length; ++i) {
                psiFiles[i] = PsiManager.getInstance((Project)this.myProject).findFile(openFiles[i]);
            }
            if (psiFiles == null) {
                CodeReviewGotoFileModel.$$$reportNull$$$0(4);
            }
            return psiFiles;
        }
        GlobalSearchScope scope = this.myShowLibraryContents ? GlobalSearchScope.allScope((Project)this.myProject) : GlobalSearchScope.projectScope((Project)this.myProject);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList result = new ArrayList();
        FilenameIndex.processFilesByNames(Set.of(name), (boolean)true, (GlobalSearchScope)scope, (IdFilter)IdFilter.getProjectIdFilter((Project)this.myProject, (boolean)this.myShowLibraryContents), file -> {
            if (!file.isValid()) {
                return true;
            }
            boolean isDir = file.isDirectory();
            if (isDir) {
                return true;
            }
            if (!this.myShowLibraryContents && ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file)) {
                return true;
            }
            PsiFile psi = psiManager.findFile(file);
            if (psi == null) {
                return true;
            }
            result.add(psi.getContainingFile());
            return true;
        });
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            CodeReviewGotoFileModel.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    private int getMainWindowWidth() {
        IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.myProject);
        if (ideFrame != null && ideFrame.getComponent() != null) {
            return ideFrame.getComponent().getWidth();
        }
        return 800;
    }

    private List<PsiFile> getChangedFiles() {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        List virtualFiles = changeListManager.getAffectedFiles();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
        for (VirtualFile virtualFile : virtualFiles) {
            PsiFile psiFile = psiManager.findFile(virtualFile);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        return psiFiles;
    }

    public String getPromptText() {
        return null;
    }

    public String getCheckBoxName() {
        return null;
    }

    @NotNull
    public String getNotInMessage() {
        return "";
    }

    @NotNull
    public String getNotFoundMessage() {
        return "";
    }

    public boolean loadInitialCheckBoxState() {
        return true;
    }

    public void saveInitialCheckBoxState(boolean state) {
    }

    @NotNull
    public PsiElementListCellRenderer getListCellRenderer() {
        return new GotoFileCellRenderer(this.myMaxSize);
    }

    public String @NotNull [] getNames(boolean checkBoxState) {
        List<String> fileNames = null;
        if (this.isInitialLoad && !PluginUtils.isGatewayClient()) {
            fileNames = this.getChangedFilenames();
        }
        if (PluginUtils.isGatewayClient()) {
            VirtualFile[] openFiles = FileEditorManager.getInstance((Project)this.myProject).getOpenFiles();
            ArrayList<String> names = new ArrayList<String>();
            for (VirtualFile file : openFiles) {
                names.add(file.getName());
            }
            fileNames = names;
        }
        if (CollectionUtils.isEmpty(fileNames)) {
            fileNames = this.getSearchedFileNames();
        }
        HashSet<String> array = new HashSet<String>(fileNames.size());
        array.addAll(fileNames);
        Object[] result = ArrayUtilRt.toStringArray(array);
        Arrays.sort(result);
        if (result == null) {
            CodeReviewGotoFileModel.$$$reportNull$$$0(6);
        }
        return result;
    }

    private List<String> getSearchedFileNames() {
        List<String> fileNames;
        GlobalSearchScope scope;
        GlobalSearchScope globalSearchScope = scope = this.myShowLibraryContents ? GlobalSearchScope.allScope((Project)this.myProject) : GlobalSearchScope.projectScope((Project)this.myProject);
        if (this.myFileType != null) {
            Collection virtualFiles = FileTypeIndex.getFiles((FileType)this.myFileType, (GlobalSearchScope)scope);
            fileNames = virtualFiles.stream().map(VirtualFile::getName).collect(Collectors.toList());
        } else {
            Set names = CollectionFactory.createSmallMemoryFootprintSet();
            FilenameIndex.processAllFileNames(name -> {
                names.add(name);
                return true;
            }, (GlobalSearchScope)scope, (IdFilter)IdFilter.getProjectIdFilter((Project)this.myProject, (boolean)this.myShowLibraryContents));
            fileNames = new ArrayList<String>(names);
        }
        return fileNames;
    }

    private List<String> getChangedFilenames() {
        List<PsiFile> changedFiles = this.getChangedFiles();
        return changedFiles.stream().map(PsiFileSystemItem::getName).collect(Collectors.toList());
    }

    public boolean willOpenEditor() {
        return true;
    }

    public String getElementName(@NotNull Object element) {
        if (element == null) {
            CodeReviewGotoFileModel.$$$reportNull$$$0(7);
        }
        if (!(element instanceof PsiFile)) {
            return null;
        }
        return ((PsiFile)element).getName();
    }

    @Nullable
    public String getFullName(@NotNull Object element) {
        if (element == null) {
            CodeReviewGotoFileModel.$$$reportNull$$$0(8);
        }
        if (element instanceof PsiFile) {
            VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
            return virtualFile != null ? virtualFile.getPath() : null;
        }
        return this.getElementName(element);
    }

    public String getHelpId() {
        return null;
    }

    public String @NotNull [] getSeparators() {
        String[] stringArray = new String[]{"/", "\\"};
        if (stringArray == null) {
            CodeReviewGotoFileModel.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    public boolean useMiddleMatching() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/tencent/code/intel/ui/sidebar/conversation/chat/footer/file/CodeReviewGotoFileModel";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/tencent/code/intel/ui/sidebar/conversation/chat/footer/file/CodeReviewGotoFileModel";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsByName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementsByName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

