/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.ui.sidebar.conversation.chat.store;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.tencent.code.intel.bean.item.CodeReviewComment;
import com.tencent.code.intel.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

@Service
public final class AICRCommentsPersistState {
    private final CommentHistory commentHistory = new CommentHistory();
    private final Map<String, CodeReviewComment> idMap = new ConcurrentHashMap<String, CodeReviewComment>();
    private final Map<String, NavigableMap<Integer, CodeReviewComment>> filePathMap = new ConcurrentHashMap<String, NavigableMap<Integer, CodeReviewComment>>();

    public static AICRCommentsPersistState getInstance() {
        return (AICRCommentsPersistState)ApplicationManager.getApplication().getService(AICRCommentsPersistState.class);
    }

    public void resetComments(List<CodeReviewComment> comments) {
        this.clearAllComments();
        if (CollectionUtils.isEmpty(comments)) {
            return;
        }
        for (int i = 0; i < comments.size(); ++i) {
            CodeReviewComment comment = comments.get(i);
            comment.setId(String.valueOf(i));
            this.addComment(comment);
        }
    }

    public void addComment(CodeReviewComment comment) {
        if (this.idMap.containsKey(comment.getId())) {
            return;
        }
        this.idMap.put(comment.getId(), comment);
        this.filePathMap.computeIfAbsent(comment.getFunction().getFilePath(), k -> new TreeMap()).put(comment.getResult().getEndLine(), comment);
        this.commentHistory.addComment(comment);
    }

    public void clearAllComments() {
        this.idMap.clear();
        this.filePathMap.clear();
        this.commentHistory.clear();
    }

    @Nullable
    public CodeReviewComment getCommentById(String id) {
        return this.idMap.get(id);
    }

    public Map<String, List<CodeReviewComment>> getAllFilePathMap() {
        HashMap<String, List<CodeReviewComment>> resultMap = new HashMap<String, List<CodeReviewComment>>();
        for (Map.Entry<String, NavigableMap<Integer, CodeReviewComment>> entry : this.filePathMap.entrySet()) {
            String filePath = entry.getKey();
            NavigableMap<Integer, CodeReviewComment> commentMap = entry.getValue();
            ArrayList commentList = new ArrayList(commentMap.values());
            resultMap.put(filePath, commentList);
        }
        return resultMap;
    }

    public List<CodeReviewComment> getCommentsByFilePath(String filePath) {
        NavigableMap<Integer, CodeReviewComment> map = this.filePathMap.get(filePath);
        return map != null ? new ArrayList(map.values()) : Collections.emptyList();
    }

    public int getCommentSize() {
        return this.commentHistory.comments.size();
    }

    public int getFileListSize() {
        return this.filePathMap.size();
    }

    public CodeReviewComment getPreviousComment(String id) {
        return this.getAdjacentComment(id, false);
    }

    public CodeReviewComment getNextComment(String id) {
        return this.getAdjacentComment(id, true);
    }

    private CodeReviewComment getAdjacentComment(String id, boolean isNext) {
        Map.Entry<Integer, CodeReviewComment> entry;
        CodeReviewComment comment = this.idMap.get(id);
        if (comment == null) {
            return null;
        }
        String filePath = comment.getFunction().getFilePath();
        NavigableMap<Integer, CodeReviewComment> map = this.filePathMap.get(filePath);
        if (map == null || map.isEmpty()) {
            return null;
        }
        int currentLine = comment.getResult().getEndLine();
        Map.Entry<Integer, CodeReviewComment> entry2 = entry = isNext ? map.higherEntry(currentLine) : map.lowerEntry(currentLine);
        return entry != null ? entry.getValue() : (isNext ? map.firstEntry().getValue() : map.lastEntry().getValue());
    }

    public void removeCommentById(String id) {
        CodeReviewComment comment = this.idMap.remove(id);
        if (comment == null) {
            return;
        }
        NavigableMap<Integer, CodeReviewComment> map = this.filePathMap.get(comment.getFunction().getFilePath());
        if (map != null) {
            map.remove(comment.getResult().getEndLine());
        }
        if (map == null || map.isEmpty()) {
            this.filePathMap.remove(comment.getFunction().getFilePath());
        }
        this.commentHistory.removeById(comment.getId());
    }

    public void removeCommentsByFilePath(String filePath) {
        NavigableMap<Integer, CodeReviewComment> comments = this.filePathMap.remove(filePath);
        if (comments != null) {
            for (CodeReviewComment comment : comments.values()) {
                this.idMap.remove(comment.getId());
            }
        }
        this.commentHistory.removeByFilePath(filePath);
    }

    public int getCommentCount(CodeReviewComment comment) {
        NavigableMap<Integer, CodeReviewComment> map = this.filePathMap.get(comment.getFunction().getFilePath());
        return map != null ? map.size() : 0;
    }

    public int getCommentIndex(CodeReviewComment comment) {
        NavigableMap<Integer, CodeReviewComment> map = this.filePathMap.get(comment.getFunction().getFilePath());
        if (map == null) {
            return -1;
        }
        int index = 0;
        for (CodeReviewComment c : map.values()) {
            if (c.getId().equals(comment.getId())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static class CommentHistory {
        List<CodeReviewComment> comments = new ArrayList<CodeReviewComment>();

        public void clear() {
            this.comments.clear();
        }

        public void removeById(String id) {
            this.comments.removeIf(comment -> comment.getId().equals(id));
        }

        public void removeByFilePath(String filePath) {
            this.comments.removeIf(comment -> comment.getFunction().getFilePath().equals(filePath));
        }

        public void addComment(CodeReviewComment comment) {
            this.comments.add(comment);
        }
    }
}

