/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.ui.statusbar;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.tencent.code.intel.apibridge.extension.extension.command.ExtHostCommands;
import com.tencent.code.intel.apibridge.extension.mainthread.quickopen.TransferQuickPickItem;
import com.tencent.code.intel.apibridge.util.FusionTextUtils;
import com.tencent.code.intel.common.SdkIcons;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.ui.statusbar.LoadingPanel;
import com.tencent.code.intel.util.ColorUtils;
import groovy.lang.Tuple2;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopilotStatusBarWidget
extends EditorBasedStatusBarPopup {
    private static final String WIDGET_ID = "com.tencent.code.copilotWidget";
    private StatusBarPanel panel;
    private CopilotWidgetState copilotWidgetState;
    private String fusionCmd;
    private String fusionTitle;
    private String fusionToolTips;
    private CompletableFuture<Map.Entry<Integer, List<TransferQuickPickItem>>> pendingFuture;

    public CopilotStatusBarWidget(@NotNull Project project) {
        if (project == null) {
            CopilotStatusBarWidget.$$$reportNull$$$0(0);
        }
        super(project, false);
    }

    public void associateToData(String command, String title, String toolTips) {
        this.fusionCmd = command;
        this.fusionTitle = title;
        this.fusionToolTips = toolTips;
    }

    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file) {
        if (this.fusionTitle != null) {
            Tuple2<List<String>, String> tuple = FusionTextUtils.traitIconAndText(this.fusionTitle);
            String title = (String)tuple.getV2();
            if (this.fusionTitle.contains(FusionTextUtils.ERROR_ICON)) {
                this.copilotWidgetState = new CopilotWidgetState(this.fusionToolTips, title, true, SdkIcons.COPILOT_ERROR);
            } else if (this.fusionTitle.contains(FusionTextUtils.LOADING_ICON)) {
                this.copilotWidgetState = new CopilotWidgetState(this.fusionToolTips, title, true, SdkIcons.COPILOT_LOADING);
            } else if (this.fusionTitle.contains(FusionTextUtils.ACTIVE_ICON)) {
                this.copilotWidgetState = new CopilotWidgetState(this.fusionToolTips, title, true, SdkIcons.COPILOT_ACTIVATE);
            } else if (this.fusionTitle.contains(FusionTextUtils.DISABLE_ICON)) {
                this.copilotWidgetState = new CopilotWidgetState(this.fusionToolTips, title, true, SdkIcons.COPILOT_CLOSED);
            } else if (this.fusionTitle.contains(FusionTextUtils.WARNING_ICON)) {
                this.copilotWidgetState = new CopilotWidgetState(this.fusionToolTips, title, true, SdkIcons.COPILOT_WARNING);
            }
        } else {
            this.copilotWidgetState = new CopilotWidgetState(LocaleManager.get("disable"), "", true, SdkIcons.COPILOT_WARNING);
        }
        CopilotWidgetState copilotWidgetState = this.copilotWidgetState;
        if (copilotWidgetState == null) {
            CopilotStatusBarWidget.$$$reportNull$$$0(1);
        }
        return copilotWidgetState;
    }

    @Nullable
    protected ListPopup createPopup(DataContext context) {
        if (this.fusionCmd != null) {
            ExtHostCommands.executeCommand(this.getProject(), this.fusionCmd, Collections.emptyList(), object -> {});
        }
        return null;
    }

    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        if (project == null) {
            CopilotStatusBarWidget.$$$reportNull$$$0(2);
        }
        return new CopilotStatusBarWidget(project);
    }

    @NonNls
    @NotNull
    public String ID() {
        return WIDGET_ID;
    }

    protected JPanel createComponent() {
        this.panel = new StatusBarPanel();
        return this.panel;
    }

    protected void updateComponent(@NotNull EditorBasedStatusBarPopup.WidgetState state) {
        if (state == null) {
            CopilotStatusBarWidget.$$$reportNull$$$0(3);
        }
        if (state instanceof CopilotWidgetState) {
            this.updateComponentStatus(state);
        }
        super.updateComponent(state);
    }

    private void updateComponentStatus(@NotNull EditorBasedStatusBarPopup.WidgetState state) {
        if (state == null) {
            CopilotStatusBarWidget.$$$reportNull$$$0(4);
        }
        CopilotWidgetState widgetState = (CopilotWidgetState)state;
        this.panel.setToolTipText(widgetState.getToolTip());
        this.panel.getIconLabel().setIcon(widgetState.getIcon());
        this.panel.getIconLabel().setText(state.getText());
        if (this.fusionTitle != null && !this.fusionTitle.contains(FusionTextUtils.LOADING_ICON)) {
            this.panel.loading(false);
        } else {
            this.panel.loading(true);
        }
        this.panel.revalidate();
        this.panel.repaint();
    }

    public void updateStatusImmediately() {
        if (this.copilotWidgetState != null) {
            this.updateComponentStatus(this.copilotWidgetState);
        }
    }

    public void updateStatus() {
        if (this.myStatusBar == null) {
            return;
        }
        this.update(() -> this.myStatusBar.updateWidget(WIDGET_ID));
    }

    public CompletableFuture<Map.Entry<Integer, List<TransferQuickPickItem>>> getPendingFuture() {
        return this.pendingFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/tencent/code/intel/ui/statusbar/CopilotStatusBarWidget";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/tencent/code/intel/ui/statusbar/CopilotStatusBarWidget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateComponent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateComponentStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CopilotWidgetState
    extends EditorBasedStatusBarPopup.WidgetState {
        public CopilotWidgetState(String toolTip, String text, boolean actionEnabled, Icon statusIcon) {
            super(toolTip, text, actionEnabled);
            this.setIcon(statusIcon);
        }
    }

    public static class StatusBarPanel
    extends JPanel {
        private JBLabel iconLabel;
        private final String CARD_LOADING = "CARD_LOADING";
        private final String CARD_COPILOT_STATUS = "CARD_COPILOT_STATUS";
        private final LoadingPanel loadingPanel;
        private final CardLayout cardLayout = new CardLayout();

        public StatusBarPanel() {
            this.setLayout(this.cardLayout);
            String displayText = this.getStatusDisplayText();
            this.iconLabel = new JBLabel(displayText);
            this.iconLabel.setForeground((Color)ColorUtils.getTextColor());
            this.iconLabel.setIcon(SdkIcons.COPILOT_WARNING);
            this.add((Component)this.iconLabel, "CARD_COPILOT_STATUS");
            this.loadingPanel = new LoadingPanel(50);
            this.loadingPanel.setOpaque(false);
            this.loadingPanel.setPgColor((Color)JBColor.GRAY);
            this.loadingPanel.getIconLabel().setIcon(SdkIcons.COPILOT_ACTIVATE_10);
            this.add((Component)((Object)this.loadingPanel), "CARD_LOADING");
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    this.setBackground(JBColor.background());
                }
            });
            this.loading(false);
        }

        private String getStatusDisplayText() {
            return "";
        }

        public void loading(boolean loading) {
            if (loading) {
                this.loadingPanel.getIconLabel().setIcon(SdkIcons.COPILOT_ACTIVATE_10);
                this.cardLayout.show(this, "CARD_LOADING");
                this.loadingPanel.start();
            } else {
                this.cardLayout.show(this, "CARD_COPILOT_STATUS");
                this.loadingPanel.stop();
            }
        }

        public JBLabel getIconLabel() {
            return this.iconLabel;
        }
    }
}

