/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.ui.statusbar;

import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Timer;

public class LoadingPanel
extends BorderLayoutPanel {
    private JBLabel iconLabel;
    private int speed = 100;
    private static Timer timer;
    private int x = 0;
    private float pgWidthPercent = 0.16f;
    private Color bgColor = JBColor.WHITE;
    private Color pgColor = JBColor.GRAY;

    public LoadingPanel(int speed) {
        this.speed = speed;
        this.begin();
    }

    public LoadingPanel() {
        this.begin();
    }

    private void begin() {
        this.setLayout(new BorderLayout());
        this.iconLabel = new JBLabel("");
        this.iconLabel.setHorizontalAlignment(0);
        this.add((Component)this.iconLabel, "Center");
        timer = new Timer(this.speed, e -> {
            this.x = this.x < 360 ? (this.x -= 5) : 0;
            this.repaint();
        });
        timer.start();
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public void setPgColor(Color pgColor) {
        this.pgColor = pgColor;
    }

    public float getPgWidthPercent() {
        return this.pgWidthPercent;
    }

    public void setPgWidthPercent(float pgWidthPercent) {
        this.pgWidthPercent = pgWidthPercent;
    }

    public JBLabel getIconLabel() {
        return this.iconLabel;
    }

    public void start() {
        if (timer != null) {
            timer.restart();
        }
    }

    public void stop() {
        if (timer != null) {
            timer.stop();
        }
    }

    public void release() {
        if (timer != null) {
            timer.stop();
            if (timer.getActionListeners() != null) {
                timer.removeActionListener(timer.getActionListeners()[0]);
            }
        }
        timer = null;
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public void paintComponent(Graphics page) {
        super.paintComponent(page);
        this.drawArc(page);
    }

    private void drawArc(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = (int)this.getPreferredSize().getWidth();
        int height = (int)this.getPreferredSize().getHeight();
        int iconX = (int)this.iconLabel.getBounds().getCenterX();
        int iconY = (int)this.iconLabel.getBounds().getCenterY();
        width = Math.max(width, iconX * 2);
        height = Math.max(height, iconY * 2);
        int centX = width / 2;
        int centY = height / 2;
        int circleWidth = Math.min(width, height);
        int smallCWidth = (int)((float)circleWidth * this.pgWidthPercent);
        g2d.setColor(this.pgColor);
        g2d.fillArc(centX - circleWidth / 2, centY - circleWidth / 2, circleWidth, circleWidth, this.x, 240);
        g2d.setColor(this.bgColor);
        g2d.fillArc(centX - circleWidth / 2 + smallCWidth, centY - circleWidth / 2 + smallCWidth, circleWidth - smallCWidth * 2, circleWidth - smallCWidth * 2, 0, 360);
        g2d.dispose();
    }
}

