/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.util.DocumentUtils;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ApplicationUtils {
    private static final Set<String> ignoreProjects = Set.of("build", "bin");
    private static final Map<String, String> projectLanguages = new HashMap<String, String>();
    private static final int HIGH_VERSION_SINCE_BUILD = 221;
    private static final Map<String, String> productLanguage = Map.of("IDEA", "Java", "WebStorm", "Javascript", "PyCharm", "Python", "Clion", "C++", "GoLand", "Golang");

    public static Iterable<Project> findValidProjects() {
        return Arrays.stream(ProjectManager.getInstance().getOpenProjects()).filter(ApplicationUtils::isValidProject).collect(Collectors.toList());
    }

    public static String getProjectLanguage(Project project) {
        return projectLanguages.getOrDefault(project.getName(), ApplicationUtils.getLanguageByProduct());
    }

    public static void calculateProjectLanguage(Project project) {
        try {
            VirtualFile baseDir = LocalFileSystem.getInstance().findFileByNioFile(Paths.get(project.getBasePath(), new String[0]));
            if (baseDir == null) {
                return;
            }
            HashMap<String, Integer> count = new HashMap<String, Integer>();
            ApplicationUtils.findDirLanguage(baseDir, count);
            int maxCount = 0;
            String maxLanguage = null;
            for (Map.Entry entry : count.entrySet()) {
                if ((Integer)entry.getValue() <= maxCount) continue;
                maxLanguage = (String)entry.getKey();
                maxCount = (Integer)entry.getValue();
            }
            if (maxLanguage != null) {
                projectLanguages.put(project.getName(), maxLanguage);
            }
        }
        catch (Throwable e) {
            LogManager.error(ApplicationUtils.class, "get project language fail: err: " + String.valueOf(e));
        }
    }

    private static String getLanguageByProduct() {
        String productName = ApplicationNamesInfo.getInstance().getProductName();
        return productLanguage.get(productName);
    }

    private static boolean isValidProject(Project project) {
        return project != null && !project.isDisposed() && !project.isDefault();
    }

    private static void findDirLanguage(VirtualFile file, Map<String, Integer> count) {
        for (VirtualFile child : file.getChildren()) {
            String language;
            if (child.getName().startsWith(".") || ignoreProjects.contains(child.getName())) continue;
            if (child.isDirectory()) {
                ApplicationUtils.findDirLanguage(child, count);
            }
            if ((language = DocumentUtils.getLanguageBySuffix(child.getExtension() != null ? child.getExtension() : "")) == null) continue;
            count.put(language, count.getOrDefault(language, 0) + 1);
        }
    }
}

