/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class BracketMatcher {
    private static final Set<Character> LEFT_BRACKETS = new HashSet<Character>(Arrays.asList(Character.valueOf('('), Character.valueOf('['), Character.valueOf('{')));
    private static final Set<Character> RIGHT_BRACKETS = new HashSet<Character>(Arrays.asList(Character.valueOf(')'), Character.valueOf(']'), Character.valueOf('}')));
    private static final Set<Character> MERGEABLE_OVERLAPPING_SYMBOLS = new HashSet<Character>(Arrays.asList(Character.valueOf(','), Character.valueOf(';'), Character.valueOf(':'), Character.valueOf('.'), Character.valueOf('('), Character.valueOf('{'), Character.valueOf('[')));
    private static final Set<Character> ALL_MERGEABLE_SYMBOLS = new HashSet<Character>(Arrays.asList(Character.valueOf('\''), Character.valueOf('`'), Character.valueOf('\"'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf(';'), Character.valueOf(':'), Character.valueOf(',')));

    public static boolean isLeftBracket(char ch) {
        return LEFT_BRACKETS.contains(Character.valueOf(ch));
    }

    public static boolean isRightBracket(char ch) {
        return RIGHT_BRACKETS.contains(Character.valueOf(ch));
    }

    public static char getPairedBracket(char ch) {
        switch (ch) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '{': {
                return '}';
            }
            case ')': {
                return '(';
            }
            case ']': {
                return '[';
            }
            case '}': {
                return '{';
            }
        }
        return '\u0000';
    }

    public static boolean isBracketBalanced(String completion, String before, String after) {
        int MAX_SCAN_LINES = 10;
        List<Character> leftStack = new ArrayList();
        int lineCount = 0;
        for (int i = before.length() - 1; i >= 0 && lineCount <= MAX_SCAN_LINES; --i) {
            char c = before.charAt(i);
            if (BracketMatcher.isLeftBracket(c)) {
                char right = BracketMatcher.getPairedBracket(c);
                if (!leftStack.isEmpty() && ((Character)leftStack.get(leftStack.size() - 1)).charValue() == right) {
                    leftStack.remove(leftStack.size() - 1);
                    continue;
                }
                leftStack.add(Character.valueOf(c));
                continue;
            }
            if (BracketMatcher.isRightBracket(c)) {
                leftStack.add(Character.valueOf(c));
                continue;
            }
            if (c != '\n') continue;
            ++lineCount;
        }
        leftStack = leftStack.stream().filter(BracketMatcher::isLeftBracket).collect(Collectors.toCollection(ArrayList::new));
        Collections.reverse(leftStack);
        List<Character> rightStack = new ArrayList();
        int lineCount2 = 0;
        for (int i = 0; i < after.length() && lineCount2 <= MAX_SCAN_LINES; ++i) {
            int c = after.charAt(i);
            if (BracketMatcher.isRightBracket((char)c)) {
                int left = BracketMatcher.getPairedBracket((char)c);
                if (!rightStack.isEmpty() && ((Character)rightStack.get(rightStack.size() - 1)).charValue() == left) {
                    rightStack.remove(rightStack.size() - 1);
                    continue;
                }
                if (leftStack.size() - rightStack.size() - 1 >= 0 && (leftStack.isEmpty() || ((Character)leftStack.get(leftStack.size() - rightStack.size() - 1)).charValue() != left)) continue;
                rightStack.add(Character.valueOf((char)c));
                continue;
            }
            if (BracketMatcher.isLeftBracket((char)c)) {
                rightStack.add(Character.valueOf((char)c));
                continue;
            }
            if (c != 10) continue;
            ++lineCount2;
        }
        rightStack = rightStack.stream().filter(BracketMatcher::isRightBracket).collect(Collectors.toCollection(ArrayList::new));
        List<Character> cmplStack = new ArrayList();
        for (char c : completion.toCharArray()) {
            char left = BracketMatcher.getPairedBracket(c);
            if (BracketMatcher.isRightBracket(c)) {
                if (cmplStack.size() - 1 >= 0 && ((Character)cmplStack.get(cmplStack.size() - 1)).charValue() == left) {
                    cmplStack.remove(cmplStack.size() - 1);
                    continue;
                }
                if (leftStack.size() - cmplStack.size() - 1 >= 0 && (leftStack.isEmpty() || ((Character)leftStack.get(leftStack.size() - cmplStack.size() - 1)).charValue() != left)) continue;
                cmplStack.add(Character.valueOf(c));
                continue;
            }
            if (BracketMatcher.isLeftBracket(c)) {
                cmplStack.add(Character.valueOf(c));
                continue;
            }
            if (c != '\n') continue;
        }
        cmplStack = cmplStack.stream().filter(BracketMatcher::isRightBracket).collect(Collectors.toCollection(ArrayList::new));
        Set resolvedRightBrackets = Set.copyOf(cmplStack);
        List leftBracketsToMatch = resolvedRightBrackets.stream().map(BracketMatcher::getPairedBracket).collect(Collectors.toList());
        List resolvableRightStack = rightStack.stream().filter(resolvedRightBrackets::contains).collect(Collectors.toList());
        List resolvableLeftStack = leftStack.stream().filter(leftBracketsToMatch::contains).collect(Collectors.toList());
        return resolvableLeftStack.size() >= resolvableRightStack.size() + cmplStack.size();
    }

    public static boolean isQuoteBalanced(String completion, String before, String after) {
        Stack<Character> stack = new Stack<Character>();
        int lineCount = 0;
        for (int i = before.length() - 1; i >= 0 && lineCount <= 1; --i) {
            char c = before.charAt(i);
            if (c == '\"' || c == '\'' || c == '`') {
                if (stack.size() > 0 && ((Character)stack.get(stack.size() - 1)).charValue() == c) {
                    stack.pop();
                    continue;
                }
                stack.push(Character.valueOf(c));
                continue;
            }
            if (c != '\n') continue;
            ++lineCount;
        }
        Stack<Character> subStack = new Stack<Character>();
        boolean lineCount2 = false;
        for (int i = 0; i < after.length() && lineCount2 <= true; ++i) {
            char c = after.charAt(i);
            if (c == '\"' || c == '\'' || c == '`') {
                if (subStack.size() > 0 && ((Character)subStack.get(subStack.size() - 1)).charValue() == c) {
                    subStack.pop();
                    continue;
                }
                subStack.push(Character.valueOf(c));
                continue;
            }
            if (c == '\n') break;
        }
        Stack<Character> cmplStack = new Stack<Character>();
        for (char c : completion.toCharArray()) {
            if (c == '\"' || c == '\'' || c == '`') {
                if (cmplStack.size() > 0 && ((Character)cmplStack.get(cmplStack.size() - 1)).charValue() == c) {
                    cmplStack.pop();
                    continue;
                }
                cmplStack.push(Character.valueOf(c));
                continue;
            }
            if (c == '\n') break;
        }
        return stack.size() >= subStack.size() + cmplStack.size();
    }

    public static boolean hasOverlappingSymbols(String completion, String before, String after) {
        HashSet<Character> suffixSymbols = new HashSet<Character>();
        for (char c : after.toCharArray()) {
            if (MERGEABLE_OVERLAPPING_SYMBOLS.contains(Character.valueOf(c))) {
                suffixSymbols.add(Character.valueOf(c));
                continue;
            }
            if (c != ' ' && c != '\t' && (c == '\n' || !ALL_MERGEABLE_SYMBOLS.contains(Character.valueOf(c)))) break;
        }
        HashSet<Character> cmplSymbols = new HashSet<Character>();
        for (char c : completion.toCharArray()) {
            if (MERGEABLE_OVERLAPPING_SYMBOLS.contains(Character.valueOf(c))) {
                cmplSymbols.add(Character.valueOf(c));
                continue;
            }
            if (c == '\n') break;
        }
        return suffixSymbols.stream().anyMatch(cmplSymbols::contains);
    }
}

