/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.UIManager;

public class ColorUtils {
    private static final JBColor DEFAULT_RENDERER_HOVER_BACKGROUND = new JBColor(15595004, 4606541);

    public static JBColor getWhiteBlackColor() {
        return new JBColor(0, 0xFFFFFF);
    }

    public static JBColor getLink() {
        return new JBColor(3503344, 3503344);
    }

    public static Color getBackgroundColor() {
        return UIUtil.getPanelBackground();
    }

    public static JBColor getPanelBackgroundColor() {
        return new JBColor(UIUtil.getPanelBackground(), UIUtil.getPanelBackground());
    }

    public static JBColor getTextAreBgColor() {
        return new JBColor(0xFFFFFF, 4606282);
    }

    public static JBColor getTextAreColor() {
        return ColorUtils.getTextColor();
    }

    public static JBColor getTextColor() {
        return new JBColor(0x151515, 0xBBBBBB);
    }

    public static JBColor getWhiteColor() {
        return new JBColor(0xFFFFFF, 0xFFFFFF);
    }

    public static JBColor getTextHolderColor() {
        return new JBColor(0x909090, 0x808080);
    }

    public static boolean isDarkStyle() {
        return UIUtil.isUnderDarcula();
    }

    public static Color getFontColor() {
        return EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getDefaultForeground();
    }

    public static String getBackgroundColorRGB() {
        return ColorUtils.getRGB(UIUtil.getPanelBackground());
    }

    public static String getFontColorRGB() {
        return ColorUtils.getRGB(EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getDefaultForeground());
    }

    public static String getSeparatorColorRGB() {
        return ColorUtils.getRGB(JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
    }

    public static String getDisabledTextColorRGB() {
        return ColorUtils.getRGB(UIUtil.getInactiveTextColor());
    }

    public static String getButtonBackgroundColorRGB() {
        return ColorUtils.getRGB(UIManager.getColor("Button.background"));
    }

    public static String getDisabledButtonBackgroundColorRGB() {
        return ColorUtils.getRGB(UIUtil.getInactiveTextFieldBackgroundColor());
    }

    public static int getFontSize() {
        return JBUI.Fonts.label().getSize();
    }

    public static int getScrollBarRadius() {
        return SystemInfo.isMac ? 10 : 0;
    }

    private static Color toDarker(Color color) {
        double factor = 0.9;
        return new Color(Math.max((int)((double)color.getRed() * factor), 0), Math.max((int)((double)color.getGreen() * factor), 0), Math.max((int)((double)color.getBlue() * factor), 0), color.getAlpha());
    }

    public static String getRGB(Color color) {
        return String.format("rgb(%d, %d, %d)", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static JBColor getChatCodeVariableColor() {
        return new JBColor(920000, 13876101);
    }

    public static JBColor getEditorBackground() {
        Color defaultBackground = UIUtil.getEditorPaneBackground();
        return new JBColor(defaultBackground.brighter(), defaultBackground.darker());
    }

    public static JBColor getCollapseReferenceBackground() {
        return new JBColor(new Color(235, 236, 240), new Color(30, 31, 34));
    }

    public static JBColor getChatInputBackgroundColor() {
        if (ColorUtils.isNewUI()) {
            return new JBColor(new Color(235, 236, 240), new Color(67, 69, 74));
        }
        return new JBColor(new Color(242, 242, 242), new Color(76, 80, 82));
    }

    public static Color getChatInputBackgroundColor(boolean isBright) {
        if (ColorUtils.isNewUI()) {
            return isBright ? new Color(235, 236, 240) : new Color(67, 69, 74);
        }
        return isBright ? new Color(242, 242, 242) : new Color(76, 80, 82);
    }

    public static JBColor getChatInputBorderColor() {
        return new JBColor(new Color(101, 108, 112), new Color(101, 108, 112));
    }

    public static JBColor getCraftInputBackgroundColor() {
        if (ColorUtils.isNewUI()) {
            return new JBColor(new Color(57, 59, 64), new Color(255, 255, 255));
        }
        return new JBColor(new Color(57, 59, 64), new Color(255, 255, 255));
    }

    public static JBColor getCraftInputDefaultBorderColor() {
        return new JBColor(new Color(223, 225, 229), new Color(78, 81, 87));
    }

    public static JBColor getCraftChatBorderFocusedColor() {
        return new JBColor(new Color(127, 132, 255), new Color(127, 132, 255));
    }

    public static JBColor getCraftFileIconColor() {
        return new JBColor(new Color(180, 184, 191), new Color(180, 184, 191));
    }

    public static JBColor getCraftEditTipsWarningColor() {
        return new JBColor(new Color(199, 78, 57), new Color(199, 78, 57));
    }

    public static JBColor getCraftEditTipsColor() {
        return new JBColor(new Color(187, 187, 187), new Color(168, 173, 189));
    }

    public static Color getTextHighlightColor() {
        return new Color(53, 116, 240);
    }

    public static JBColor getChatInputFocusBorderColor() {
        return new JBColor(new Color(53, 116, 240), new Color(53, 116, 240));
    }

    public static JBColor getTextHighlightBgColor() {
        return new JBColor(new Color(215, 225, 252), new Color(56, 122, 199));
    }

    public static JBColor getDisabledTextColor() {
        return new JBColor(new Color(134, 138, 145), new Color(134, 138, 145));
    }

    public static Color getLinkForegroundColor() {
        return JBColor.namedColor((String)"Hyperlink.linkColor", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0)));
    }

    public static Color getButtonHoverBackgroundColor() {
        return JBColor.namedColor((String)"ActionButton.hoverBackground", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0)));
    }

    public static Color getButtonBackgroundColor() {
        return JBColor.namedColor((String)"ActionButton.background");
    }

    public static Color getTextPaneForegroundColor() {
        return JBColor.namedColor((String)"TextPane.foreground", (Color)ColorUtils.getTextForegroundColor());
    }

    public static Color getTextForegroundColor() {
        return new JBColor(UIUtil::getTextAreaForeground);
    }

    public static Color getReferenceTextColor() {
        return new JBColor(Color.BLACK, Color.WHITE);
    }

    public static Color getReferenceLinkColor() {
        return new JBColor(new Color(129, 133, 148), new Color(180, 184, 191));
    }

    public static JBColor getChatQuestionBackgroundColor() {
        if (ColorUtils.isNewUI()) {
            return new JBColor(0xEEEFF2, 2829873);
        }
        return new JBColor(0xF6F6F6, 3948353);
    }

    public static JBColor getChatQuestionBorderColor() {
        if (ColorUtils.isNewUI()) {
            return new JBColor(new Color(242, 242, 242), new Color(50, 50, 50));
        }
        return new JBColor(new Color(223, 225, 229), new Color(30, 31, 34));
    }

    public static JBColor getCardBgColor() {
        if (ColorUtils.isNewUI()) {
            return new JBColor(0xFFFFFF, 3750720);
        }
        return new JBColor(0xECECEC, 3948353);
    }

    public static JBColor getCardHoverBgColor() {
        if (ColorUtils.isNewUI()) {
            return new JBColor((Color)Gray._60, (Color)Gray._60);
        }
        return new JBColor(ColorUtil.withAlpha((Color)Color.BLACK, (double)0.1), ColorUtil.withAlpha((Color)Color.BLACK, (double)0.35));
    }

    public static JBColor getCardBorderColor() {
        if (ColorUtils.isNewUI()) {
            return new JBColor(15461616, 4408650);
        }
        return new JBColor(0xC9C9C9, 0x323232);
    }

    public static JBColor getLogoBgColor() {
        if (ColorUtils.isNewUI()) {
            return new JBColor(3503344, 3494799);
        }
        return new JBColor(3503344, 3503344);
    }

    public static JBColor getInlineChatBgColor() {
        if (ColorUtils.isNewUI()) {
            return new JBColor(16382715, JBColor.namedColor((String)"Panel.background", (Color)new JBColor((Color)Gray.x99, (Color)Gray.x78)).getRGB());
        }
        return new JBColor(16382715, JBColor.namedColor((String)"Panel.background", (Color)Gray.x78).getRGB());
    }

    public static JBColor getInlineChatBorderColor() {
        JBColor borderColor = JBColor.namedColor((String)"Component.separatorColor", (Color)new JBColor((Color)Gray.xCD, (Color)Gray.x4D));
        return new JBColor(borderColor.darker(), (Color)borderColor);
    }

    public static boolean isNewUI() {
        try {
            Class<?> experimentalUI = Class.forName("com.intellij.ui.ExperimentalUI");
            return (Boolean)experimentalUI.getMethod("isNewUI", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static JBColor getListHoverBackground() {
        return JBColor.namedColor((String)"List.hoverBackground", (Color)DEFAULT_RENDERER_HOVER_BACKGROUND);
    }

    public static JBColor getEditAcceptBackground() {
        return new JBColor(new Color(47, 194, 35), new Color(44, 166, 30));
    }

    public static JBColor getEditRejectBackground() {
        return new JBColor(new Color(209, 24, 24), new Color(184, 20, 20));
    }

    public static JBColor getCrafDescriptionColor() {
        return new JBColor(new Color(134, 138, 145), new Color(134, 138, 145));
    }
}

