/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;

public class CommandUtils {
    public static String executeCommand(String command, long timeout) {
        StringBuilder output = new StringBuilder();
        try {
            String line;
            Process process = new ProcessBuilder(command.split("\\s+")).start();
            InputStream inputStream = process.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = bufferedReader.readLine()) != null) {
                output.append(line).append("\n");
            }
            bufferedReader.close();
            if (!process.waitFor(timeout, TimeUnit.MILLISECONDS)) {
                process.destroy();
                throw new RuntimeException("Command execution timed out: " + command);
            }
            if (process.exitValue() != 0) {
                throw new RuntimeException("Command execution failed: " + command);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Failed to execute command: " + command, e);
        }
        return output.toString();
    }
}

