/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;

public class ComponentUtils {
    public static <T extends JComponent> List<T> findTargetComponents(Component component, Class<T> targetClass) {
        ArrayList<JComponent> result = new ArrayList<JComponent>();
        if (targetClass.isInstance(component)) {
            result.add((JComponent)component);
        }
        if (component instanceof JComponent) {
            for (Component child : ((JComponent)component).getComponents()) {
                result.addAll(ComponentUtils.findTargetComponents(child, targetClass));
            }
        }
        return result;
    }

    public static <T extends JComponent> Component findTargetComponent(Component component, Class<T> targetClass) {
        if (targetClass.isInstance(component)) {
            return component;
        }
        if (component instanceof JComponent) {
            for (Component child : ((JComponent)component).getComponents()) {
                Component foundComponent = ComponentUtils.findTargetComponent(child, targetClass);
                if (foundComponent == null) continue;
                return foundComponent;
            }
        }
        return null;
    }

    public static <T extends Container> T findParent(Component component, Class<T> parentClass) {
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!parentClass.isInstance(parent)) continue;
            return (T)((Container)parentClass.cast(parent));
        }
        return null;
    }

    public static void foreachChildComponent(JComponent component, Consumer<JComponent> handler) {
        LinkedList<JComponent> componentList = new LinkedList<JComponent>();
        componentList.offer(component);
        while (componentList.size() > 0) {
            JComponent child = (JComponent)componentList.poll();
            if (child == null) continue;
            handler.accept(child);
            for (Component jComponent : child.getComponents()) {
                if (!(jComponent instanceof JComponent)) continue;
                componentList.offer((JComponent)jComponent);
            }
        }
    }
}

