/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;

public class CompressUtils {
    public static void unzip(URL zipUrl, String destDir) throws IOException {
        if (zipUrl == null) {
            return;
        }
        try (ZipArchiveInputStream archiveInputStream = new ZipArchiveInputStream(zipUrl.openStream(), StandardCharsets.UTF_8.name());){
            CompressUtils.unzip((ArchiveInputStream)archiveInputStream, destDir);
        }
    }

    public static void unzipTar(URL tarUrl, String destDir, CompressType compressType) throws IOException {
        if (tarUrl == null) {
            return;
        }
        TarArchiveInputStream archiveInputStream = null;
        switch (compressType) {
            case EMPTY: {
                archiveInputStream = new TarArchiveInputStream(tarUrl.openStream(), StandardCharsets.UTF_8.name());
                break;
            }
            case GZ: {
                archiveInputStream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(tarUrl.openStream()), StandardCharsets.UTF_8.name());
                break;
            }
            case XZ: {
                archiveInputStream = new TarArchiveInputStream((InputStream)new XZCompressorInputStream(tarUrl.openStream()), StandardCharsets.UTF_8.name());
                break;
            }
        }
        if (archiveInputStream == null) {
            return;
        }
        CompressUtils.unzip(archiveInputStream, destDir);
    }

    private static void unzip(ArchiveInputStream archiveInputStream, String destDir) throws IOException {
        ArchiveEntry entry;
        while ((entry = archiveInputStream.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            File outputFile = new File(destDir + "/" + entry.getName());
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            byte[] data = new byte[1024];
            try (FileOutputStream os = new FileOutputStream(outputFile);){
                int n;
                while ((n = archiveInputStream.read(data)) != -1) {
                    os.write(data, 0, n);
                }
                os.flush();
            }
        }
    }

    public static enum CompressType {
        EMPTY,
        GZ,
        XZ;

    }
}

