/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.tencent.code.intel.bean.item.Position;
import com.tencent.code.intel.bean.item.Range;
import com.tencent.code.intel.bean.item.VirtualFileUriBean;
import com.tencent.code.intel.impl.InlayService;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.ui.inlayhints.CopilotInlayPresentation;
import com.tencent.code.intel.util.CollectionUtils;
import com.tencent.code.intel.util.FileUtils;
import com.tencent.code.intel.util.LanguageUtils;
import com.tencent.code.intel.util.PluginUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopilotEditorUtils {
    public static Range getVisualRange(Editor editor) {
        try {
            if (!CopilotEditorUtils.isEditorAvailable(editor)) {
                return null;
            }
            Rectangle rectangle = editor.getScrollingModel().getVisibleArea();
            VisualPosition startPosition = editor.xyToVisualPosition(new Point(rectangle.x, rectangle.y));
            VisualPosition endPosition = editor.xyToVisualPosition(new Point(rectangle.width, rectangle.y + rectangle.height));
            return new Range(new Position(startPosition.line, startPosition.column), new Position(endPosition.line, endPosition.column));
        }
        catch (Exception e) {
            LogManager.warn(CopilotEditorUtils.class, "getVisualRange:" + e.toString());
            return null;
        }
    }

    public static boolean isSplitEditor(Editor editor) {
        if (editor == null || !CopilotEditorUtils.isProjectAlive(editor)) {
            return false;
        }
        VirtualFile virtualFile = CopilotEditorUtils.getVirtualFile(editor);
        if (virtualFile == null) {
            return false;
        }
        int length = FileEditorManager.getInstance((Project)editor.getProject()).getAllEditors(virtualFile).length;
        return length > 1;
    }

    public static String getCopilotFilePath(Editor editor) {
        VirtualFile virtualFile = CopilotEditorUtils.getVirtualFile(editor);
        if (virtualFile == null) {
            return "";
        }
        return CopilotEditorUtils.getCopilotFilePath(virtualFile);
    }

    public static String getCopilotFilePath(VirtualFile virtualFile) {
        return VirtualFileUriBean.from(virtualFile).getUri();
    }

    public static String getWorkspaceFolder(Project project) {
        VirtualFile projectRoot;
        VirtualFileSystem vfs = VirtualFileManager.getInstance().getFileSystem("file");
        if (!TextUtils.isEmpty((CharSequence)project.getBasePath()) && (projectRoot = vfs.findFileByPath(project.getBasePath())) != null) {
            return CopilotEditorUtils.getCopilotFilePath(projectRoot);
        }
        return null;
    }

    public static boolean isTestOrInjectedText(Editor editor) {
        return (Boolean)ReadAction.compute(() -> {
            PsiFile psiFile = CopilotEditorUtils.getPsiFile(editor);
            Project project = editor.getProject();
            if (project != null && psiFile != null && psiFile.getVirtualFile() != null) {
                boolean isTest = ProjectRootManager.getInstance((Project)project).getFileIndex().isInTestSourceContent(psiFile.getVirtualFile());
                boolean isInjectedText = psiFile.getVirtualFile() instanceof VirtualFileWindow;
                return isTest || isInjectedText;
            }
            return false;
        });
    }

    public static boolean isInjectedFile(Editor editor) {
        return (Boolean)ReadAction.compute(() -> {
            PsiFile psiFile = CopilotEditorUtils.getPsiFile(editor);
            return psiFile != null && psiFile.getVirtualFile() != null && psiFile.getVirtualFile() instanceof VirtualFileWindow;
        });
    }

    @Nullable
    public static Editor editorFromVirtualFile(VirtualFile file, Project project) {
        FileEditor[] allEditors = FileEditorManager.getInstance((Project)project).getAllEditors(file);
        if (allEditors.length > 0 && allEditors[0] instanceof TextEditor) {
            return ((TextEditor)allEditors[0]).getEditor();
        }
        return null;
    }

    public static boolean isSelectNotBlank(Editor editor) {
        return editor.getSelectionModel().hasSelection() && !TextUtils.isBlank((CharSequence)editor.getSelectionModel().getSelectedText());
    }

    public static String selectPsiFileToPrompt(Editor editor, PsiFile psiFile, String promptStart) {
        String selectContent = CopilotEditorUtils.getSelectedContent(editor);
        String markdownLanguage = LanguageUtils.getLanguageIdWithSuffix(editor);
        return promptStart + "\n\n```" + markdownLanguage + "\n" + selectContent + "\n```\n";
    }

    public static int calculateWidth(Editor editor, String source) {
        Font font = InlayService.getInstance().getFont(editor, editor.getDocument().getText());
        FontMetrics metrics = InlayService.getInstance().getFontMetrics(editor, font);
        return metrics.stringWidth(source);
    }

    public static boolean isMultiFileNoSelect(@NotNull Editor editor, VirtualFile virtualFile) {
        Editor selectEditor;
        if (editor == null) {
            CopilotEditorUtils.$$$reportNull$$$0(0);
        }
        Project project = editor.getProject();
        if (virtualFile == null || project == null || project.isDisposed()) {
            return false;
        }
        if (CopilotEditorUtils.hasEditors(project, virtualFile) && (selectEditor = CopilotEditorUtils.getSelectEditor(project)) != null && !selectEditor.equals(editor)) {
            LogManager.info(CopilotEditorUtils.class, "\u540c\u4e2a\u6587\u4ef6\u6253\u5f00\u591a\u6b21\uff0c\u672c\u6b21\u53d8\u66f4\u4e0d\u662f\u9009\u4e2d\u7684\u6587\u4ef6\u53d8\u66f4\uff0c\u5ffd\u7565\u3002");
            return true;
        }
        return false;
    }

    public static boolean hasEditors(Project project, @NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CopilotEditorUtils.$$$reportNull$$$0(1);
        }
        if (project == null || FileEditorManager.getInstance((Project)project) == null) {
            return false;
        }
        return FileEditorManager.getInstance((Project)project).getAllEditors(virtualFile).length > 0;
    }

    public static Project[] getOpenedProjects() {
        return ProjectManager.getInstance().getOpenProjects();
    }

    public static Project getProjectFromWorkspaceFolder(String workspaceFolderUri) {
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        VirtualFileSystem vfs = VirtualFileManager.getInstance().getFileSystem("file");
        for (Project openProject : openProjects) {
            String uri;
            VirtualFile projectRoot;
            if (TextUtils.isEmpty((CharSequence)openProject.getBasePath()) || (projectRoot = vfs.findFileByPath(openProject.getBasePath())) == null || !(uri = CopilotEditorUtils.getCopilotFilePath(projectRoot)).equals(workspaceFolderUri)) continue;
            return openProject;
        }
        return null;
    }

    public static String getWorkspaceNormalPathFromProject(Project project) {
        if (project == null || project.isDisposed() || TextUtils.isEmpty((CharSequence)project.getBasePath())) {
            return null;
        }
        VirtualFileSystem vfs = VirtualFileManager.getInstance().getFileSystem("file");
        VirtualFile projectRoot = vfs.findFileByPath(project.getBasePath());
        if (projectRoot != null) {
            return FileUtils.normalizeFilePath(VirtualFileUriBean.from(projectRoot).getUri());
        }
        return null;
    }

    public static boolean isProjectAlive(Editor editor) {
        boolean isAlive;
        boolean bl = isAlive = editor != null && editor.getProject() != null;
        if (isAlive && editor.getProject().isDisposed()) {
            LogManager.info(CopilotEditorUtils.class, "isProjectAlive-project isDisposed:" + editor.getProject().getName());
        }
        return isAlive;
    }

    public static boolean isProjectAlive(Project project) {
        return project != null && !project.isDisposed();
    }

    public static String getVisibleContent(Editor editor) {
        String visibleCode = "";
        if (editor != null && !editor.isDisposed()) {
            try {
                ScrollingModel scrollingModel = editor.getScrollingModel();
                Rectangle visibleArea = scrollingModel.getVisibleArea();
                Document document = editor.getDocument();
                VisualPosition startVisualPosition = editor.xyToVisualPosition(new Point(visibleArea.x, visibleArea.y));
                int startLine = startVisualPosition.line;
                VisualPosition endVisualPosition = editor.xyToVisualPosition(new Point(visibleArea.x, visibleArea.y + visibleArea.height));
                int endLine = Math.min(endVisualPosition.getLine(), document.getLineCount() - 1);
                int startOffset = document.getLineStartOffset(startLine);
                int endOffset = document.getLineEndOffset(endLine);
                visibleCode = document.getText(new TextRange(startOffset, endOffset));
            }
            catch (Exception e) {
                LogManager.warn(CopilotEditorUtils.class, "getVisibleContent:" + e.toString());
            }
        }
        return visibleCode;
    }

    public static String getSelectedContent(Editor editor) {
        int end;
        if (editor == null || editor.isDisposed()) {
            return null;
        }
        int start = editor.getSelectionModel().getSelectionStart();
        if (start == (end = editor.getSelectionModel().getSelectionEnd())) {
            return null;
        }
        TextRange range = new TextRange(start, end);
        editor.getDocument();
        return editor.getDocument().getText(range);
    }

    public static boolean isSelectedMode(Editor editor) {
        if (editor == null || editor.isDisposed()) {
            return false;
        }
        int start = editor.getSelectionModel().getSelectionStart();
        int end = editor.getSelectionModel().getSelectionEnd();
        return end > start;
    }

    public static boolean isFocusedEditor(Editor editor) {
        if (ApplicationManager.getApplication().isUnitTestMode() || PluginUtils.isRemoteIDE() || PluginUtils.isGatewayClient() || PluginUtils.isGatewayHost()) {
            return true;
        }
        if (!CopilotEditorUtils.isProjectAlive(editor)) {
            return false;
        }
        boolean isFocus = editor.getContentComponent().isFocusOwner();
        if (isFocus) {
            return true;
        }
        VirtualFile targetVirtualFile = CopilotEditorUtils.getVirtualFile(editor);
        VirtualFile selectVirtualFile = CopilotEditorUtils.getVirtualFile(CopilotEditorUtils.getSelectEditor(editor.getProject()));
        return targetVirtualFile != null && selectVirtualFile != null && targetVirtualFile.getPath().equals(selectVirtualFile.getPath());
    }

    public static void hideInlayHintsSink(Editor editor) {
        List<Inlay<?>> inlays;
        if (editor != null && !editor.isDisposed() && !CollectionUtils.isEmpty(inlays = CopilotEditorUtils.getBlockElements(editor))) {
            inlays.forEach(it -> {
                if (CopilotEditorUtils.hasCopilotInlayPresentation(it)) {
                    it.dispose();
                }
            });
        }
    }

    public static boolean isInlayHintsSinkEmpty(Editor editor) {
        boolean isEmpty = true;
        List<Inlay<?>> inlays = CopilotEditorUtils.getBlockElements(editor);
        if (!CollectionUtils.isEmpty(inlays)) {
            for (Inlay<?> inlay : inlays) {
                if (!CopilotEditorUtils.hasCopilotInlayPresentation(inlay)) continue;
                isEmpty = false;
                break;
            }
        }
        return isEmpty;
    }

    public static boolean hasCopilotInlayPresentation(Inlay<?> inlay) {
        try {
            return inlay.getRenderer().toString().contains(CopilotInlayPresentation.class.getPackageName());
        }
        catch (Exception e) {
            LogManager.warn(CopilotEditorUtils.class, "hasCopilotInlayPresentation:" + e.toString());
            return false;
        }
    }

    public static List<Inlay<?>> getBlockElements(Editor editor) {
        try {
            if (editor != null && !editor.isDisposed() && !(editor instanceof EditorWindow)) {
                return editor.getInlayModel().getBlockElementsInRange(0, editor.getDocument().getTextLength());
            }
        }
        catch (Exception e) {
            LogManager.warn(CopilotEditorUtils.class, "getBlockElements:" + e.toString());
            return null;
        }
        return null;
    }

    public static Position position(@NotNull Document document, int offset) {
        int maxOffset;
        if (document == null) {
            CopilotEditorUtils.$$$reportNull$$$0(2);
        }
        if (offset > (maxOffset = document.getTextLength())) {
            LogManager.warn(CopilotEditorUtils.class, "\u83b7\u53d6position\u8d8a\u754c,\u53d6\u6700\u5927\u503c:" + offset + ":" + maxOffset);
            offset = maxOffset;
        }
        int line = document.getLineNumber(offset);
        int lineStart = document.getLineStartOffset(line);
        int column = offset - lineStart;
        return new Position(line, column);
    }

    public static int position2Offset(@NotNull Document document, @NotNull Position position) {
        if (document == null) {
            CopilotEditorUtils.$$$reportNull$$$0(3);
        }
        if (position == null) {
            CopilotEditorUtils.$$$reportNull$$$0(4);
        }
        try {
            int lineStart = document.getLineStartOffset(position.getLine());
            return lineStart + position.getCharacter();
        }
        catch (Exception e) {
            LogManager.info(CopilotEditorUtils.class, "\u83b7\u53d6position2Offset\u5f02\u5e38:" + e.toString());
            return 0;
        }
    }

    public static Position shiftByText(@NotNull Position position, @NotNull CharSequence text) {
        if (position == null) {
            CopilotEditorUtils.$$$reportNull$$$0(5);
        }
        if (text == null) {
            CopilotEditorUtils.$$$reportNull$$$0(6);
        }
        if (TextUtils.isEmpty((CharSequence)text)) {
            return position;
        }
        LineColumn offset = StringUtil.offsetToLineColumn((CharSequence)text, (int)text.length());
        int line = offset.line;
        int column = line == 0 ? position.getCharacter() + offset.column : offset.column;
        return new Position(position.getLine() + line, column);
    }

    public static Editor getActiveEditor(@NotNull Document document) {
        Editor activeEditor;
        if (document == null) {
            CopilotEditorUtils.$$$reportNull$$$0(7);
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            LogManager.info(CopilotEditorUtils.class, "!ApplicationManager.getApplication().isDispatchThread()");
            return null;
        }
        Component focusOwner = IdeFocusManager.getGlobalInstance().getFocusOwner();
        DataContext dataContext = DataManager.getInstance().getDataContext(focusOwner);
        Editor editor = activeEditor = ApplicationManager.getApplication().isDisposed() ? null : (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (activeEditor != null && activeEditor.getDocument() != document) {
            activeEditor = null;
        }
        return activeEditor;
    }

    public static boolean isEditorReadWrite(Editor editor, int newOffset) {
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor) || editor.getDocument().getRangeGuard(newOffset, newOffset) != null) {
            editor.getDocument().fireReadOnlyModificationAttempt();
            LogManager.info(CopilotEditorUtils.class, "fireReadOnlyModificationAttempt");
            return false;
        }
        return true;
    }

    public static boolean isEditorAvailable(Editor editor) {
        boolean result;
        if (editor == null) {
            LogManager.warn(CopilotEditorUtils.class, "isEditorAvailable-editor\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        boolean condition1 = !(editor instanceof EditorWindow);
        boolean condition2 = !(editor instanceof ImaginaryEditor);
        boolean condition3 = !(editor instanceof EditorEx) || !((EditorEx)editor).isEmbeddedIntoDialogWrapper();
        boolean condition4 = !editor.isViewer();
        boolean condition5 = !editor.isOneLineMode();
        boolean bl = result = condition1 && condition2 && condition3 && condition4 && condition5;
        if (!result) {
            LogManager.info(CopilotEditorUtils.class, "\u5f53\u524d\u7f16\u8f91\u5668\u4e0d\u53ef\u7528\uff1a" + condition1 + "-" + condition2 + "-" + condition3 + "-" + condition4 + "-" + condition5);
        }
        return result;
    }

    public static boolean isSupportFileType(Editor editor) {
        try {
            if (editor == null) {
                LogManager.info(CopilotEditorUtils.class, "isSupportFileType-editor null");
                return false;
            }
            if (editor.getEditorKind() != EditorKind.MAIN_EDITOR) {
                LogManager.info(CopilotEditorUtils.class, "not support file \uff1a" + String.valueOf(editor.getEditorKind()));
                return false;
            }
            if (!CopilotEditorUtils.isProjectAlive(editor)) {
                LogManager.info(CopilotEditorUtils.class, "editor project useless\uff1a" + (editor.getProject() == null));
                return false;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument());
            if (psiFile != null) {
                return LanguageUtils.isGfSpLanguage(psiFile);
            }
        }
        catch (Exception e) {
            LogManager.warn(CopilotEditorUtils.class, "isSupportFileType err\uff1a" + e.toString());
        }
        return false;
    }

    public static PsiFile getPsiFile(Editor editor) {
        if (editor != null && !editor.isDisposed()) {
            Project project = editor.getProject();
            Document document = editor.getDocument();
            if (project != null && !project.isDisposed()) {
                return PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            }
        }
        return null;
    }

    public static VirtualFile getVirtualFile(Editor editor) {
        PsiFile psiFile = CopilotEditorUtils.getPsiFile(editor);
        if (psiFile != null) {
            return psiFile.getVirtualFile();
        }
        return null;
    }

    public static Editor getSelectEditor(Project project) {
        FileEditor current;
        FileEditorManager editorManager;
        Project selectProject = project;
        if (selectProject == null) {
            selectProject = CopilotEditorUtils.getFirstProject();
        }
        if (selectProject != null && (editorManager = FileEditorManager.getInstance((Project)selectProject)) != null && (current = editorManager.getSelectedEditor()) instanceof TextEditor) {
            return ((TextEditor)current).getEditor();
        }
        return null;
    }

    public static boolean isSelectedEditor(Editor editor) {
        boolean result;
        if (editor == null) {
            LogManager.warn(CopilotEditorUtils.class, "Editor\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        Project project = editor.getProject();
        if (project == null || project.isDisposed()) {
            LogManager.warn(CopilotEditorUtils.class, "Editor\u7684project\u4e0d\u53ef\u7528");
            return false;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        if (editorManager == null) {
            LogManager.warn(CopilotEditorUtils.class, "FileEditorManager\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        FileEditor current = editorManager.getSelectedEditor();
        if (current == null) {
            LogManager.warn(CopilotEditorUtils.class, "SelectedEditor\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        boolean bl = result = current instanceof TextEditor && editor.equals(((TextEditor)current).getEditor());
        if (!result) {
            String selectFileUrl = CopilotEditorUtils.getCopilotFilePath(current.getFile());
            String fileUrl = CopilotEditorUtils.getCopilotFilePath(editor);
            result = selectFileUrl.equals(fileUrl);
        }
        return result;
    }

    public static String getCursorPrefix(@NotNull Document document, int offset) {
        if (document == null) {
            CopilotEditorUtils.$$$reportNull$$$0(8);
        }
        try {
            int maxOffset = document.getTextLength();
            if (offset > maxOffset) {
                LogManager.warn(CopilotEditorUtils.class, "getCursorPrefix,\u53d6\u6700\u5927\u503c:" + offset + ":" + maxOffset);
                offset = maxOffset;
            }
            int lineNumber = document.getLineNumber(offset);
            int lineStart = document.getLineStartOffset(lineNumber);
            return document.getText(TextRange.create((int)lineStart, (int)offset)).trim();
        }
        catch (Throwable e) {
            LogManager.warn(CopilotEditorUtils.class, "Failed to get cursor prefix: " + e.toString());
            return "";
        }
    }

    @Nullable
    public static String getCursorSuffix(@NotNull Document document, int offset) {
        if (document == null) {
            CopilotEditorUtils.$$$reportNull$$$0(9);
        }
        try {
            int maxOffset = document.getTextLength();
            if (offset > maxOffset) {
                LogManager.warn(CopilotEditorUtils.class, "getCursorSuffix,\u53d6\u6700\u5927\u503c:" + offset + ":" + maxOffset);
                offset = maxOffset;
            }
            int lineNumber = document.getLineNumber(offset);
            int lineEnd = document.getLineEndOffset(lineNumber);
            return document.getText(TextRange.create((int)offset, (int)lineEnd)).trim();
        }
        catch (Throwable e) {
            LogManager.warn(CopilotEditorUtils.class, "Failed to get cursor suffix: " + e.toString());
            return "";
        }
    }

    public static PsiElement getLinePsiElement(Editor editor, int offset) {
        if (editor == null || editor.isDisposed()) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        int lineNumber = editor.getDocument().getLineNumber(offset);
        PsiFile psiFile = CopilotEditorUtils.getPsiFile(editor);
        if (psiFile != null && psiFile.isValid()) {
            return psiFile.findElementAt(editor.getDocument().getLineStartOffset(lineNumber));
        }
        return null;
    }

    public static String getLineText(Editor editor, int offset, int addLine) {
        if (editor == null || editor.isDisposed()) {
            return "";
        }
        Project project = editor.getProject();
        if (project == null) {
            return "";
        }
        try {
            int lineNumber;
            Document document = editor.getDocument();
            int maxOffset = document.getTextLength();
            if (offset > maxOffset) {
                LogManager.warn(CopilotEditorUtils.class, "getLineText,\u53d6\u6700\u5927\u503c:" + offset + ":" + maxOffset);
                offset = maxOffset;
            }
            if ((lineNumber = document.getLineNumber(offset) + addLine) + addLine > document.getLineCount() - 1) {
                return "";
            }
            int lineStartOffset = document.getLineStartOffset(lineNumber);
            int lineEndOffset = document.getLineEndOffset(lineNumber);
            return document.getText(new TextRange(lineStartOffset, lineEndOffset));
        }
        catch (Exception e) {
            LogManager.warn(CopilotEditorUtils.class, "getLineText-" + e.toString());
            return "";
        }
    }

    public static String getLineTextAfterCaret(Editor editor, int offset) {
        if (editor == null || editor.isDisposed()) {
            return "";
        }
        Project project = editor.getProject();
        if (project == null) {
            return "";
        }
        try {
            int lineNumber;
            int lineEndOffset;
            String result;
            Document document = editor.getDocument();
            int maxOffset = document.getTextLength();
            if (offset > maxOffset) {
                LogManager.warn(CopilotEditorUtils.class, "getLineTextAfterCaret,\u53d6\u6700\u5927\u503c:" + offset + ":" + maxOffset);
                offset = maxOffset;
            }
            if (!(result = document.getText(new TextRange(offset, lineEndOffset = document.getLineEndOffset(lineNumber = document.getLineNumber(offset))))).isEmpty()) {
                return result.replaceAll("\\s+$", "");
            }
        }
        catch (Exception e) {
            LogManager.warn(CopilotEditorUtils.class, "getLineTextAfterCaret" + e.toString());
        }
        return "";
    }

    public static String getLinesTextBeforeCaret(Editor editor, int offset, int lines) {
        if (editor == null || editor.isDisposed()) {
            return "";
        }
        Project project = editor.getProject();
        if (project == null) {
            return "";
        }
        try {
            Document document = editor.getDocument();
            offset = Math.min(offset, document.getTextLength());
            int lineNumber = document.getLineNumber(offset);
            int lineStartOffset = document.getLineStartOffset(Math.max(0, lineNumber - lines));
            return document.getText(new TextRange(lineStartOffset, offset));
        }
        catch (Exception e) {
            LogManager.warn(CopilotEditorUtils.class, "getLinesTextBeforeCaret" + e.toString());
            return "";
        }
    }

    public static String getLinesTextAfterCaret(Editor editor, int offset, int lines) {
        if (editor == null || editor.isDisposed()) {
            return "";
        }
        Project project = editor.getProject();
        if (project == null) {
            return "";
        }
        try {
            Document document = editor.getDocument();
            offset = Math.min(offset, document.getTextLength());
            int lineNumber = document.getLineNumber(offset);
            int maxLine = document.getLineCount();
            int lineEndOffset = document.getLineEndOffset(Math.min(maxLine - 1, lineNumber + lines));
            return document.getText(new TextRange(offset, lineEndOffset));
        }
        catch (Exception e) {
            LogManager.warn(CopilotEditorUtils.class, "getLinesTextBeforeCaret" + e.toString());
            return "";
        }
    }

    public static String getLineTextBeforeCaret(Editor editor, int offset) {
        if (editor == null || editor.isDisposed()) {
            return "";
        }
        Project project = editor.getProject();
        if (project == null) {
            return "";
        }
        try {
            Document document = editor.getDocument();
            int maxOffset = document.getTextLength();
            if (offset > maxOffset) {
                LogManager.warn(CopilotEditorUtils.class, "getLineTextAfterCaret,\u53d6\u6700\u5927\u503c:" + offset + ":" + maxOffset);
                offset = maxOffset;
            }
            int lineNumber = document.getLineNumber(offset);
            int lineStartOffset = document.getLineStartOffset(lineNumber);
            return document.getText(new TextRange(lineStartOffset, offset));
        }
        catch (Exception e) {
            LogManager.warn(CopilotEditorUtils.class, "getLineTextBeforeCaret" + e.toString());
            return "";
        }
    }

    public static int getLineStartOffset(Editor editor, int offset) {
        if (editor == null || editor.isDisposed()) {
            return 0;
        }
        Project project = editor.getProject();
        if (project == null) {
            return 0;
        }
        try {
            Document document = editor.getDocument();
            int maxOffset = document.getTextLength();
            if (offset > maxOffset) {
                LogManager.warn(CopilotEditorUtils.class, "getLineStartOffset,\u53d6\u6700\u5927\u503c:" + offset + ":" + maxOffset);
                offset = maxOffset;
            }
            int lineNumber = document.getLineNumber(offset);
            return document.getLineStartOffset(lineNumber);
        }
        catch (Exception e) {
            LogManager.warn(CopilotEditorUtils.class, "getLineStartOffset" + e.toString());
            return 0;
        }
    }

    public static int getLineEndOffset(Editor editor, int offset) {
        if (editor == null || editor.isDisposed()) {
            return 0;
        }
        Project project = editor.getProject();
        if (project == null) {
            return 0;
        }
        try {
            Document document = editor.getDocument();
            int maxOffset = document.getTextLength();
            if (offset > maxOffset) {
                LogManager.warn(CopilotEditorUtils.class, "getLineEndOffset,\u53d6\u6700\u5927\u503c:" + offset + ":" + maxOffset);
                offset = maxOffset;
            }
            int lineNumber = document.getLineNumber(offset);
            return document.getLineEndOffset(lineNumber);
        }
        catch (Exception e) {
            LogManager.warn(CopilotEditorUtils.class, "getLineEndOffset" + e.toString());
            return 0;
        }
    }

    public static int getLineEndOffsetByOffset(Editor editor, int offset) {
        if (editor == null || editor.isDisposed()) {
            return 0;
        }
        Project project = editor.getProject();
        if (project == null) {
            return 0;
        }
        try {
            int lineNumber;
            int lineStartOffset;
            Document document = editor.getDocument();
            int maxOffset = document.getTextLength();
            if (offset > maxOffset) {
                LogManager.warn(CopilotEditorUtils.class, "getLineEndOffset,\u53d6\u6700\u5927\u503c:" + offset + ":" + maxOffset);
                offset = maxOffset;
            }
            if ((lineStartOffset = document.getLineStartOffset(lineNumber = document.getLineNumber(offset))) == offset) {
                return offset;
            }
            return document.getLineEndOffset(lineNumber);
        }
        catch (Exception e) {
            LogManager.warn(CopilotEditorUtils.class, "getLineEndOffset" + e.toString());
            return 0;
        }
    }

    public static int getLineStartOffsetByLine(Editor editor, int line) {
        if (editor == null || editor.isDisposed()) {
            return 0;
        }
        Project project = editor.getProject();
        if (project == null) {
            return 0;
        }
        try {
            Document document = editor.getDocument();
            int totalLineCnt = document.getLineCount();
            if (line != 0 && line >= totalLineCnt) {
                LogManager.warn(CopilotEditorUtils.class, "getLineStartOffsetByLineNume,\u53d6\u6700\u5927\u503c:" + totalLineCnt + ":" + line);
                return document.getTextLength();
            }
            return document.getLineStartOffset(line);
        }
        catch (Exception e) {
            LogManager.warn(CopilotEditorUtils.class, "getLineStartOffsetByLineNume" + e.toString());
            return 0;
        }
    }

    public static int getLineEndOffsetByLine(Editor editor, int line) {
        if (editor == null || editor.isDisposed()) {
            return 0;
        }
        Project project = editor.getProject();
        if (project == null) {
            return 0;
        }
        try {
            Document document = editor.getDocument();
            int totalLineCnt = document.getLineCount();
            if (line >= totalLineCnt) {
                LogManager.warn(CopilotEditorUtils.class, "getLineEndOffsetByLineNume,\u53d6\u6700\u5927\u503c:" + totalLineCnt + ":" + line);
                return document.getTextLength();
            }
            return document.getLineEndOffset(line);
        }
        catch (Exception e) {
            LogManager.warn(CopilotEditorUtils.class, "getLineEndOffsetByLineNume" + e.toString());
            return 0;
        }
    }

    public static int getLineNumber(Editor editor, int offset) {
        if (editor == null || editor.isDisposed()) {
            return 0;
        }
        Project project = editor.getProject();
        if (project == null) {
            return 0;
        }
        try {
            Document document = editor.getDocument();
            int totalTextLen = document.getTextLength();
            if (offset > totalTextLen) {
                LogManager.warn(CopilotEditorUtils.class, "getLineNumber, \u53d6\u6700\u5927\u503c: " + totalTextLen + ", cur offset: " + offset);
                offset = totalTextLen - 1;
            }
            return document.getLineNumber(offset);
        }
        catch (Exception e) {
            LogManager.warn(CopilotEditorUtils.class, "getLineNumber" + e.toString());
            return 0;
        }
    }

    public static Project getFirstProject() {
        if (ProjectManager.getInstance().getOpenProjects().length > 0) {
            return ProjectManager.getInstance().getOpenProjects()[0];
        }
        return null;
    }

    public static String getFileUrlByEditor(Editor editor) {
        if (editor == null) {
            return null;
        }
        Document document = editor.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile != null) {
            return virtualFile.getUrl();
        }
        return null;
    }

    public static boolean isCaretAtEmptyLine(Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        int lineNumber = editor.getDocument().getLineNumber(offset);
        int lineStartOffset = editor.getDocument().getLineStartOffset(lineNumber);
        int lineEndOffset = editor.getDocument().getLineEndOffset(lineNumber);
        String lineText = editor.getDocument().getText(new TextRange(lineStartOffset, lineEndOffset));
        return TextUtils.isBlank((CharSequence)lineText) && !editor.getSelectionModel().hasSelection();
    }

    public static boolean isEmptyLine(Editor editor, int startLine, int endLine) {
        if (startLine != endLine) {
            return false;
        }
        int lineStartOffset = editor.getDocument().getLineStartOffset(startLine);
        int lineEndOffset = editor.getDocument().getLineEndOffset(startLine);
        String lineText = editor.getDocument().getText(new TextRange(lineStartOffset, lineEndOffset));
        return TextUtils.isBlank((CharSequence)lineText) && !editor.getSelectionModel().hasSelection();
    }

    public static String getLineTextByLineNumber(Editor editor, int lineNumber) {
        int maxOffset;
        if (lineNumber > editor.getDocument().getLineCount() - 1) {
            return "";
        }
        int offset = editor.getDocument().getLineStartOffset(lineNumber);
        int lineEndOffset = editor.getDocument().getLineEndOffset(lineNumber);
        int endOffset = lineEndOffset + 1;
        if (endOffset > (maxOffset = editor.getDocument().getTextLength())) {
            endOffset = maxOffset;
        }
        return editor.getDocument().getText(new TextRange(offset, endOffset));
    }

    public static TextRange getSelectedRange(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            return new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
        }
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        LogicalPosition startPos = editor.xyToLogicalPosition(new Point(visibleArea.x, visibleArea.y));
        LogicalPosition endPos = editor.xyToLogicalPosition(new Point(visibleArea.x + visibleArea.width, visibleArea.y + visibleArea.height));
        int startOffset = editor.logicalPositionToOffset(startPos);
        int endOffset = editor.logicalPositionToOffset(endPos);
        return new TextRange(startOffset, endOffset);
    }

    public static String getLineText(Editor editor, int lineNumber) {
        Document document = editor.getDocument();
        if (lineNumber < 0 || lineNumber >= document.getLineCount()) {
            return "";
        }
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        return document.getText().substring(lineStartOffset, lineEndOffset);
    }

    public static String getLineIndentString(Editor editor, int offset) {
        int lineStartOffset = CopilotEditorUtils.getLineStartOffset(editor, offset);
        int indentLength = Math.max(0, offset - lineStartOffset);
        return " ".repeat(indentLength);
    }

    public static void jumpToEditorLine(Editor editor, int lineNumber) {
        ThreadManager.getInstance().runUiThread(() -> {
            CaretModel caretModel = editor.getCaretModel();
            caretModel.moveToLogicalPosition(new LogicalPosition(lineNumber, 0));
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/tencent/code/intel/util/CopilotEditorUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isMultiFileNoSelect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasEditors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "position";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "position2Offset";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "shiftByText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getActiveEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getCursorPrefix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getCursorSuffix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

