/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.treeStructure.Tree;
import com.tencent.code.intel.activity.StartupLSAgent;
import com.tencent.code.intel.manager.LogManager;
import java.awt.Component;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;

public class CopilotProjectUtils {
    public static void getProjectTree(String pathPrefix, Project project) {
        ToolWindowManagerEx toolWindowManagerEx;
        ToolWindow toolWindow;
        ToolWindowManager toolWindowManager;
        String projectName = project.getName();
        ProjectView projectView = ProjectView.getInstance((Project)project);
        if (projectView instanceof ProjectViewImpl && (toolWindowManager = ToolWindowManager.getInstance((Project)project)) instanceof ToolWindowManagerEx && (toolWindow = (toolWindowManagerEx = (ToolWindowManagerEx)toolWindowManager).getToolWindow("Project")) != null) {
            Content[] contents;
            toolWindow.activate(null);
            ContentManager contentManager = toolWindow.getContentManager();
            for (Content content : contents = contentManager.getContents()) {
                JComponent component = content.getComponent();
                CopilotProjectUtils.traverseJComponent(projectName, pathPrefix, component);
            }
        }
    }

    private static void traverseJComponent(String projectName, String pathPrefix, JComponent component) {
        Component[] components;
        if (component != null && (components = component.getComponents()) != null) {
            for (Component child : components) {
                if (child instanceof Tree) {
                    DefaultMutableTreeNode rootNode;
                    Tree tree = (Tree)child;
                    Object root = tree.getModel().getRoot();
                    if (root instanceof DefaultMutableTreeNode) {
                        rootNode = (DefaultMutableTreeNode)root;
                        String name = rootNode.getUserObject().toString();
                        for (int i = 0; i < rootNode.getChildCount(); ++i) {
                            if (!projectName.equals(name)) continue;
                            String path = pathPrefix + name;
                            CopilotProjectUtils.traverseTreeMutableTreeNode(rootNode, path);
                        }
                        continue;
                    }
                    if (!(root instanceof AbstractTreeNode)) continue;
                    rootNode = (AbstractTreeNode)root;
                    for (AbstractTreeNode childNode : rootNode.getChildren()) {
                        String name = childNode.getName();
                        if (!projectName.equals(name)) continue;
                        String path = pathPrefix + name;
                        CopilotProjectUtils.traverseAbstractTreeNode(childNode, path);
                        try {
                            VirtualFile targetPathNode = VirtualFileManager.getInstance().findFileByUrl(path);
                            if (targetPathNode == null) continue;
                            LogManager.info(StartupLSAgent.class, new String(targetPathNode.contentsToByteArray(), StandardCharsets.UTF_8));
                        }
                        catch (Exception e) {
                            LogManager.info(StartupLSAgent.class, "AbstractTreeNode e\uff1a" + e.toString());
                        }
                    }
                    continue;
                }
                if (!(child instanceof JComponent)) continue;
                CopilotProjectUtils.traverseJComponent(projectName, pathPrefix, (JComponent)child);
            }
        }
    }

    private static void traverseTreeMutableTreeNode(DefaultMutableTreeNode node, String fatherPath) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            String filePath = Path.of(fatherPath, node.getUserObject().toString()).toString();
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            if (childNode.getChildCount() <= 0) continue;
            CopilotProjectUtils.traverseTreeMutableTreeNode(childNode, filePath);
        }
    }

    private static void traverseAbstractTreeNode(AbstractTreeNode<?> node, String fatherPath) {
        for (AbstractTreeNode childNode : node.getChildren()) {
            String filePath = Path.of(fatherPath, childNode.getName()).toString();
            if (childNode.getChildren().isEmpty()) continue;
            CopilotProjectUtils.traverseAbstractTreeNode(childNode, filePath);
        }
    }
}

