/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.util.CommandUtils;

public class DeviceUtils {
    public static String getSystemUserName() {
        return DeviceUtils.getMachineUserName();
    }

    public static String getSystemUserId() {
        String userId = System.getenv("ACC_USER_ID");
        if (userId == null) {
            userId = DeviceUtils.getSystemUserName();
        }
        return userId;
    }

    public static String getMachineUserName() {
        String userName = System.getenv("ACC_USER_NICKNAME");
        try {
            if (userName == null) {
                userName = CommandUtils.executeCommand("whoami", 1000L).replaceAll("\\s+", "");
            }
        }
        catch (Exception e) {
            LogManager.warn(DeviceUtils.class, "get system username by `whoami` fail, e:" + e.getMessage());
            userName = System.getProperty("user.name");
        }
        return userName != null ? userName : "";
    }

    public static String getUserIdEnv() {
        return System.getenv("ACC_USER_ID");
    }

    public static String getUseNameEnv() {
        return System.getenv("ACC_USER_NICKNAME");
    }
}

