/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DocumentUtils {
    private static final Map<String, String> languageMap = new HashMap<String, String>(){
        {
            this.put("ObjectiveC", "c");
            this.put("C", "c");
            this.put("C++", "cpp");
            this.put("CPP", "cpp");
            this.put("C/C++", "cpp");
            this.put("CSS", "css");
            this.put("Go", "go");
            this.put("Golang", "go");
            this.put("HTML", "html");
            this.put("XHTML", "html");
            this.put("Java", "java");
            this.put("JavaScript", "javascript");
            this.put("ECMAScript 6", "javascript");
            this.put("JavaScript JSX", "javascriptreact");
            this.put("TypeScript JSX", "typescriptreact");
            this.put("TypeScript TSX", "typescriptreact");
            this.put("Python", "python");
            this.put("SCSS", "scss");
            this.put("SQL", "sql");
            this.put("TypeScript", "typescript");
            this.put("PHP", "php");
            this.put("Ruby", "ruby");
            this.put("ruby", "ruby");
            this.put("Kotlin", "kotlin");
            this.put("Markdown", "markdown");
            this.put("Rust", "rust");
            this.put("Shell Script", "shellscript");
            this.put("Vue", "vue");
            this.put("YAML", "yaml");
            this.put("XML", "xml");
            this.put("JSON", "json");
        }
    };
    private static final Map<String, String> suffixLanguageMap = new HashMap<String, String>(){
        {
            this.put("abap", "abap");
            this.put("bat", "bat");
            this.put("bib", "bibtex");
            this.put("clj", "clojure");
            this.put("coffee", "coffeescript");
            this.put("c", "c");
            this.put("cpp", "cpp");
            this.put("cs", "csharp");
            this.put("yml", "dockercompose");
            this.put("css", "css");
            this.put("cu", "cuda-cpp");
            this.put("diff", "diff");
            this.put("dockerfile", "dockerfile");
            this.put("fs", "fsharp");
            this.put("gitcommit", "git-commit");
            this.put("gitrebase", "git-rebase");
            this.put("go", "go");
            this.put("groovy", "groovy");
            this.put("hbs", "handlebars");
            this.put("haml", "haml");
            this.put("html", "html");
            this.put("ini", "ini");
            this.put("java", "java");
            this.put("js", "javascript");
            this.put("jsx", "javascriptreact");
            this.put("json", "json");
            this.put("jsonc", "jsonc");
            this.put("jl", "julia");
            this.put("tex", "latex");
            this.put("less", "less");
            this.put("lua", "lua");
            this.put("makefile", "makefile");
            this.put("md", "markdown");
            this.put("m", "objective-c");
            this.put("mm", "objective-cpp");
            this.put("pl", "perl");
            this.put("php", "php");
            this.put("txt", "plaintext");
            this.put("ps1", "powershell");
            this.put("jade", "jade");
            this.put("pug", "pug");
            this.put("py", "python");
            this.put("r", "r");
            this.put("cshtml", "razor");
            this.put("rb", "ruby");
            this.put("rs", "rust");
            this.put("scss", "scss");
            this.put("sass", "scss");
            this.put("shader", "shaderlab");
            this.put("sh", "shellscript");
            this.put("slim", "slim");
            this.put("sql", "sql");
            this.put("styl", "stylus");
            this.put("swift", "swift");
            this.put("ts", "typescript");
            this.put("tsx", "typescriptreact");
            this.put("tex", "tex");
            this.put("vb", "vb");
            this.put("vue", "vue");
            this.put("xml", "xml");
            this.put("xsl", "xsl");
            this.put("yaml", "yaml");
            this.put("yml", "yaml");
            this.put("cmd", "bat");
        }
    };

    public static int getLineIndent(String line) {
        Matcher matcher = Pattern.compile("^\\s+").matcher(line);
        if (!matcher.find()) {
            return 0;
        }
        return matcher.group().length();
    }

    public static String getLineIndentText(String line) {
        Matcher matcher = Pattern.compile("^\\s+").matcher(line);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(0);
    }

    public static String findLanguageId(PsiFile psiFile) {
        CharSequence fileExtension = FileUtilRt.getExtension((CharSequence)psiFile.getName(), null);
        String languageId = languageMap.getOrDefault(fileExtension != null ? DocumentUtils.getLanguageBySuffix((String)fileExtension) : null, null);
        if (languageId == null) {
            languageId = DocumentUtils.getLanguageBySuffix(psiFile.getVirtualFile().getExtension() != null ? psiFile.getVirtualFile().getExtension() : "");
        }
        if (languageId == null) {
            languageId = languageMap.getOrDefault(psiFile.getLanguage().getDisplayName(), null);
        }
        if (languageId == null) {
            languageId = psiFile.getLanguage().getID().toLowerCase();
        }
        return languageId != null ? languageId : "";
    }

    public static String getLanguageBySuffix(String suffix) {
        return suffixLanguageMap.getOrDefault(suffix, null);
    }

    public static String getFileName(VirtualFile virtualFile, Project project) {
        try {
            ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
            VirtualFile sourceRoot = projectFileIndex.getSourceRootForFile(virtualFile);
            if (sourceRoot != null) {
                return VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)sourceRoot, (char)'/');
            }
            VirtualFile projectRoot = projectFileIndex.getContentRootForFile(virtualFile);
            if (projectRoot != null) {
                return VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)projectRoot, (char)'/');
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getSelectedText(Project project, Editor editor) {
        Editor currentEditor;
        Editor editor2 = currentEditor = editor != null ? editor : FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (currentEditor == null) {
            return "";
        }
        if (!currentEditor.getSelectionModel().hasSelection()) {
            return "";
        }
        return currentEditor.getSelectionModel().getSelectedText() != null ? currentEditor.getSelectionModel().getSelectedText() : "";
    }

    public static String getEditorVisualText(Editor editor) {
        try {
            if (DocumentUtils.getEditorVisualRange(editor) == null) {
                return null;
            }
            return editor.getDocument().getText(DocumentUtils.getEditorVisualRange(editor));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static TextRange getEditorVisualRange(Editor editor) {
        try {
            VisualPosition visibleStartPosition = new VisualPosition(editor.getScrollingModel().getVisibleArea().getLocation().y / editor.getLineHeight(), 0);
            VisualPosition visibleEndPosition = new VisualPosition((int)(((double)editor.getScrollingModel().getVisibleArea().getLocation().y + editor.getScrollingModel().getVisibleArea().getHeight()) / (double)editor.getLineHeight()), 0);
            int visibleStartOffset = editor.logicalPositionToOffset(editor.visualToLogicalPosition(visibleStartPosition));
            int visibleEndOffset = editor.logicalPositionToOffset(editor.visualToLogicalPosition(visibleEndPosition));
            return new TextRange(visibleStartOffset, visibleEndOffset);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatCodeIndent(Document document, int offset, int line, String insertCode) {
        int lineStartOffset = document.getLineStartOffset(line);
        int lineEndOffset = document.getLineEndOffset(line);
        String lineText = document.getText(new TextRange(lineStartOffset, lineEndOffset));
        int lineIndent = DocumentUtils.getLineIndent(lineText);
        int insertIndent = DocumentUtils.getLineIndent(insertCode);
        if (lineIndent == 0) {
            lineIndent = insertIndent;
        }
        if (lineIndent > insertIndent) {
            insertCode = insertCode.replaceAll("^\\s+", "");
        }
        insertCode = insertCode.replaceAll("\n", "\n" + StringUtils.repeat((String)" ", (int)lineIndent));
        return insertCode;
    }

    public static String getRangeContent(Document document, int startLine, int endLine) {
        int fixedEndLine;
        int lineCount = document.getLineCount();
        int fixedStartLine = Math.max(0, startLine);
        if (fixedStartLine > (fixedEndLine = Math.min(lineCount - 1, endLine))) {
            return "";
        }
        int startOffset = document.getLineStartOffset(fixedStartLine);
        int endOffset = document.getLineEndOffset(fixedEndLine);
        return document.getText(new TextRange(startOffset, endOffset));
    }
}

