/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.io.URLUtil;
import com.tencent.code.intel.bean.item.Position;
import com.tencent.code.intel.bean.item.Range;
import com.tencent.code.intel.filter.GitIgnoreFileFilter;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.util.LanguageUtils;
import com.tencent.code.intel.util.PluginUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class FileUtils {
    private static final Pattern FileUrlPattern = Pattern.compile("^file://(.+/)");
    private static final List<String> INVALID_INDEX_DIR = Arrays.asList(".git", ".idea", ".m2", "node_modules");
    private static final List<String> INVALID_INDEX_ROOT_DIR = Arrays.asList("target", "build", "dist", "out", "bin", "lib", "libs", "lib_ext");
    private static final String FILE_PATH_PREFIX = "file:///";
    private static final String CWM_FILE_PATH_PREFIX = "cwm:///";
    static List<VirtualFile> cacheFileList = new ArrayList<VirtualFile>();

    public static String getResource(String name) {
        String string;
        block8: {
            InputStream stream = Objects.requireNonNull(FileUtils.class.getResourceAsStream(name));
            try {
                string = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to read resource", e);
                }
            }
            stream.close();
        }
        return string;
    }

    public static String loadGitignoreContent(VirtualFile baseDir) {
        VirtualFile gitignoreFile = baseDir.findChild(".gitignore");
        try {
            if (gitignoreFile != null && gitignoreFile.exists()) {
                return new String(gitignoreFile.contentsToByteArray());
            }
        }
        catch (IOException e) {
            LogManager.warn(FileUtils.class, "Failed to load .gitignore file: " + e.getMessage());
        }
        return "";
    }

    private static String getRelativePath(VirtualFile file, VirtualFile baseDir) {
        return file.getPath().substring(baseDir.getPath().length() + 1).replace("\\", "/");
    }

    public static List<String> getPartialWorkspacePaths(VirtualFile baseDir, int fileCount) {
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            return new ArrayList<String>();
        }
        String gitignoreContent = FileUtils.loadGitignoreContent(baseDir);
        GitIgnoreFileFilter gitIgnoreFileFilter = new GitIgnoreFileFilter(gitignoreContent);
        ArrayList<String> result = new ArrayList<String>();
        LinkedList<Object> queue = new LinkedList<Object>();
        LinkedList<VirtualFile> nextQueue = new LinkedList<VirtualFile>();
        queue.add(baseDir);
        while (!queue.isEmpty()) {
            VirtualFile[] children;
            VirtualFile currentFile = (VirtualFile)queue.poll();
            try {
                children = currentFile.getChildren();
            }
            catch (Exception e) {
                LogManager.warn(FileUtils.class, "Error accessing children of" + currentFile.getPath() + e.getMessage());
                continue;
            }
            if (children != null) {
                for (VirtualFile child : children) {
                    String relativePath = FileUtils.getRelativePath(child, baseDir);
                    if (!gitIgnoreFileFilter.accept(relativePath)) continue;
                    if (child.isDirectory()) {
                        nextQueue.add(child);
                    }
                    if (result.size() >= fileCount) {
                        return result;
                    }
                    result.add(child.getPath());
                }
            }
            if (!queue.isEmpty()) continue;
            queue.addAll(nextQueue);
            nextQueue.clear();
        }
        return result;
    }

    public static List<String> getPartialWorkspaceStructureRecursive(VirtualFile baseDir, List<String> paths, int depth) {
        VirtualFile[] files;
        boolean isPathIncluded = paths.stream().anyMatch(p -> p.startsWith(baseDir.getPath()));
        if (!(isPathIncluded && baseDir.exists() && baseDir.isDirectory())) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            files = baseDir.getChildren();
        }
        catch (Exception e) {
            LogManager.warn(FileUtils.class, "Error accessing children of" + baseDir.getPath() + e.getMessage());
            return result;
        }
        if (files != null) {
            for (VirtualFile child : files) {
                if (!paths.contains(child.getPath()) || INVALID_INDEX_DIR.contains(child.getName()) || INVALID_INDEX_ROOT_DIR.contains(child.getName())) continue;
                if (child.isDirectory()) {
                    result.add("\t".repeat(depth) + child.getName() + "/");
                    result.addAll(FileUtils.getPartialWorkspaceStructureRecursive(child, paths, depth + 1));
                    continue;
                }
                result.add("\t".repeat(depth) + child.getName());
            }
        }
        return result;
    }

    public static CompletableFuture<List<VirtualFile>> findRelatedFilesFast(Project project, int maxCount) {
        CompletableFuture<List<VirtualFile>> future = new CompletableFuture<List<VirtualFile>>();
        ThreadManager.getInstance().runUiThread(() -> {
            try {
                if (cacheFileList.size() >= maxCount) {
                    future.complete(cacheFileList.stream().limit(maxCount).collect(Collectors.toList()));
                    return;
                }
                GitIgnoreFileFilter gitIgnoreFileFilter = new GitIgnoreFileFilter("");
                GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
                List allFiles = FilenameIndex.getAllFilesByExt((Project)project, (String)LanguageUtils.getGfSpLanguageSuffix(LanguageUtils.getLanguageByProduct())).stream().filter(virtualFile -> gitIgnoreFileFilter.accept(project, (VirtualFile)virtualFile)).filter(virtualFile -> !virtualFile.isDirectory()).filter(VirtualFile::isValid).collect(Collectors.toList());
                if (allFiles.size() < maxCount) {
                    int newCnt = maxCount - allFiles.size();
                    allFiles.addAll(Arrays.stream(FilenameIndex.getAllFilenames((Project)project)).filter(name -> !FileUtils.findFilesByName(name, scope).isEmpty()).map(name -> FileUtils.findFilesByName(name, scope)).flatMap(Collection::stream).limit((long)maxCount * 10L).filter(virtualFile -> gitIgnoreFileFilter.accept(project, (VirtualFile)virtualFile)).limit(newCnt).collect(Collectors.toList()));
                    allFiles = new ArrayList(allFiles.stream().collect(Collectors.toMap(VirtualFile::getPath, Function.identity(), (existing, replacement) -> existing, LinkedHashMap::new)).values());
                }
                cacheFileList = allFiles;
                future.complete(allFiles.stream().limit(maxCount).collect(Collectors.toList()));
            }
            catch (Exception e) {
                LogManager.warn(FileUtils.class, "findRelatedFilesFast error: " + e.getMessage());
                future.complete(Collections.emptyList());
            }
        });
        return future;
    }

    public static List<VirtualFile> findWorkSpaceFile(Project project, int fileCount) {
        try {
            CompletableFuture<List<VirtualFile>> future = FileUtils.findWorkSpaceFile(project, "", fileCount);
            return future.get();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static CompletableFuture<List<VirtualFile>> findWorkSpaceFile(Project project, String query, int fileCount) {
        CompletableFuture<List<VirtualFile>> future = new CompletableFuture<List<VirtualFile>>();
        String finalQuery = query == null ? "" : query.toLowerCase();
        ThreadManager.getInstance().runUiThread(() -> {
            try {
                GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
                List names = Arrays.stream(FilenameIndex.getAllFilenames((Project)project)).filter(name -> !FileUtils.findFilesByName(name, scope).isEmpty()).filter(name -> name.toLowerCase().contains(finalQuery)).collect(Collectors.toList());
                GitIgnoreFileFilter gitIgnoreFileFilter = new GitIgnoreFileFilter("");
                List<VirtualFile> allFiles = names.stream().map(name -> FileUtils.findFilesByName(name, scope)).flatMap(Collection::stream).filter(file -> gitIgnoreFileFilter.accept(project, (VirtualFile)file)).limit(fileCount).collect(Collectors.toList());
                allFiles.forEach(file -> cacheFileList.add(0, (VirtualFile)file));
                cacheFileList = cacheFileList.stream().limit(100L).collect(Collectors.toList());
                future.complete(allFiles);
            }
            catch (Exception e) {
                future.complete(Collections.emptyList());
                LogManager.warn(FileUtils.class, "findWorkSpaceFile error: " + e.getMessage());
            }
        });
        return future;
    }

    private static List<VirtualFile> findFilesByName(String name, GlobalSearchScope scope) {
        return FilenameIndex.getVirtualFilesByName((String)name, (GlobalSearchScope)scope).stream().filter(virtualFile -> !virtualFile.isDirectory()).collect(Collectors.toList());
    }

    private static void findFilesRecursively(VirtualFile dir, List<Pattern> patterns, List<VirtualFile> result, int maxResult) {
        if (result.size() >= maxResult) {
            return;
        }
        for (VirtualFile file : dir.getChildren()) {
            if (file.isDirectory()) {
                FileUtils.findFilesRecursively(file, patterns, result, maxResult);
                continue;
            }
            String fileName = file.getName();
            if (!patterns.stream().anyMatch(pattern -> pattern.matcher(fileName).matches())) continue;
            result.add(file);
            if (result.size() < maxResult) continue;
            return;
        }
    }

    public static List<VirtualFile> findFilesByPatterns(Project project, List<String> patterns, int maxResult) {
        Set extensions = patterns.stream().map(pattern -> {
            int lastDotIndex = pattern.lastIndexOf(".");
            return lastDotIndex == -1 ? "" : pattern.substring(lastDotIndex + 1);
        }).filter(ext -> !ext.isEmpty()).collect(Collectors.toSet());
        List<Pattern> regexPatterns = patterns.stream().map(pattern -> Pattern.compile(pattern.replace(".", "\\.").replace("*", ".*").replace("?", "."))).collect(Collectors.toList());
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        String basePath = project.getBasePath();
        if (basePath == null) {
            return result;
        }
        VirtualFile baseDir = VirtualFileManager.getInstance().findFileByUrl("file://" + basePath);
        if (baseDir == null) {
            return result;
        }
        try {
            FilenameIndex.class.getMethod("getAllFilesByExt", Project.class, String.class, GlobalSearchScope.class);
        }
        catch (NoSuchMethodException e) {
            FileUtils.findFilesRecursively(baseDir, regexPatterns, result, maxResult * 5);
            return result;
        }
        for (String extension : extensions) {
            FilenameIndex.getAllFilesByExt((Project)project, (String)extension, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)).stream().filter(file -> regexPatterns.stream().anyMatch(pattern -> pattern.matcher(file.getName()).matches())).limit(maxResult).forEach(result::add);
        }
        return result;
    }

    public static String extractFileName(String filePath) {
        int lastSlashIndex = filePath.lastIndexOf(47);
        return lastSlashIndex == -1 ? filePath : filePath.substring(lastSlashIndex + 1);
    }

    public static String extractFileAbsoluteDir(String filePath) {
        Matcher matcher = FileUrlPattern.matcher(filePath);
        if (matcher.find()) {
            String path = matcher.group(1);
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            return path;
        }
        return filePath;
    }

    public static String extractRelativeDir(String baseDir, String filePath) {
        return FileUtils.extractFileAbsoluteDir(filePath).replaceAll(baseDir, "");
    }

    public static Range getRangeByFilePath(String filePath) {
        try {
            String[] range = filePath.substring(filePath.lastIndexOf(":") + 1).split("-");
            return new Range(new Position(Integer.parseInt(range[0]), 0), new Position(Integer.parseInt(range[1]), 0));
        }
        catch (Exception e) {
            LogManager.warn(FileUtils.class, "Error FilePath: " + filePath);
            return null;
        }
    }

    public static String upsetFileRangeName(String fileName) {
        try {
            if (!fileName.contains(":")) {
                return fileName;
            }
            int index = fileName.indexOf(":");
            String[] range = fileName.substring(index + 1).split("-");
            return fileName.substring(0, index + 1) + (Integer.parseInt(range[0]) + 1) + "-" + (Integer.parseInt(range[1]) + 1);
        }
        catch (Exception e) {
            LogManager.warn(FileUtils.class, "Error fileName: " + fileName);
            return null;
        }
    }

    public static boolean checkFilePathHasDriveLetter(String path) {
        return path.matches("^[a-zA-Z]:.*");
    }

    public static String normalizeFilePath(String originFilePath) {
        try {
            String filePath = FileUtils.normalizeFilePathByDecode(originFilePath);
            String fileName = FileUtils.extractFileName(filePath);
            if (fileName.contains(":")) {
                filePath = filePath.substring(0, filePath.lastIndexOf(":"));
            }
            return filePath;
        }
        catch (Exception e) {
            LogManager.warn(FileUtils.class, "Failed to normalize file path: " + originFilePath + " " + String.valueOf(e));
            return originFilePath;
        }
    }

    public static String normalizeFilePathByDecode(String originFilePath) {
        try {
            if (originFilePath == null || originFilePath.isEmpty()) {
                return originFilePath;
            }
            String filePath = originFilePath;
            if (filePath.contains("%")) {
                try {
                    filePath = URLDecoder.decode(filePath, StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    LogManager.warn(FileUtils.class, "Failed to decode file path: " + filePath);
                }
            }
            if ((filePath = filePath.replace('\\', '/')).startsWith(FILE_PATH_PREFIX) || filePath.startsWith(CWM_FILE_PATH_PREFIX)) {
                return filePath;
            }
            if (filePath.startsWith(FILE_PATH_PREFIX.substring(0, FILE_PATH_PREFIX.length() - 1))) {
                filePath = filePath.substring(FILE_PATH_PREFIX.length() - 1);
            }
            if (filePath.startsWith(CWM_FILE_PATH_PREFIX.substring(0, CWM_FILE_PATH_PREFIX.length() - 1))) {
                filePath = filePath.substring(CWM_FILE_PATH_PREFIX.length() - 1);
            }
            if (filePath.startsWith("/")) {
                filePath = filePath.substring(1);
            }
            return PluginUtils.isGatewayClient() ? CWM_FILE_PATH_PREFIX + filePath : FILE_PATH_PREFIX + filePath;
        }
        catch (Exception e) {
            LogManager.warn(FileUtils.class, "Failed to normalize file path: " + originFilePath + " " + String.valueOf(e));
            return originFilePath;
        }
    }

    public static VirtualFile findFileByPath(Project project, String originFilePath) {
        try {
            String path = FileUtils.normalizeFilePath(originFilePath);
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(path);
            if (virtualFile == null) {
                File localFile = URLUtil.urlToFile((URL)new URL(path));
                virtualFile = VirtualFileManager.getInstance().findFileByNioPath(localFile.toPath());
            }
            if (virtualFile == null) {
                path = path.startsWith(FILE_PATH_PREFIX) ? path.replace(FILE_PATH_PREFIX, FILE_PATH_PREFIX + project.getBasePath() + "/") : path.replace(CWM_FILE_PATH_PREFIX, FILE_PATH_PREFIX + project.getBasePath() + "/");
                virtualFile = VirtualFileManager.getInstance().findFileByUrl(path);
            }
            return virtualFile;
        }
        catch (Exception e) {
            LogManager.warn(FileUtils.class, "Can not find file by path: " + originFilePath + " " + e.getMessage());
            return null;
        }
    }

    public static List<VirtualFile> findFilesByWildcard(Project project, String include, final String exclude, Integer maxCount) {
        if (maxCount == null) {
            maxCount = 20;
        }
        if (project == null) {
            return Collections.emptyList();
        }
        final ArrayList<VirtualFile> matchedFiles = new ArrayList<VirtualFile>();
        final VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return matchedFiles;
        }
        final Pattern includePattern = FileUtils.regexFromWildCard(include);
        final Pattern excludePattern = FileUtils.regexFromWildCard(exclude);
        VfsUtilCore.visitChildrenRecursively((VirtualFile)baseDir, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                String relativePath;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)baseDir, (char)'/')) == null) {
                    return false;
                }
                if (!exclude.isEmpty() && FileUtils.shouldExclude(relativePath, excludePattern, file.isDirectory())) {
                    return !file.isDirectory();
                }
                if (file.isDirectory()) {
                    return true;
                }
                if (includePattern.matcher(relativePath).matches()) {
                    matchedFiles.add(file);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/tencent/code/intel/util/FileUtils$1", "visitFile"));
            }
        });
        return matchedFiles;
    }

    private static boolean shouldExclude(String relativePath, Pattern excludePattern, boolean isDirectory) {
        String dirPath;
        boolean result = false;
        if (excludePattern.matcher(relativePath).matches()) {
            result = true;
            LogManager.info(FileUtils.class, "Path excluded (direct match): " + relativePath);
        }
        if (!result && isDirectory && excludePattern.matcher(dirPath = relativePath + "/").matches()) {
            result = true;
            LogManager.info(FileUtils.class, "Directory excluded (with slash): " + relativePath);
        }
        if (!result) {
            String[] pathParts = relativePath.split("/");
            StringBuilder currentPath = new StringBuilder();
            for (int i = 0; i < pathParts.length; ++i) {
                if (i > 0) {
                    currentPath.append("/");
                }
                currentPath.append(pathParts[i]);
                if (excludePattern.matcher(currentPath.toString()).matches()) {
                    result = true;
                    LogManager.info(FileUtils.class, "Path excluded (parent match): " + relativePath + " (matched: " + currentPath.toString() + ")");
                    break;
                }
                String dirPattern = currentPath.toString() + "/";
                if (!excludePattern.matcher(dirPattern).matches()) continue;
                result = true;
                LogManager.info(FileUtils.class, "Path excluded (parent dir match): " + relativePath + " (matched: " + dirPattern + ")");
                break;
            }
        }
        return result;
    }

    private static Pattern regexFromWildCard(String wildcard) {
        if (wildcard == null || wildcard.isEmpty()) {
            return Pattern.compile("$^");
        }
        if (wildcard.contains("{") && wildcard.contains("}")) {
            Object pattern = wildcard;
            pattern = ((String)pattern).replace("\\", "/");
            pattern = ((String)pattern).replace(".", "\\.");
            pattern = ((String)pattern).replaceAll("\\{([^}]+)\\}", "(?:$1)");
            pattern = ((String)pattern).replace(",", "|");
            pattern = ((String)pattern).replace("**/", "(?:.*[/])?");
            pattern = ((String)pattern).replace("/**", "(?:[/].*)?");
            pattern = ((String)pattern).replace("**", ".*");
            if (!((String)(pattern = ((String)pattern).replace("*", "[^/]*"))).startsWith("^")) {
                pattern = "^" + (String)pattern;
            }
            if (!((String)pattern).endsWith("$")) {
                pattern = (String)pattern + "$";
            }
            return Pattern.compile((String)pattern);
        }
        String antPattern = FileUtil.toSystemIndependentName((String)wildcard);
        String regex = FileUtil.convertAntToRegexp((String)antPattern);
        return Pattern.compile(regex);
    }

    public static List<VirtualFile> findFilesByPath(Project project, List<String> filePaths) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (String filePath : filePaths) {
            VirtualFile file = FileUtils.findFileByPath(project, filePath);
            if (file == null) continue;
            result.add(file);
        }
        return result;
    }

    public static String readFileContent(VirtualFile file) {
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return "";
        }
        return document.getText();
    }

    public static String getFileNameFromFileUri(String fileUri) {
        if (fileUri == null) {
            return "";
        }
        String fileName = "";
        try {
            String fileNameWithRange = FileUtils.extractFileName(FileUtils.normalizeFilePath(fileUri));
            int rangeIndex = fileNameWithRange.lastIndexOf(58);
            fileName = rangeIndex != -1 ? fileNameWithRange.substring(0, rangeIndex) : fileNameWithRange;
        }
        catch (Exception e) {
            LogManager.error(FileUtils.class, "Can not find file by uri: " + fileUri);
        }
        return fileName;
    }

    public static VirtualFile createNewFile(String filePath) {
        try {
            if (filePath.startsWith("file://")) {
                filePath = filePath.substring("file://".length());
            } else if (filePath.startsWith("cwm://")) {
                filePath = filePath.substring("cwm://".length());
            }
            File file = new File(filePath);
            if (file.exists()) {
                return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            }
            File parentDir = file.getParentFile();
            if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                LogManager.warn(FileUtils.class, "Failed to create parent directories for: " + filePath);
                return null;
            }
            if (!file.createNewFile()) {
                LogManager.warn(FileUtils.class, "Failed to create new file: " + filePath);
                return null;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            if (virtualFile == null) {
                LogManager.warn(FileUtils.class, "Failed to find virtual file after creation: " + filePath);
                return null;
            }
            return virtualFile;
        }
        catch (IOException e) {
            LogManager.warn(FileUtils.class, "Error creating new file: " + filePath + ", error: " + e.getMessage());
            return null;
        }
    }

    public static int getLineCount(String content) {
        if (content == null || content.isEmpty()) {
            return 0;
        }
        String normalizedContent = content.replace("\r\n", "\n");
        return (int)normalizedContent.chars().filter(ch -> ch == 10).count();
    }

    public static boolean deleteFile(Project project, String filePath) {
        try {
            if (project == null || project.isDisposed()) {
                LogManager.warn(FileUtils.class, "Delete file error, project null or disposed");
                return false;
            }
            VirtualFile virtualFile = FileUtils.findFileByPath(project, filePath);
            if (virtualFile == null) {
                LogManager.warn(FileUtils.class, "File not found: " + filePath);
                return false;
            }
            ApplicationManager.getApplication().invokeAndWait(() -> {
                try {
                    FileEditorManager.getInstance((Project)project).closeFile(virtualFile);
                }
                catch (Exception e) {
                    LogManager.warn(FileUtils.class, "Failed to close file before deleting: " + filePath + ", error: " + String.valueOf(e));
                }
            });
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    if (virtualFile.exists()) {
                        virtualFile.delete(FileUtils.class);
                    }
                }
                catch (IOException e) {
                    LogManager.warn(FileUtils.class, "Failed to delete file: " + filePath + ", error: " + String.valueOf(e));
                }
            });
            return true;
        }
        catch (Exception e) {
            LogManager.warn(FileUtils.class, "Error deleting file: " + filePath + ", error: " + String.valueOf(e));
            return false;
        }
    }

    public static boolean deleteFileByPath(Project project, String filePath) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (virtualFile == null) {
            return true;
        }
        try {
            return (Boolean)ApplicationManager.getApplication().runWriteAction(() -> {
                virtualFile.delete((Object)project);
                return true;
            });
        }
        catch (IOException e) {
            LogManager.error(FileUtils.class, "Failed to delete file: " + String.valueOf(e));
            return false;
        }
    }

    public static void openFile(Project project, String uri, Position start, Position end) {
        VirtualFile vf = FileUtils.findFileByPath(project, uri);
        if (vf != null) {
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, vf, start.getLine());
            ThreadManager.getInstance().runUiThread(() -> {
                try {
                    Editor editor = manager.openTextEditor(descriptor, true);
                    editor.getCaretModel().moveToOffset(editor.getDocument().getLineStartOffset(start.getLine()));
                    editor.getScrollingModel().scrollToCaret(ScrollType.CENTER_UP);
                }
                catch (Exception e) {
                    LogManager.error(FileUtils.class, "Failed to open file: " + uri + ", error: " + String.valueOf(e));
                }
            });
        }
    }

    public static Editor getEditor(Project project, String uri) {
        FileEditor textEditor;
        VirtualFile file = FileUtils.findFileByPath(project, uri);
        if (file != null && (textEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file)) instanceof TextEditor) {
            return ((TextEditor)textEditor).getEditor();
        }
        return null;
    }

    public static FileType getFileTypeByName(String name) {
        return FileTypeManager.getInstance().getFileTypeByFileName(name);
    }
}

