/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import com.tencent.code.intel.manager.LogManager;
import java.awt.Component;
import java.awt.Point;
import java.util.Arrays;
import javax.swing.JComponent;

public class HintUtils {
    public static void createAndShowHint(Point point, JComponent pointComponent, JComponent showComponent) {
        try {
            double popHeight = showComponent.getPreferredSize().getHeight();
            Point newPoint = new Point();
            newPoint.setLocation(point.x, (double)point.y >= popHeight ? (int)((double)point.y - popHeight) : 0);
            RelativePoint relativePoint = new RelativePoint((Component)pointComponent, newPoint);
            HintManagerImpl.getInstance().showHint(showComponent, relativePoint, 144, 0);
        }
        catch (Throwable e) {
            LogManager.info(HintUtils.class, "createAndShowHint-" + e.toString());
        }
    }

    public static void createAndShowCRHint(Point point, JComponent pointComponent, JComponent showComponent) {
        try {
            double popHeight = showComponent.getPreferredSize().getHeight();
            Point newPoint = new Point();
            newPoint.setLocation(point.x, (double)point.y >= popHeight ? (int)((double)point.y - popHeight) : 0);
            RelativePoint relativePoint = new RelativePoint((Component)pointComponent, newPoint);
            showComponent.setFocusable(false);
            showComponent.setRequestFocusEnabled(false);
            HintManagerImpl.getInstance().showHint(showComponent, relativePoint, 58, 0);
        }
        catch (Throwable e) {
            LogManager.info(HintUtils.class, "createAndShowHint-" + e.toString());
        }
    }

    public static void createAndShowEditorHint(Editor editor, Point point, JComponent showComponent) {
        try {
            double popHeight = showComponent.getPreferredSize().getHeight();
            Point newPoint = new Point();
            newPoint.setLocation(point.x, (double)point.y >= popHeight ? (int)((double)point.y - popHeight) : 0);
            LightweightHint lightweightHint = new LightweightHint(showComponent);
            HintManagerImpl.getInstanceImpl().showEditorHint(lightweightHint, editor, point, 130, 0, false);
        }
        catch (Throwable e) {
            LogManager.info(HintUtils.class, "createAndShowEditorHint-" + e.toString());
        }
    }

    public static void hideHint() {
        try {
            HintManagerImpl.getInstanceImpl().hideAllHints();
            HintManagerImpl.getInstanceImpl().cleanup();
        }
        catch (Exception e) {
            LogManager.info(HintUtils.class, "hideHint:" + e.toString());
        }
    }

    public boolean isFileSelected(Project project, VirtualFile file) {
        VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        return Arrays.asList(selectedFiles).contains(file);
    }
}

