/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.SimplePropertyPreFilter;
import com.intellij.openapi.application.ApplicationInfo;
import com.tencent.code.intel.apibridge.rpcprotocol.RpcProtocolDataReader;
import com.tencent.code.intel.callback.ObjectRunnable;
import com.tencent.code.intel.manager.LogManager;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.util.TextUtils;

public class JsonRpcUtils {
    private static final AtomicLong onlyId = new AtomicLong(1L);
    private static final String HEADER = "Content-Length: %d\r\n\r\n";
    private static final String DEVECO_STUDIO = "DevEco Studio";

    public static <T> T toJavaObject(Object data, Class<T> classType) {
        return (T)JsonRpcUtils.parseJsonWithClassLoader(classType, () -> JSON.to((Class)classType, (Object)data));
    }

    public static String toJSONString(Object object, Filter filter) {
        return JsonRpcUtils.parseJsonWithClassLoader(String.class, () -> JSON.toJSONString((Object)object, (Filter)filter, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.LargeObject}));
    }

    public static String toJSONString(Object object) {
        return JsonRpcUtils.parseJsonWithClassLoader(String.class, () -> JSON.toJSONString((Object)object, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.LargeObject}));
    }

    public static <T> T parseObject(String data, Class<T> classType) {
        return (T)JsonRpcUtils.parseJsonWithClassLoader(classType, () -> JSON.parseObject((String)data, (Class)classType));
    }

    public static <T> T parseObject(byte[] data, Class<T> classType) {
        return (T)JsonRpcUtils.parseJsonWithClassLoader(classType, () -> JSON.parseObject((byte[])data, (Class)classType));
    }

    public static JSONArray parseArray(String text) {
        return JsonRpcUtils.parseJsonWithClassLoader(JSONArray.class, () -> JSON.parseArray((String)text));
    }

    public static <T> T parseObject(String text, TypeReference<T> typeReference, JSONReader.Feature ... features) {
        return (T)JsonRpcUtils.parseJsonWithClassLoader(typeReference.getClass(), () -> JSON.parseObject((String)text, (TypeReference)typeReference, (JSONReader.Feature[])features));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T parseJsonWithClassLoader(Class<?> classType, ObjectRunnable<T> runnable) {
        try {
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            if (appInfo == null) {
                return runnable.run();
            }
            String ideName = appInfo.getVersionName();
            if (TextUtils.isEmpty((CharSequence)ideName)) return runnable.run();
            if (!ideName.contains(DEVECO_STUDIO)) {
                return runnable.run();
            }
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classType.getClassLoader());
                T t = runnable.run();
                return t;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        catch (NullPointerException e) {
            return runnable.run();
        }
    }

    public static byte[] encode(Object request, SimplePropertyPreFilter filter) {
        String json = "";
        json = filter == null ? JsonRpcUtils.toJSONString(request) : JsonRpcUtils.toJSONString(request, (Filter)filter);
        String header = String.format(HEADER, json.getBytes(StandardCharsets.UTF_8).length);
        String data = header + json;
        return data.getBytes(StandardCharsets.UTF_8);
    }

    public static String decodeUri(String message) {
        String uri = "";
        try {
            Pattern pattern = Pattern.compile("(Document \\[([\\s\\S]+)\\] is not opened yet.)", 32);
            Matcher matcher = pattern.matcher(message);
            if (matcher.find()) {
                uri = matcher.group(2);
            }
        }
        catch (Exception e) {
            LogManager.warn(JsonRpcUtils.class, e.toString());
        }
        return uri;
    }

    public static Long getUniqueId() {
        return onlyId.getAndIncrement();
    }

    public static String unescapeJson(String escapedJson) {
        if (TextUtils.isEmpty((CharSequence)escapedJson)) {
            return null;
        }
        return escapedJson.replace("&quot;", "\"").replace("&amp;", "&").replace("&lt;", "<").replace("&gt;", ">").replace("&apos;", "'");
    }

    static {
        try {
            RpcProtocolDataReader.register();
            LogManager.info(JsonRpcUtils.class, "RpcProtocolDataReader registered successfully");
        }
        catch (Exception e) {
            LogManager.warn(JsonRpcUtils.class, "Failed to register RpcProtocolDataReader: " + e.toString());
        }
    }
}

