/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.tencent.code.intel.manager.LogManager;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.http.util.TextUtils;

public class LanguageUtils {
    public static String getGfSpLanguageSuffix(String language) {
        String result = "";
        if (!TextUtils.isEmpty((CharSequence)language)) {
            for (GF_SP_LANGUAGE_SUFFIX value : GF_SP_LANGUAGE_SUFFIX.values()) {
                if (!value.getGfSpLanguages().getLangId().equalsIgnoreCase(language)) continue;
                result = value.getLangSuffix();
                break;
            }
        }
        return result;
    }

    public static String getGfSpLanguageIdBySuffix(String suffix, String defaultLanguage) {
        String result = defaultLanguage;
        if (!TextUtils.isEmpty((CharSequence)suffix)) {
            for (GF_SP_LANGUAGE_SUFFIX value : GF_SP_LANGUAGE_SUFFIX.values()) {
                if (!value.getLangSuffix().equals(suffix)) continue;
                result = value.getGfSpLanguages().getLangId();
                break;
            }
        }
        return result;
    }

    public static boolean isGfSpLanguage(PsiFile file) {
        String languageId;
        boolean result = false;
        if (file != null && !(result = LanguageUtils.isGfSpLanguageId(languageId = file.getLanguage().getID())) && (GF_IN_LANGUAGES.TEXT.langId.equalsIgnoreCase(languageId) || GF_IN_LANGUAGES.TEXTMATE.langId.equalsIgnoreCase(languageId))) {
            if (file.getVirtualFile() != null) {
                String extension = file.getVirtualFile().getExtension();
                for (GF_SP_LANGUAGE_SUFFIX value : GF_SP_LANGUAGE_SUFFIX.values()) {
                    if (!value.getLangSuffix().equalsIgnoreCase(extension)) continue;
                    result = true;
                    break;
                }
            } else {
                LogManager.warn(LanguageUtils.class, "isGfSpLanguage false for getVirtualFile is null");
            }
        }
        return result;
    }

    public static boolean isGfSpLanguageId(String languageId) {
        boolean result = false;
        if (!TextUtils.isEmpty((CharSequence)languageId)) {
            result = true;
            for (GF_IN_LANGUAGES value : GF_IN_LANGUAGES.values()) {
                if (!value.getLangId().equalsIgnoreCase(languageId)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static String getLanguageId(Editor editor) {
        String languageId = "";
        try {
            if (editor.getProject() == null || editor.getProject().isDisposed()) {
                return languageId;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument());
            if (psiFile != null) {
                languageId = psiFile.getLanguage().getID();
            }
        }
        catch (Exception e) {
            LogManager.error(LanguageUtils.class, "getLanguageId editor is null:" + e.toString());
        }
        return languageId;
    }

    public static String getLanguageId(Project project, VirtualFile file) {
        String languageId = "";
        if (project == null || project.isDisposed()) {
            return languageId;
        }
        try {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile != null) {
                languageId = psiFile.getLanguage().getID();
            }
        }
        catch (Exception e) {
            LogManager.error(LanguageUtils.class, "getLanguageId failed, e:" + e.toString());
        }
        return languageId;
    }

    public static String getLanguageIdWithSuffix(Editor editor) {
        PsiFile psiFile;
        String languageId = LanguageUtils.getLanguageId(editor);
        if ((GF_IN_LANGUAGES.TEXT.langId.equalsIgnoreCase(languageId) || GF_IN_LANGUAGES.TEXTMATE.langId.equalsIgnoreCase(languageId)) && (psiFile = PsiDocumentManager.getInstance((Project)Objects.requireNonNull(editor.getProject())).getPsiFile(editor.getDocument())) != null && psiFile.getVirtualFile() != null) {
            String extension = psiFile.getVirtualFile().getExtension();
            languageId = LanguageUtils.getGfSpLanguageIdBySuffix(extension, languageId);
        }
        return languageId;
    }

    public static String getLanguageByProduct() {
        Map<String, String> productLanguageMap = Map.of("IDEA", "Java", "WebStorm", "javascript", "PyCharm", "python", "Clion", "C++", "GoLand", "Golang");
        String productName = ApplicationNamesInfo.getInstance().getProductName();
        return productLanguageMap.getOrDefault(productName, "Java");
    }

    public static FileType getFileTypeByLanguage(String language) {
        FileType defaultType = UnknownFileType.INSTANCE;
        if (TextUtils.isBlank((CharSequence)language)) {
            return defaultType;
        }
        Language foundLanguage = null;
        Locale locale = Locale.getDefault();
        for (Language lang : LanguageUtil.getFileLanguages()) {
            if (!lang.getDisplayName().toLowerCase(locale).equals(language.toLowerCase(locale))) continue;
            foundLanguage = lang;
        }
        if (foundLanguage != null) {
            LanguageFileType associatedFileType = foundLanguage.getAssociatedFileType();
            return associatedFileType != null ? associatedFileType : defaultType;
        }
        return FileTypeManager.getInstance().getFileTypeByExtension(language);
    }

    public static enum GF_SP_LANGUAGE_SUFFIX {
        PYTHON("py", GF_SP_LANGUAGES.PYTHON),
        GO("go", GF_SP_LANGUAGES.GO),
        JAVA("java", GF_SP_LANGUAGES.JAVA),
        C("c", GF_SP_LANGUAGES.C),
        C_H("h", GF_SP_LANGUAGES.C),
        CPP("cpp", GF_SP_LANGUAGES.CPP),
        CPP_HPP("hpp", GF_SP_LANGUAGES.CPP),
        CPP_HXX("hxx", GF_SP_LANGUAGES.CPP),
        CPP_CC("cc", GF_SP_LANGUAGES.CPP),
        CPP_CXX("cxx", GF_SP_LANGUAGES.CPP),
        CPP_C_P("C", GF_SP_LANGUAGES.CPP),
        CPP_C_A_A("c++", GF_SP_LANGUAGES.CPP),
        CPP_CP("cp", GF_SP_LANGUAGES.CPP),
        CSHARP("cs", GF_SP_LANGUAGES.CSHARP),
        LUA("lua", GF_SP_LANGUAGES.LUA),
        JAVASCRIPT("js", GF_SP_LANGUAGES.JAVASCRIPT),
        JAVASCRIPT_JSX("jsx", GF_SP_LANGUAGES.JAVASCRIPT_JSX),
        VUE("vue", GF_SP_LANGUAGES.VUE),
        TYPESCRIPT("ts", GF_SP_LANGUAGES.TYPESCRIPT),
        TYPESCRIPT_JSX("tsx", GF_SP_LANGUAGES.TYPESCRIPT_JSX),
        KOTLIN("kt", GF_SP_LANGUAGES.KOTLIN),
        PHP("php", GF_SP_LANGUAGES.PHP),
        SWIFT("swift", GF_SP_LANGUAGES.SWIFT),
        RUST("rs", GF_SP_LANGUAGES.RUST),
        DART("dart", GF_SP_LANGUAGES.DART),
        POWERSHELL_1("ps1", GF_SP_LANGUAGES.POWER_SHELL),
        POWERSHELL_M("psm", GF_SP_LANGUAGES.POWER_SHELL),
        BAT("bat", GF_SP_LANGUAGES.BAT),
        BAT_CMD("cmd", GF_SP_LANGUAGES.BAT),
        SHELL("sh", GF_SP_LANGUAGES.SHELL_SCRIPT),
        SHELL_BASHRC("bashrc", GF_SP_LANGUAGES.SHELL_SCRIPT),
        SHELL_PROFILE("profile", GF_SP_LANGUAGES.SHELL_SCRIPT),
        SHELL_BASH_PROFILE("bash_profile", GF_SP_LANGUAGES.SHELL_SCRIPT),
        SHELL_B("bash", GF_SP_LANGUAGES.SHELL_SCRIPT),
        SHELL_Z("zsh", GF_SP_LANGUAGES.SHELL_SCRIPT),
        SHELL_C("csh", GF_SP_LANGUAGES.SHELL_SCRIPT),
        SHELL_TC("tcsh", GF_SP_LANGUAGES.SHELL_SCRIPT),
        SHELL_SC("shrc", GF_SP_LANGUAGES.SHELL_SCRIPT),
        SHELL_K("ksh", GF_SP_LANGUAGES.SHELL_SCRIPT),
        SHELL_F("fish", GF_SP_LANGUAGES.SHELL_SCRIPT),
        CSS("css", GF_SP_LANGUAGES.CSS),
        SCALA("scala", GF_SP_LANGUAGES.SCALA),
        RUBY("rb", GF_SP_LANGUAGES.RUBY),
        SQL("sql", GF_SP_LANGUAGES.SQL),
        SOL("sol", GF_SP_LANGUAGES.SOL),
        HASKELL("hs", GF_SP_LANGUAGES.HASKELL),
        OBJECT_C_M("m", GF_SP_LANGUAGES.OBJECT_C),
        OBJECT_C_MM("mm", GF_SP_LANGUAGES.OBJECT_C),
        VISUAL_BASIC("vb", GF_SP_LANGUAGES.VISUAL_BASIC),
        JULIA("jl", GF_SP_LANGUAGES.JULIA),
        R("R", GF_SP_LANGUAGES.R),
        TEX("tex", GF_SP_LANGUAGES.TEX),
        COMPONENT_PROTO("proto", GF_SP_LANGUAGES.COMPONENT_PROTO);

        private String langSuffix;
        private GF_SP_LANGUAGES gfSpLanguages;

        private GF_SP_LANGUAGE_SUFFIX(String langSuffix, GF_SP_LANGUAGES gfSpLanguages) {
            this.langSuffix = langSuffix;
            this.gfSpLanguages = gfSpLanguages;
        }

        public String getLangSuffix() {
            return this.langSuffix;
        }

        public GF_SP_LANGUAGES getGfSpLanguages() {
            return this.gfSpLanguages;
        }
    }

    public static enum GF_SP_LANGUAGES {
        PYTHON("python"),
        GO("go"),
        JAVA("java"),
        C("c"),
        CPP("cpp"),
        CSHARP("csharp"),
        LUA("lua"),
        JAVASCRIPT("javascript"),
        TYPESCRIPT("typescript"),
        KOTLIN("kotlin"),
        PHP("php"),
        JAVASCRIPT_JSX("javascriptreact"),
        TYPESCRIPT_JSX("typescriptreact"),
        VUE("vue"),
        SWIFT("swift"),
        RUST("rust"),
        DART("dart"),
        POWER_SHELL("powershell"),
        SHELL_SCRIPT("shellscript"),
        BAT("bat"),
        CSS("css"),
        SCALA("scala"),
        RUBY("ruby"),
        SQL("sql"),
        SOL("sol"),
        HASKELL("haskell"),
        VISUAL_BASIC("vb"),
        JULIA("julia"),
        OBJECT_C("objective-c"),
        R("r"),
        TEX("tex"),
        COMPONENT_PROTO("proto");

        private String langId;

        private GF_SP_LANGUAGES(String langId) {
            this.langId = langId;
        }

        public String getLangId() {
            return this.langId;
        }
    }

    public static enum GF_IN_LANGUAGES {
        MARKDOWN("markdown"),
        LOG("log"),
        GIT_COMMIT("git-commit"),
        GIT_REBASE("git-rebase"),
        DIFF("diff"),
        TEXTMATE("textmate"),
        TEXT("text"),
        PLAINTEXT("plaintext");

        private String langId;

        private GF_IN_LANGUAGES(String langId) {
            this.langId = langId;
        }

        public String getLangId() {
            return this.langId;
        }
    }
}

