/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.tencent.code.intel.manager.LogManager;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LineNumberUtils {
    public static String trimLineNumbers(String input) {
        return LineNumberUtils.trimLineNumbers(input, false);
    }

    public static String trimLineNumbers(String input, boolean lineNumberNeedContinuous) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        try {
            String[] lines = input.split("\n");
            if (lines.length == 0) {
                return input;
            }
            LineNumberStrategy strategy = LineNumberUtils.detectLineNumberStrategy(lines);
            if (strategy == null) {
                return input;
            }
            ArrayList<String> processedLines = new ArrayList<String>();
            String[] split = lines[0].trim().split("[ .\t]");
            if (split.length == 0) {
                return input;
            }
            String baseLineNumberStr = String.valueOf(split[0]);
            int expectedLineNumber = Integer.parseInt(baseLineNumberStr);
            for (String line : lines) {
                String processedLine = strategy.processLine(line, expectedLineNumber, baseLineNumberStr, lineNumberNeedContinuous);
                processedLines.add(processedLine);
                ++expectedLineNumber;
            }
            return String.join((CharSequence)"\n", processedLines);
        }
        catch (Exception e) {
            LogManager.info(LineNumberUtils.class, "Replace line numbers with spaces failed." + input + e.getMessage());
            return input;
        }
    }

    public static String stripLeadingSpaces(String line) {
        int index;
        for (index = 0; index < line.length() && line.charAt(index) == ' '; ++index) {
        }
        return line.substring(index);
    }

    private static LineNumberStrategy detectLineNumberStrategy(String[] lines) {
        LineNumberStrategy[] strategies = new LineNumberStrategy[]{new GeneralLineNumberStrategy()};
        try {
            for (LineNumberStrategy strategy : strategies) {
                int noMatchCount = 0;
                int threshold = lines.length / 2;
                for (String line : lines) {
                    if (!strategy.matches(line)) {
                        ++noMatchCount;
                    }
                    if (noMatchCount > threshold) break;
                }
                if (lines.length - noMatchCount <= threshold) continue;
                return strategy;
            }
        }
        catch (Exception e) {
            LogManager.info(LineNumberUtils.class, "Detect line number strategy failed.");
            return null;
        }
        return null;
    }

    private static class GeneralLineNumberStrategy
    extends BaseLineNumberStrategy {
        public GeneralLineNumberStrategy() {
            super("^\\s*(\\d+)([\\s\\t\\.]?)");
        }
    }

    private static abstract class BaseLineNumberStrategy
    implements LineNumberStrategy {
        private final Pattern pattern;

        protected BaseLineNumberStrategy(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean matches(String line) {
            return this.pattern.matcher(line).find();
        }

        @Override
        public String processLine(String line, int expectedLineNumber, String baseLineNumberStr, boolean lineNumberNeedContinuous) throws Exception {
            Matcher matcher = this.pattern.matcher(line);
            if (matcher.find()) {
                if (lineNumberNeedContinuous && Integer.parseInt(matcher.group(1)) != expectedLineNumber) {
                    throw new Exception("Line numbers are not continuous.");
                }
                int lineNumberLength = matcher.end();
                Object trimmedLine = line.substring(lineNumberLength);
                int extraDigits = matcher.group(1).length() - baseLineNumberStr.length();
                if (extraDigits > 0) {
                    trimmedLine = " ".repeat(extraDigits) + (String)trimmedLine;
                }
                return trimmedLine;
            }
            return line;
        }
    }

    private static interface LineNumberStrategy {
        public boolean matches(String var1);

        public String processLine(String var1, int var2, String var3, boolean var4) throws Exception;
    }
}

