/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.intellij.ide.DataManager;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.util.ui.UIUtil;
import com.tencent.code.intel.common.PluginInfo;
import com.tencent.code.intel.impl.CopilotSettingsService;
import com.tencent.code.intel.impl.InlayService;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.manager.LogManager;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginUtils {
    private static final String UNKNOWN_VERSION = "unknown";
    private static final String LOWER_SUFFIX = "-saas-lower";
    private static final String SAAS_PLUGIN_ID = "com.tencent.cloud.codingcopilot";
    public static final PluginId COPILOT_ID = PluginId.getId((String)PluginInfo.PLUGIN_ID);

    public static boolean isCodeIndexEnable() {
        return !PluginUtils.isGatewayClient();
    }

    public static void openIDE() {
        if (PluginUtils.isMac() && !PluginUtils.isDebug()) {
            String ideName = ApplicationInfo.getInstance().getVersionName();
            if (PluginUtils.isGatewayClient() || PluginUtils.isGatewayHost()) {
                ideName = PluginUtils.getGatewayName();
            }
            try {
                ProcessBuilder pb = new ProcessBuilder("/usr/bin/open", "-a", ideName);
                pb.start();
            }
            catch (IOException e) {
                LogManager.warn(PluginUtils.class, "openIDE:" + e.toString());
            }
        }
    }

    public static boolean canShowFullLineNotification() {
        int version = PluginUtils.getBuildVersion();
        boolean isFullLineVersion = version >= 241 && version <= 242;
        boolean isShow = CopilotSettingsService.getInstance().isShowFullLineNotification();
        String ideName = ApplicationInfo.getInstance().getVersionName();
        boolean isIdeSupport = !TextUtils.isEmpty((CharSequence)ideName) && !ideName.contains("JetBrains Rider");
        return isFullLineVersion && isShow && isIdeSupport;
    }

    public static boolean isSupportedIDE(@Nullable Project project) {
        if (PluginUtils.isRemoteIDE()) {
            return true;
        }
        return !LightEdit.owns((Project)project);
    }

    public static boolean isRemoteIDE() {
        return "true".equals(System.getProperty("org.jetbrains.projector.server.enable"));
    }

    public static int compareVersion(String version1, String version2) {
        int result = 0;
        try {
            String[] arr1 = version1.split("\\.");
            String[] arr2 = version2.split("\\.");
            int len = Math.max(arr1.length, arr2.length);
            for (int i = 0; i < len; ++i) {
                int num2;
                int num1 = i < arr1.length ? Integer.parseInt(arr1[i]) : 0;
                int n = num2 = i < arr2.length ? Integer.parseInt(arr2[i]) : 0;
                if (num1 == num2) continue;
                return num1 > num2 ? 1 : -1;
            }
        }
        catch (Exception e) {
            LogManager.warn(PluginUtils.class, "compareVersion:" + e.toString());
            result = -2;
        }
        return result;
    }

    public static ContentFactory getContentFactory() {
        try {
            Class<?> contentFactoryClass = PluginUtils.getBuildVersion() < 222 ? Class.forName("com.intellij.ui.content.ContentFactory$SERVICE") : Class.forName("com.intellij.ui.content.ContentFactory");
            Method instanceMethod = contentFactoryClass.getMethod("getInstance", new Class[0]);
            return (ContentFactory)instanceMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isDebug() {
        String ideaPluginsPath = System.getProperty("idea.plugins.path");
        return ideaPluginsPath != null && ideaPluginsPath.contains("idea-sandbox") && ideaPluginsPath.contains("genie");
    }

    public static boolean isDarkTheme() {
        return UIUtil.isUnderDarcula();
    }

    public static boolean isMac() {
        return SystemInfoRt.isMac;
    }

    public static boolean isWindows() {
        return SystemInfoRt.isWindows;
    }

    public static boolean isGatewayHost() {
        String sunJavaCommand = System.getProperty("sun.java.command");
        return !TextUtils.isEmpty((CharSequence)sunJavaCommand) && sunJavaCommand.contains("Host");
    }

    public static boolean isGatewayClient() {
        String platformPrefix = System.getProperty("idea.platform.prefix");
        return !TextUtils.isEmpty((CharSequence)platformPrefix) && platformPrefix.equals("JetBrainsClient");
    }

    public static String getGatewayName() {
        String gatewayName = System.getProperty("idea.gateway.name");
        if (!TextUtils.isBlank((CharSequence)gatewayName)) {
            return gatewayName;
        }
        return "Jetbrains Gateway";
    }

    public static boolean isJCEEEnable() {
        return JBCefApp.isSupported();
    }

    public static int getBuildVersion() {
        try {
            return ApplicationInfo.getInstance().getBuild().getBaselineVersion();
        }
        catch (Exception e) {
            LogManager.warn(PluginUtils.class, "getBuildVersion error:" + e.getMessage());
            return 0;
        }
    }

    public static String version() {
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)COPILOT_ID);
        return plugin != null ? plugin.getVersion() : UNKNOWN_VERSION;
    }

    public static String getPluginVersion() {
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)COPILOT_ID);
        if (plugin == null) {
            return UNKNOWN_VERSION;
        }
        Object version = plugin.getVersion();
        try {
            if (plugin.getPluginId().equals((Object)SAAS_PLUGIN_ID) && plugin.getSinceBuild() != null && PluginUtils.compareVersion(plugin.getSinceBuild(), "211") < 0) {
                version = (String)version + LOWER_SUFFIX;
            }
        }
        catch (Exception e) {
            LogManager.warn(PluginUtils.class, "version parse error:" + e.getMessage());
        }
        return version;
    }

    public static Path path() {
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)COPILOT_ID);
        return plugin != null ? plugin.getPluginPath() : null;
    }

    public static boolean isPycharm() {
        String product = ApplicationInfo.getInstance().getBuild().getProductCode();
        return product.equals("PY");
    }

    public static boolean isGoLand() {
        return "GO".equals(ApplicationInfo.getInstance().getBuild().getProductCode());
    }

    public static boolean isGFCopilotPlugin(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            PluginUtils.$$$reportNull$$$0(0);
        }
        return pluginDescriptor.getPluginId().equals((Object)COPILOT_ID);
    }

    public static boolean isPluginAvailable() {
        if (InlayService.getInstance() == null) {
            return false;
        }
        if (CopilotSettingsService.getInstance() == null) {
            return false;
        }
        return !PluginUtils.isGatewayHost();
    }

    public static String getPluginServerError() {
        String os = SystemInfo.OS_NAME.toLowerCase(Locale.ROOT);
        String arch = SystemInfo.OS_ARCH.toLowerCase(Locale.ROOT);
        return LocaleManager.get("lsp_start_error", "(" + os + "/" + arch + ")");
    }

    public static boolean actionPerformed(String actionId) {
        try {
            ActionManager actionManager = ActionManager.getInstance();
            AnAction myAction = actionManager.getAction(actionId);
            AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)myAction, null, (String)"", (DataContext)DataManager.getInstance().getDataContext());
            myAction.actionPerformed(event);
            return true;
        }
        catch (Exception e) {
            LogManager.warn(PluginUtils.class, "actionPerformed error:" + e.toString());
            return false;
        }
    }

    public static String getAllSamePlugins() {
        String somePluginIds = "com.intellij.ml.llm,com.github.copilot,com.alibabacloud.intellij.cosy,com.tabnine.TabNine,com.nnthink.aixcoder,com.codota.csp.intellij,com.codeium.intellij,ai.swiq,app.aicommit.plugin,com.diffblue.intellij.cover.plugin,co.bito.bito-intellij,com.marscode,com.baidu.comate,com.smallcloud.codify,ai.codegeex.plugin";
        ArrayList somePluginIdList = new ArrayList();
        somePluginIdList.addAll(Arrays.stream(somePluginIds.split(",")).map(String::toLowerCase).collect(Collectors.toList()));
        ArrayList<String> samePluginIds = new ArrayList<String>();
        for (IdeaPluginDescriptor plugin : PluginManager.getLoadedPlugins()) {
            if (!plugin.isEnabled() || !somePluginIdList.contains(plugin.getPluginId().toString())) continue;
            samePluginIds.add(plugin.getPluginId().toString());
        }
        return String.join((CharSequence)",", samePluginIds);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/tencent/code/intel/util/PluginUtils", "isGFCopilotPlugin"));
    }
}

