/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.sun.management.OperatingSystemMXBean;
import com.tencent.code.intel.manager.LogManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.apache.commons.lang.StringUtils;
import org.apache.http.util.TextUtils;

public class ProcessUtils {
    public static byte[] readStdin(Process process) throws IOException {
        if (process == null) {
            return null;
        }
        InputStream inputStream = process.getInputStream();
        byte[] data = new byte[inputStream.available()];
        inputStream.read(data);
        return data;
    }

    public static byte[] readStderr(Process process) throws IOException {
        if (process == null) {
            return null;
        }
        InputStream inputStream = process.getErrorStream();
        byte[] data = new byte[inputStream.available()];
        inputStream.read(data);
        return data;
    }

    public static void write(Process process, byte[] data) throws IOException {
        if (process == null) {
            return;
        }
        OutputStream outputStream = process.getOutputStream();
        outputStream.write(data);
        outputStream.flush();
    }

    public static String execute(String dir, long timeoutMillis, String ... cmd) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        Process process = processBuilder.directory(new File(dir)).command(cmd).redirectErrorStream(true).start();
        process.waitFor(timeoutMillis, TimeUnit.MILLISECONDS);
        String msg = new String(ProcessUtils.readStdin(process));
        process.destroy();
        return msg;
    }

    public static String executeChmod(String path) {
        String command = "chmod +x " + path;
        try {
            Process process = Runtime.getRuntime().exec(command);
            process.waitFor(5000L, TimeUnit.MILLISECONDS);
            String msg = new String(ProcessUtils.readStdin(process));
            process.destroy();
            return msg;
        }
        catch (Exception e) {
            LogManager.warn(ProcessUtils.class, "fail to executeChmod: " + e.toString());
            return "";
        }
    }

    public double getCpuUse() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            OperatingSystemMXBean osBean = ManagementFactory.newPlatformMXBeanProxy(mbs, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
            return osBean.getProcessCpuLoad();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static long getCurrentProcessId() {
        long pid;
        block2: {
            pid = 0L;
            try {
                pid = ProcessHandle.current().pid();
            }
            catch (Exception e) {
                String pidString;
                LogManager.warn(ProcessUtils.class, "getParentProcessId:" + e.toString());
                RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                String name = ManagementFactory.getRuntimeMXBean().getName();
                if (runtimeMXBean == null || TextUtils.isEmpty((CharSequence)name) || !name.contains("@") || TextUtils.isEmpty((CharSequence)(pidString = name.split("@")[0])) || !StringUtils.isNumeric((String)pidString)) break block2;
                pid = Long.parseLong(pidString);
            }
        }
        return pid;
    }
}

