/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.project.ProjectKt;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandler;
import com.intellij.vcs.commit.CommitWorkflowHandler;
import com.intellij.vcs.commit.CommitWorkflowUi;
import com.intellij.vcs.log.impl.VcsShortCommitDetailsImpl;
import com.tencent.code.intel.bean.item.CodeReviewDiffContext;
import com.tencent.code.intel.bean.item.CodeReviewRequestFile;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.util.CollectionUtils;
import com.tencent.code.intel.util.RegexUtils;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NotNull;

public class ProjectDiffUtils {
    public static List<String> getSelectedDiff(CommitWorkflowHandler commitWorkflowHandler, Project project, int maxDiffToken) {
        AbstractCommitWorkflowHandler workflowHandler = (AbstractCommitWorkflowHandler)commitWorkflowHandler;
        if (workflowHandler != null) {
            CommitWorkflowUi ui = workflowHandler.getUi();
            return ProjectDiffUtils.getDiffFromChanges(ui.getIncludedChanges(), project, maxDiffToken);
        }
        return new ArrayList<String>();
    }

    public static boolean hasChanges(Project project) {
        return CollectionUtils.isNotEmpty(ProjectDiffUtils.getChanges(project));
    }

    private static List<Change> getChanges(Project project) {
        return ChangeListManager.getInstance((Project)project).getChangeLists().stream().flatMap(changeList -> changeList.getChanges().stream()).collect(Collectors.toList());
    }

    public static List<String> getDiff(Project project, int maxDiffToken) {
        List<Change> changes = ProjectDiffUtils.getChanges(project);
        return ProjectDiffUtils.getDiffFromChanges(changes, project, maxDiffToken);
    }

    private static List<String> getDiffFromChanges(List<Change> changes, Project project, int maxDiffToken) {
        ArrayList<String> totalCommitLines = new ArrayList<String>();
        for (Change change : changes) {
            try {
                if (ProjectDiffUtils.isBinaryChange(change) || ProjectDiffUtils.isImageOrSvgChange(change)) continue;
                List patches = IdeaTextPatchBuilder.buildPatch((Project)project, List.of(change), (Path)Path.of(Objects.requireNonNull(project.getBasePath()), new String[0]), (boolean)false, (boolean)true);
                ArrayList<CallSite> contents = new ArrayList<CallSite>();
                if (CollectionUtils.isEmpty(patches)) {
                    String fileName = ProjectDiffUtils.getFileName(change);
                    if (!StringUtils.isBlank((CharSequence)fileName)) {
                        contents.add((CallSite)((Object)(fileName + " change mod")));
                    }
                } else {
                    StringWriter writer = new StringWriter();
                    UnifiedDiffWriter.write((Project)project, (Path)ProjectKt.getStateStore((Project)project).getProjectBasePath(), (Collection)patches, (Writer)writer, (String)"\n", null, List.of());
                    if (StringUtils.isNotBlank((CharSequence)writer.toString())) {
                        contents.addAll(Arrays.stream(writer.toString().split("\n")).collect(Collectors.toList()));
                    }
                }
                List<String> tokens = RegexUtils.stringToToken(String.join((CharSequence)"\n", totalCommitLines));
                if (tokens.size() < maxDiffToken) {
                    totalCommitLines.addAll(contents);
                    continue;
                }
                LogManager.warn(ProjectDiffUtils.class, "file diff token size is over " + maxDiffToken);
                return totalCommitLines;
            }
            catch (Throwable e) {
                LogManager.warn(ProjectDiffUtils.class, "get change list for commit message suggestion action error:" + String.valueOf(e));
            }
        }
        return totalCommitLines;
    }

    private static boolean isBinaryChange(Change change) {
        ContentRevision after = change.getAfterRevision();
        if (after != null) {
            return ProjectDiffUtils.isBinaryFile(after);
        }
        ContentRevision before = change.getBeforeRevision();
        return before != null && ProjectDiffUtils.isBinaryFile(before);
    }

    private static boolean isBinaryFile(ContentRevision revision) {
        FilePath file = revision.getFile();
        FileType fileType = file.getFileType();
        if (UnknownFileType.INSTANCE.getName().equals(fileType.getName())) {
            return ProjectDiffUtils.isOverSize(file) || ProjectDiffUtils.isBinaryByExtension(file);
        }
        return fileType.isBinary();
    }

    private static boolean isOverSize(FilePath file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        long length = virtualFile.getLength();
        return length > 0x300000L;
    }

    private static boolean isBinaryByExtension(FilePath file) {
        String[] binaryExtensions;
        String fileName = file.getName();
        for (String extension : binaryExtensions = new String[]{".exe", ".bin", ".zip", ".pdf", ".jpg", ".png", ".class"}) {
            if (!fileName.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private static boolean isImageOrSvgChange(Change change) {
        String fileName = ProjectDiffUtils.getFileName(change);
        String fileExtension = ProjectDiffUtils.getFileExtension(fileName);
        HashSet<String> IMAGE_EXTENSIONS = new HashSet<String>(Arrays.asList("png", "jpg", "jpeg", "gif", "bmp", "svg"));
        return IMAGE_EXTENSIONS.contains(fileExtension.toLowerCase());
    }

    private static String getFileName(Change change) {
        if (change.getAfterRevision() != null) {
            return change.getAfterRevision().getFile().getName();
        }
        ContentRevision before = change.getBeforeRevision();
        return before != null ? change.getBeforeRevision().getFile().getName() : "";
    }

    private static String getFileExtension(String fileName) {
        int lastIndexOfDot = fileName.lastIndexOf(46);
        return lastIndexOfDot == -1 ? "" : fileName.substring(lastIndexOfDot + 1);
    }

    public static List<String> getCommitMessages(Project project, int maxCount) {
        ArrayList<String> commitMessageList = new ArrayList<String>();
        String basePath = project.getBasePath();
        if (basePath == null) {
            return commitMessageList;
        }
        VirtualFile baseDir = LocalFileSystem.getInstance().findFileByPath(basePath);
        if (baseDir == null) {
            return commitMessageList;
        }
        return ProjectDiffUtils.getRecentGitLog(project, maxCount, baseDir, commitMessageList);
    }

    private static List<String> getRecentGitLog(Project project, int maxCount, VirtualFile baseDir, List<String> commitMessageList) {
        GitRepository repository = ProjectDiffUtils.getRepositoryForFile(project, baseDir);
        if (repository == null) {
            return ProjectDiffUtils.getGitLogFromCommandLine(project, baseDir, maxCount);
        }
        VirtualFile root = repository.getRoot();
        List commits = new ArrayList();
        try {
            commits = GitHistoryUtils.history((Project)project, (VirtualFile)root, (String[])new String[]{"--no-merges", "--pretty=format: \"%s\"", "--max-count=" + maxCount});
        }
        catch (Exception e) {
            LogManager.warn(ProjectDiffUtils.class, "get git log for commit message suggestion action error:" + String.valueOf(e));
        }
        if (CollectionUtils.isEmpty(commits)) {
            return commitMessageList;
        }
        return commits.stream().map(VcsShortCommitDetailsImpl::getSubject).map(s -> s.replaceAll("#\\d+$", "")).collect(Collectors.toList());
    }

    private static GitRepository getRepositoryForFile(Project project, VirtualFile file) {
        try {
            Class<?> gitRepositoryManagerClass = Class.forName("git4idea.repo.GitRepositoryManager");
            Method getInstanceMethod = gitRepositoryManagerClass.getMethod("getInstance", Project.class);
            Object gitRepositoryManager = getInstanceMethod.invoke(null, project);
            Method getRepositoryForFileMethod = gitRepositoryManagerClass.getMethod("getRepositoryForFile", VirtualFile.class);
            return (GitRepository)getRepositoryForFileMethod.invoke(gitRepositoryManager, file);
        }
        catch (Exception e) {
            LogManager.warn(ProjectDiffUtils.class, "Failed to get GitRepositoryManager or invoke its methods: " + String.valueOf(e));
            return null;
        }
    }

    private static List<String> getGitLogFromCommandLine(Project project, VirtualFile baseDir, int maxCount) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("git", "-C", baseDir.getPath(), "log", "--no-merges", "--pretty=format:%s", "--max-count=" + maxCount);
            Process process = processBuilder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    result.add(line.replaceAll("#\\d+$", ""));
                }
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                LogManager.warn(ProjectDiffUtils.class, "git log command exited with code " + exitCode);
            }
        }
        catch (Exception e) {
            LogManager.warn(ProjectDiffUtils.class, "Failed to execute git log command" + String.valueOf(e));
        }
        return result;
    }

    public static String getLatestCommitId(VirtualFile baseDir) {
        String commitId = "";
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("git", "-C", baseDir.getPath(), "log", "--no-merges", "--pretty=format:%H", "--max-count=1");
            Process process = processBuilder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                commitId = reader.readLine();
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                LogManager.warn(ProjectDiffUtils.class, "git log command exited with code " + exitCode);
            }
        }
        catch (Exception e) {
            LogManager.warn(ProjectDiffUtils.class, "Failed to execute git log command" + String.valueOf(e));
        }
        return commitId;
    }

    public static CodeReviewDiffContext getAICodeReviewDiff(Project project) {
        return ProjectDiffUtils.getAICodeReviewDiff(project, false);
    }

    public static CodeReviewDiffContext getAICodeReviewDiff(Project project, boolean onlyNeedFlePath) {
        CodeReviewDiffContext aiCodeReviewDiff;
        try {
            aiCodeReviewDiff = ProjectDiffUtils.getCodeReviewDiff(project, onlyNeedFlePath);
        }
        catch (Throwable e) {
            LogManager.warn(ProjectDiffUtils.class, "Failed to get code review diff: " + String.valueOf(e));
            aiCodeReviewDiff = new CodeReviewDiffContext(new ArrayList<CodeReviewRequestFile>());
        }
        return aiCodeReviewDiff;
    }

    private static CodeReviewDiffContext getCodeReviewDiff(Project project, boolean onlyNeedFlePath) {
        CodeReviewDiffContext context = new CodeReviewDiffContext();
        ArrayList<CodeReviewRequestFile> fileItems = new ArrayList<CodeReviewRequestFile>();
        List changes = ChangeListManager.getInstance((Project)project).getChangeLists().stream().flatMap(changeList -> changeList.getChanges().stream()).collect(Collectors.toList());
        String projectPath = project.getBasePath();
        if (TextUtils.isEmpty((CharSequence)projectPath)) {
            return context;
        }
        boolean stagingAreaEmpty = false;
        if (!onlyNeedFlePath) {
            stagingAreaEmpty = ProjectDiffUtils.isStagingAreaEmpty(projectPath);
            LogManager.warn(ProjectDiffUtils.class, "changes size: " + changes.size());
        }
        for (Change change : changes) {
            try {
                if (ProjectDiffUtils.isBinaryChange(change) || ProjectDiffUtils.isImageOrSvgChange(change)) {
                    LogManager.warn(ProjectDiffUtils.class, "Binary or image change detected, skipping: " + String.valueOf(change));
                    continue;
                }
                CodeReviewRequestFile fileItem = new CodeReviewRequestFile();
                String filePath = ProjectDiffUtils.getFilePath(project, change);
                fileItem.setFilePath(filePath);
                fileItem.setFileIdentity(filePath);
                if (onlyNeedFlePath) {
                    fileItems.add(fileItem);
                    continue;
                }
                String diff = ProjectDiffUtils.getDiffForChangeByCommand(projectPath, change, stagingAreaEmpty);
                fileItem.setDiff(diff);
                if (StringUtils.isBlank((CharSequence)diff)) continue;
                VirtualFile file = change.getVirtualFile();
                if (file != null) {
                    fileItem.setFileSize(file.getLength());
                }
                if (fileItem.getInvalidMessage() == null) {
                    fileItem.setContent(ProjectDiffUtils.getFileContent(filePath));
                }
                fileItem.setLanguage(ProjectDiffUtils.getFileLanguage(change));
                fileItems.add(fileItem);
            }
            catch (Throwable e) {
                LogManager.warn(ProjectDiffUtils.class, "Error processing change: " + String.valueOf(e));
            }
        }
        context.setDiffFiles(fileItems);
        return context;
    }

    private static String getFileLanguage(Change change) {
        Language fileLanguage = LanguageUtil.getFileLanguage((VirtualFile)change.getVirtualFile());
        if (fileLanguage != null) {
            return fileLanguage.getDisplayName();
        }
        return "";
    }

    private static String getFilePath(@NotNull Project project, @NotNull Change change) {
        VirtualFile file;
        if (project == null) {
            ProjectDiffUtils.$$$reportNull$$$0(0);
        }
        if (change == null) {
            ProjectDiffUtils.$$$reportNull$$$0(1);
        }
        if ((file = change.getVirtualFile()) != null) {
            return file.getUrl();
        }
        return "";
    }

    private static FileType getFileType(@NotNull Project project, @NotNull Change change) {
        VirtualFile file;
        if (project == null) {
            ProjectDiffUtils.$$$reportNull$$$0(2);
        }
        if (change == null) {
            ProjectDiffUtils.$$$reportNull$$$0(3);
        }
        if ((file = change.getVirtualFile()) != null) {
            return file.getFileType();
        }
        return null;
    }

    private static String getFileContent(@NotNull String filePath) {
        VirtualFile file;
        if (filePath == null) {
            ProjectDiffUtils.$$$reportNull$$$0(4);
        }
        if ((file = VirtualFileManager.getInstance().findFileByUrl(filePath)) != null) {
            try {
                return new String(file.contentsToByteArray(), file.getCharset());
            }
            catch (IOException e) {
                LogManager.error(ProjectDiffUtils.class, "Error getting file content: " + String.valueOf(e));
            }
        }
        return "";
    }

    @Deprecated
    private static String getDiffForChange(@NotNull Project project, @NotNull Change change) {
        if (project == null) {
            ProjectDiffUtils.$$$reportNull$$$0(5);
        }
        if (change == null) {
            ProjectDiffUtils.$$$reportNull$$$0(6);
        }
        try {
            List patches = IdeaTextPatchBuilder.buildPatch((Project)project, List.of(change), (Path)Path.of(Objects.requireNonNull(project.getBasePath()), new String[0]), (boolean)false, (boolean)true);
            if (!patches.isEmpty()) {
                StringWriter writer = new StringWriter();
                UnifiedDiffWriter.write((Project)project, (Path)ProjectKt.getStateStore((Project)project).getProjectBasePath(), (Collection)patches, (Writer)writer, (String)"\n", null, List.of());
                return writer.toString();
            }
        }
        catch (Exception e) {
            LogManager.error(ProjectDiffUtils.class, "Error getting diff for change: " + String.valueOf(e));
        }
        return "";
    }

    public static String getDiffForChangeByCommand(@NotNull String projectPath, @NotNull Change change, boolean stagingAreaEmpty) {
        String filePath;
        if (projectPath == null) {
            ProjectDiffUtils.$$$reportNull$$$0(7);
        }
        if (change == null) {
            ProjectDiffUtils.$$$reportNull$$$0(8);
        }
        if (TextUtils.isEmpty((CharSequence)(filePath = ProjectDiffUtils.getFilePath(change)))) {
            return "";
        }
        try {
            return ProjectDiffUtils.getGitDiff(projectPath, Collections.singletonList(filePath), !stagingAreaEmpty);
        }
        catch (Exception e) {
            LogManager.warn(ProjectDiffUtils.class, "Error getting diff for change: " + String.valueOf(e));
            return "";
        }
    }

    private static String getFilePath(Change change) {
        VirtualFile file;
        ContentRevision afterRevision = change.getAfterRevision();
        if (afterRevision != null && (file = afterRevision.getFile().getVirtualFile()) != null) {
            return file.getPath();
        }
        return null;
    }

    private static String getGitDiff(String projectPath, List<String> filePaths, boolean cached) {
        if (CollectionUtils.isEmpty(filePaths)) {
            return "";
        }
        Process process = ProjectDiffUtils.createGitDiffProcess(projectPath, filePaths, cached);
        if (process == null) {
            return "";
        }
        return new BufferedReader(new InputStreamReader(process.getInputStream())).lines().collect(Collectors.joining("\n"));
    }

    private static Process createGitDiffProcess(String projectPath, List<String> filePaths, boolean cached) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("git");
        command.add("diff");
        if (cached) {
            command.add("--cached");
        }
        command.addAll(filePaths);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.directory(new File(projectPath));
        try {
            return processBuilder.start();
        }
        catch (Exception ex) {
            LogManager.warn(ProjectDiffUtils.class, "Unable to start git diff process: " + ex.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isStagingAreaEmpty(String projectPath) {
        List<String> command = List.of("git", "diff", "--cached", "--exit-code");
        Path projectDir = Paths.get(projectPath, new String[0]).toAbsolutePath().normalize();
        Process process = null;
        try {
            process = new ProcessBuilder(command).directory(projectDir.toFile()).redirectErrorStream(true).start();
            try (InputStream is = process.getInputStream();){
                is.readAllBytes();
            }
            if (!process.waitFor(120L, TimeUnit.SECONDS)) {
                LogManager.warn(ProjectDiffUtils.class, "Git diff execution timeout 120 seconds");
                boolean is = true;
                return is;
            }
            boolean is = process.exitValue() == 0;
            return is;
        }
        catch (Exception ex) {
            LogManager.warn(ProjectDiffUtils.class, String.format("Failed to check staging area for [%s]: %s", projectDir, ex.getMessage()));
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroyForcibly();
            }
        }
    }

    public static String getGitFullLog(Project project, int count) {
        try {
            String basePath = project.getBasePath();
            if (basePath == null) {
                return "";
            }
            String username = ProjectDiffUtils.getGitUserName(basePath);
            if (StringUtils.isEmpty((CharSequence)username)) {
                return "";
            }
            List<CallSite> command = List.of("git", "log", "--author=" + username, "--no-merges", "--pretty=format:%B%n------------------------------", "-" + count);
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.directory(new File(basePath));
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            StringBuilder output = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                }
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                LogManager.warn(ProjectDiffUtils.class, "Git log command exited with code " + exitCode);
                return "";
            }
            return output.toString();
        }
        catch (Exception ex) {
            LogManager.warn(ProjectDiffUtils.class, "Error getting git log: " + String.valueOf(ex));
            return "";
        }
    }

    private static String getGitUserName(String projectPath) throws IOException, InterruptedException {
        List<String> command = List.of("git", "config", "user.name");
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.directory(new File(projectPath));
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        StringBuilder output = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                output.append(line);
            }
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            LogManager.warn(ProjectDiffUtils.class, "Git log command exited with code " + exitCode);
            return null;
        }
        return output.toString().trim();
    }

    public static boolean hasGitRepository(Project project) {
        try {
            String projectPath = project.getBasePath();
            if (projectPath == null) {
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)projectPath)) {
                LogManager.warn(ProjectDiffUtils.class, "Project path is empty or null.");
                return false;
            }
            File gitDir = new File(projectPath, ".git");
            if (gitDir.exists() && gitDir.isDirectory()) {
                return true;
            }
            LogManager.warn(ProjectDiffUtils.class, "No Git repository found in the project directory: " + projectPath);
        }
        catch (Exception e) {
            LogManager.warn(ProjectDiffUtils.class, "Error checking for Git repository: " + String.valueOf(e));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
        }
        objectArray2[1] = "com/tencent/code/intel/util/ProjectDiffUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFilePath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileContent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getDiffForChange";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getDiffForChangeByCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

