/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import java.lang.reflect.Method;

public class PsiUtils {
    private static final Logger log = Logger.getInstance(PsiUtils.class);

    public static boolean instanceOf(Object obj, String ... possibleClassNames) {
        if (obj == null || possibleClassNames == null) {
            return false;
        }
        String objClassName = obj.getClass().getName();
        for (String className : possibleClassNames) {
            Class<?> clazz;
            if (className.equals(objClassName)) {
                return true;
            }
            if (className.contains("$")) continue;
            try {
                clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                if (clazz.isInstance(obj)) {
                    return true;
                }
            }
            catch (ClassNotFoundException e) {
                log.debug("fail to instanceOf Class using context class loader: " + className);
            }
            try {
                clazz = Class.forName(className, true, obj.getClass().getClassLoader());
                if (!clazz.isInstance(obj)) continue;
                return true;
            }
            catch (ClassNotFoundException e) {
                log.debug("fail to instanceOf Class using object's class loader: " + className);
            }
        }
        return false;
    }

    public static PsiElement getNameIdentifierFromClass(PsiElement element) {
        try {
            return (PsiElement)element.getClass().getMethod("getNameIdentifier", new Class[0]).invoke((Object)element, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getName(PsiElement element, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (!clazz.isInstance(element)) {
                return null;
            }
            Method method = clazz.getMethod("getName", new Class[0]);
            Object result = method.invoke((Object)element, new Object[0]);
            return result.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

