/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.tencent.code.intel.bean.item.Position;
import com.tencent.code.intel.bean.item.Range;
import com.tencent.code.intel.manager.LogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.util.TextUtils;

public class RegexUtils {
    public static String getLink(String url) {
        if (!TextUtils.isBlank((CharSequence)url) && url.contains("#")) {
            return url.split("#")[0];
        }
        return url;
    }

    public static Range getRangeByUrl(String url) {
        Range range = null;
        try {
            if (!TextUtils.isBlank((CharSequence)url) && url.contains("#")) {
                String[] split = url.split("#");
                if (split.length <= 1) {
                    return null;
                }
                Pattern pattern = Pattern.compile("L(\\d+):(\\d+)-(\\d+):(\\d+)");
                Matcher matcher = pattern.matcher(split[1]);
                if (matcher.find()) {
                    range = new Range();
                    range.setStart(new Position(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2))));
                    range.setEnd(new Position(Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4))));
                }
            }
        }
        catch (Exception e) {
            LogManager.warn(RegexUtils.class, "getRangeByUrl error: " + e.getMessage());
        }
        return range;
    }

    public static boolean isEqualIgnoreSlash(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        String newStr1 = s1.replace("/", "").replace("\\", "");
        String newStr2 = s2.replace("/", "").replace("\\", "");
        return newStr1.equals(newStr2);
    }

    public static int countNewlines(String str) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '\n') continue;
            ++count;
        }
        return count;
    }

    public static List<String> splitCompletionTextByWord(String completionText) {
        Pattern pattern = Pattern.compile("\\s+|\\b\\w+\\b|\\W");
        Matcher matcher = pattern.matcher(completionText);
        ArrayList<String> words = new ArrayList<String>();
        while (matcher.find()) {
            String group = matcher.group();
            if (TextUtils.isBlank((CharSequence)group)) continue;
            words.add(group);
        }
        return words;
    }

    public static String getLeadingIndentation(String str) {
        char c;
        StringBuilder leadingIndentation = new StringBuilder();
        for (int i = 0; i < str.length() && ((c = str.charAt(i)) == ' ' || c == '\t'); ++i) {
            leadingIndentation.append(c);
        }
        return leadingIndentation.toString();
    }

    public static boolean isMissingRightBracket(String input) {
        Stack<Character> stack = new Stack<Character>();
        for (char c : input.toCharArray()) {
            if (c == '{') {
                stack.push(Character.valueOf(c));
                continue;
            }
            if (c != '}' || !stack.isEmpty() && ((Character)stack.pop()).charValue() == '{') continue;
            return true;
        }
        return !stack.isEmpty();
    }

    public static boolean isClassOrNameSpaceLine(String line) {
        String regex = "^\\s*(public|protected|private|abstract|static|final)*\\s*(class|namespace|interface)\\s*(.*)?";
        if (!TextUtils.isEmpty((CharSequence)line)) {
            return line.matches(regex);
        }
        return false;
    }

    public static String wrapFencedCode(String language, String snippet) {
        Pattern pattern = Pattern.compile("\\s*(```+)", 32);
        Matcher matcher = pattern.matcher(snippet);
        String firstMatchString = "";
        if (matcher.find()) {
            firstMatchString = matcher.group(1);
        }
        int symbolCount = Math.max(3, firstMatchString.length() + 1);
        String border = "`".repeat(symbolCount);
        return border + language + "\n" + snippet + "\n" + border;
    }

    public static int getTokenNum(String source) {
        int count = 0;
        try {
            String patterAnalyzer = "'s|'t|'re|'ve|'m|'ll|'d| ?\\p{L}+| ?\\p{N}+| ?[^\\s\\p{L}\\p{N}]+|\\s+(?!\\S)|\\s+";
            if (!TextUtils.isEmpty((CharSequence)source)) {
                Pattern pattern = Pattern.compile(patterAnalyzer, 32);
                Matcher matcher = pattern.matcher(source);
                while (matcher.find()) {
                    ++count;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public static int getStartSpaceOrTabNum(String content) {
        int count = 0;
        if (!TextUtils.isEmpty((CharSequence)content)) {
            char c;
            for (int i = 0; i < content.length() && ((c = content.charAt(i)) == ' ' || c == '\t'); ++i) {
                ++count;
            }
        }
        return count;
    }

    public static int[] getNodeVersion(String nodeVersion) {
        Pattern pattern = Pattern.compile("v([\\d]+)\\.([\\d]+)\\.([\\d]+)");
        Matcher matcher = pattern.matcher(nodeVersion);
        int[] versions = new int[3];
        if (matcher.find()) {
            versions[0] = Integer.parseInt(matcher.group(1));
            versions[1] = Integer.parseInt(matcher.group(2));
            versions[2] = Integer.parseInt(matcher.group(3));
        }
        return versions;
    }

    public static List<String> stringToToken(String source) {
        ArrayList<String> tokens = new ArrayList<String>();
        try {
            String patterAnalyzer = "'s|'t|'re|'ve|'m|'ll|'d| ?\\p{L}+| ?\\p{N}+| ?[^\\s\\p{L}\\p{N}]+|\\s+(?!\\S)|\\s+";
            if (!TextUtils.isEmpty((CharSequence)source)) {
                Pattern pattern = Pattern.compile(patterAnalyzer, 32);
                Matcher matcher = pattern.matcher(source);
                while (matcher.find()) {
                    tokens.add(matcher.group());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tokens;
    }

    public static String replaceLast(String text, String regex, String replacement) {
        return text.replaceFirst("(?s)(.*)" + regex, "$1" + replacement);
    }
}

