/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JLabel;

public class ShortCutUtils {
    public static int getTextLength(String content) {
        return new JLabel((String)content).getPreferredSize().width;
    }

    public static String getShortcutText(String actionId, String defaultValue) {
        AnAction anAction = ActionManager.getInstance().getAction(actionId);
        if (anAction == null) {
            return defaultValue;
        }
        return StringUtil.defaultIfEmpty((String)KeymapUtil.getFirstKeyboardShortcutText((AnAction)anAction), (String)defaultValue);
    }

    public static String getKeyText(int code) {
        return KeymapUtil.getKeyText((int)code);
    }

    public static void performAnAction(AnAction anAction) {
        ActionManager.getInstance().tryToExecute(anAction, ActionCommand.getInputEvent((String)"dummy"), null, "unknown", true);
    }

    public static void performAnAction(AnAction anAction, DataContext context) {
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)context);
        anAction.actionPerformed(event);
    }

    public static void performActionHandler(String ID, Editor editor, DataContext context) {
        EditorActionHandler editorActionHandler = EditorActionManager.getInstance().getActionHandler(ID);
        if (editorActionHandler != null) {
            editorActionHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), context);
        }
    }
}

