/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

public class StringEncryptUtils {
    private static final String REFERENCE = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final String REPLACE = "zyxwvutsrqponmlkjihgfedcbaZYXWVUTSRQPONMLKJIHGFEDCBA9876543210";

    public static void main(String[] args) {
        StringEncryptUtils.textEncryption();
    }

    private static void textEncryption() {
        try {
            String data = "Hello, World!";
            String obfuscateData = StringEncryptUtils.replaceEncrypt(data);
            String restoreData = StringEncryptUtils.replaceDecrypt(obfuscateData);
            System.out.println("\u539f\u59cb\u7684\u6570\u636e\uff1a" + data);
            System.out.println("\u66ff\u6362\u6df7\u6dc6\u540e\u7684\u6570\u636e\uff1a" + obfuscateData);
            System.out.println("\u66ff\u6362\u8fd8\u539f\u540e\u7684\u6570\u636e\uff1a" + restoreData);
            String xorData = StringEncryptUtils.replaceEncrypt(data);
            String restoreXorData = StringEncryptUtils.replaceDecrypt(xorData);
            System.out.println("\u539f\u59cb\u7684\u6570\u636e\uff1a" + data);
            System.out.println("\u5f02\u6216\u6df7\u6dc6\u540e\u7684\u6570\u636e\uff1a" + xorData);
            System.out.println("\u5f02\u6216\u8fd8\u539f\u540e\u7684\u6570\u636e\uff1a" + restoreXorData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String replaceEncrypt(String input) {
        StringBuilder encrypted = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            int index = REFERENCE.indexOf(c);
            if (index != -1) {
                encrypted.append(REPLACE.charAt(index));
                continue;
            }
            encrypted.append(c);
        }
        return encrypted.toString();
    }

    public static String replaceDecrypt(String input) {
        StringBuilder decrypted = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            int index = REPLACE.indexOf(c);
            if (index != -1) {
                decrypted.append(REFERENCE.charAt(index));
                continue;
            }
            decrypted.append(c);
        }
        return decrypted.toString();
    }

    public static String xorEncrypt(String input) {
        StringBuilder encrypted = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            char keyChar = REFERENCE.charAt(i % REFERENCE.length());
            encrypted.append((char)(c ^ keyChar));
        }
        return encrypted.toString();
    }

    public static String xorDecrypt(String input) {
        StringBuilder decrypted = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            char keyChar = REFERENCE.charAt(i % REFERENCE.length());
            decrypted.append((char)(c ^ keyChar));
        }
        return decrypted.toString();
    }
}

