/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.intellij.ui.JBColor;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.util.ColorUtils;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class ThemeUtils {
    private static String readResource(String resourceName) {
        InputStream stream = ThemeUtils.class.getResourceAsStream(resourceName);
        if (stream != null) {
            try {
                return IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                LogManager.error(ThemeUtils.class, "Read resource error." + String.valueOf(e));
                return null;
            }
        }
        return null;
    }

    public static String loadMarkdownText(Color foreground, Font font, String content) {
        String markdownTemplate = MarkdownTemplateHolder.template;
        if (markdownTemplate != null) {
            String fontColor = String.format("#%02x%02x%02x", foreground.getRed(), foreground.getGreen(), foreground.getBlue());
            Color linkColor = ColorUtils.getLinkForegroundColor();
            String linkColorHex = String.format("#%02x%02x%02x", linkColor.getRed(), linkColor.getGreen(), linkColor.getBlue());
            Color hoverColor = ColorUtils.getButtonHoverBackgroundColor();
            String hashtagColorHex = String.format("#%02x%02x%02x", hoverColor.getRed(), hoverColor.getGreen(), hoverColor.getBlue());
            JBColor jBColor = new JBColor(new Color(183, 107, 1), new Color(209, 154, 102));
            String markdownPunctColorHex = String.format("#%02x%02x%02x", jBColor.getRed(), jBColor.getGreen(), jBColor.getBlue());
            JBColor jBColor2 = new JBColor(new Color(48, 54, 61), new Color(208, 215, 222));
            String tableBorderColorHex = String.format("#%02x%02x%02x", jBColor2.getRed(), jBColor2.getGreen(), jBColor2.getBlue());
            return markdownTemplate.replace("{{fontColor}}", fontColor).replace("{{fontFamily}}", font.getFamily()).replace("{{shortcutBackgroundColor}}", hashtagColorHex).replace("{{content}}", content.trim()).replace("{{linkColor}}", linkColorHex).replace("{{markdownPunctuationColor}}", markdownPunctColorHex).replace("{{tableBorderColor}}", tableBorderColorHex);
        }
        return null;
    }

    public static String loadHtmlText(String content, Font font, Color fontColor, Color linkColor) {
        String textTemplate = MarkdownTemplateHolder.textTemplate;
        if (textTemplate != null) {
            String linkColorHex = String.format("#%02x%02x%02x", linkColor.getRed(), linkColor.getGreen(), linkColor.getBlue());
            String fontColorHex = String.format("#%02x%02x%02x", fontColor.getRed(), fontColor.getGreen(), fontColor.getBlue());
            return textTemplate.replace("{{fontColor}}", fontColorHex).replace("{{fontFamily}}", font.getFamily()).replace("{{fontSize}}", String.valueOf(font.getSize())).replace("{{content}}", content.trim().replace("\n", "<br>")).replace("{{linkColor}}", linkColorHex);
        }
        return null;
    }

    public static final class MarkdownTemplateHolder {
        private static final String template = ThemeUtils.readResource("/highlight/markdown.html");
        private static final String textTemplate = ThemeUtils.readResource("/highlight/text.html");

        private MarkdownTemplateHolder() {
        }
    }
}

