/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.util;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.fileEditor.impl.HTMLEditorProvider;
import com.intellij.openapi.project.Project;
import com.tencent.code.intel.bean.item.Position;
import com.tencent.code.intel.bean.item.Range;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.toc.TocExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.awt.Desktop;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.util.TextUtils;

public class URLUtils {
    public static boolean browse(String url) {
        LogManager.info(URLUtils.class, "browse-" + url);
        boolean result = false;
        try {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(URI.create(url));
                result = true;
            }
        }
        catch (Exception e) {
            LogManager.info(URLUtils.class, "Desktop-browse-error:" + e.toString());
        }
        if (!result) {
            try {
                LogManager.info(URLUtils.class, "BrowserUtil.browse:" + url);
                BrowserUtil.browse((URI)URI.create(url));
                result = true;
            }
            catch (Exception e) {
                LogManager.info(URLUtils.class, "BrowserUtil-browse-error:" + e.toString());
            }
        }
        if (!result) {
            try {
                LogManager.info(URLUtils.class, "Shell browse:" + url);
                String os = System.getProperty("os.name").toLowerCase();
                Runtime rt = Runtime.getRuntime();
                if (os.contains("win")) {
                    rt.exec("rundll32 url.dll,FileProtocolHandler " + url);
                    result = true;
                } else if (os.contains("mac")) {
                    rt.exec("open " + url);
                    result = true;
                } else if (os.contains("nix") || os.contains("nux") || os.contains("aix")) {
                    String[] browsers;
                    for (String browser : browsers = new String[]{"xdg-open", "gnome-open", "kde-open"}) {
                        try {
                            rt.exec(new String[]{browser, url});
                            return true;
                        }
                        catch (IOException iOException) {
                        }
                    }
                }
            }
            catch (Exception e) {
                LogManager.info(URLUtils.class, "Shell-browse-error:" + e.toString());
            }
        }
        return result;
    }

    public static void browseWithException(String url) throws Exception {
        LogManager.info(URLUtils.class, "browse-" + url);
        Desktop desktop = Desktop.getDesktop();
        if (Desktop.isDesktopSupported()) {
            try {
                desktop.browse(URI.create(url));
            }
            catch (Exception e) {
                throw new Exception("browse-error:" + e.toString());
            }
        }
        LogManager.info(URLUtils.class, "\u4e0d\u652f\u6301:Desktop\uff0c\u5c1d\u8bd5\u53e6\u5916\u4e00\u79cd\u65b9\u5f0f\u6253\u5f00\uff1a" + url);
        try {
            BrowserUtil.browse((URI)URI.create(url));
        }
        catch (Exception e) {
            throw new Exception("\u4e0d\u652f\u6301\u6253\u5f00\u94fe\u63a5:" + e.toString());
        }
    }

    public static void openUrlOnWindow(Project project, String title, String url) {
        try {
            Method openEditorMethod = HTMLEditorProvider.class.getMethod("openEditor", Project.class, String.class, String.class, String.class);
            openEditorMethod.invoke(null, project, title, url, null);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LogManager.info(URLUtils.class, "openUrlOnWindow error:" + e.toString());
        }
    }

    public static void openHtmlOnWindow(Project project, String title, String html) {
        try {
            Method openEditorMethod = HTMLEditorProvider.class.getMethod("openEditor", Project.class, String.class, String.class);
            openEditorMethod.invoke(null, project, title, html);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LogManager.info(URLUtils.class, "openHtmlOnWindow error:" + e.toString());
        }
    }

    public static String convertHttpToMarkdownLink(String httpText, String httpLink) {
        return "[" + httpText + "](" + httpLink + ")";
    }

    public static String convertMarkdownToHtml(String markdownText) {
        Parser parser = Parser.builder().build();
        Document document = parser.parse(markdownText);
        HtmlRenderer renderer = HtmlRenderer.builder().build();
        return renderer.render((Node)document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertToEscapeHtml(String originText) {
        Future<String> future = ThreadManager.getInstance().runThread(() -> {
            MutableDataSet options = URLUtils.getMutableDataSet();
            options.set(Parser.EXTENSIONS, Arrays.asList(TocExtension.create(), TablesExtension.create()));
            options.set(HtmlRenderer.SOFT_BREAK, (Object)"<br />\n");
            options.set(HtmlRenderer.ESCAPE_HTML, (Object)true);
            Parser parser = Parser.builder((DataHolder)options).build();
            Document document = parser.parse(originText);
            HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).build();
            return renderer.render((Node)document);
        });
        try {
            String string = future.get(3L, TimeUnit.SECONDS);
            return string;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LogManager.warn(URLUtils.class, "convertToEscapeHtml error: " + e.toString());
            String string = originText;
            return string;
        }
        finally {
            future.cancel(true);
        }
    }

    public static MutableDataSet getMutableDataSet() {
        MutableDataSet options = new MutableDataSet();
        options.set(HtmlRenderer.GENERATE_HEADER_ID, (Object)true);
        options.set(HtmlRenderer.SOFT_BREAK, (Object)"<br />\n");
        options.set(HtmlRenderer.HARD_BREAK, (Object)"<br />\n");
        options.set(HtmlRenderer.ESCAPE_HTML_BLOCKS, (Object)true);
        options.set(HtmlRenderer.ESCAPE_INLINE_HTML, (Object)true);
        return options;
    }

    public static String getHtmlPrefix() {
        return "<style>h1, h2, h3, h4, h5, h6 { font-weight: bold; font-size: 1em; line-height: 1.5em;}</style>";
    }

    public static String handleHtml(String message) {
        return message.replaceAll(">>\\[([^\\]]+)\\]\\(([^\\)]+)\\)<<", "&gt;&gt;[$1]($2)&lt;&lt;");
    }

    public static String convertMarkdownToHtmlLink(String markdown) {
        String pattern = "\\[([^\\]]+)\\]\\(([^\\)]+)\\)";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(markdown);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String linkText = m.group(1);
            String linkUrl = m.group(2);
            String htmlLink = "<a href=\"" + linkUrl + " \">" + linkText + "</a>";
            m.appendReplacement(sb, htmlLink);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String convertToHtml(String message) {
        MutableDataSet options = URLUtils.getMutableDataSet();
        Document document = Parser.builder((DataHolder)options).build().parse(URLUtils.handleHtml(message));
        String result = HtmlRenderer.builder((DataHolder)options).build().render((Node)document);
        return URLUtils.getHtmlPrefix() + result;
    }

    public static Range getRangeByUrl(String url) {
        Range range = null;
        try {
            if (!TextUtils.isBlank((CharSequence)url) && url.contains("#")) {
                String[] split = url.split("#");
                if (split.length <= 1) {
                    return null;
                }
                Pattern pattern = Pattern.compile("L(\\d+):(\\d+)-(\\d+):(\\d+)");
                Matcher matcher = pattern.matcher(url.split("#")[1]);
                if (matcher.find()) {
                    range = new Range();
                    range.setStart(new Position(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2))));
                    range.setEnd(new Position(Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4))));
                }
            }
        }
        catch (Exception e) {
            LogManager.warn(URLUtils.class, "getRangeByUrl error: " + e.getMessage());
        }
        return range;
    }

    public static String replaceEndpointHost(String originalURL, String authority) throws URISyntaxException, MalformedURLException {
        URI uri = new URI(originalURL);
        int port = (uri = new URI(uri.getScheme().toLowerCase(), authority, uri.getPath(), uri.getQuery(), uri.getFragment())).getPort();
        if (port > 0 && port == uri.toURL().getDefaultPort()) {
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), -1, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        return uri.toString();
    }

    public static String parseDomainFromEndpoint(String endpoint) {
        if (TextUtils.isEmpty((CharSequence)endpoint)) {
            return "";
        }
        try {
            URI uri = new URI(endpoint);
            return uri.getPort() != -1 ? uri.getHost() + ":" + uri.getPort() : uri.getHost();
        }
        catch (URISyntaxException e) {
            return "";
        }
    }

    public static Map<String, String> parseQuery(String query) {
        String[] pairs;
        HashMap<String, String> queryPairs = new HashMap<String, String>();
        if (query == null || query.isEmpty()) {
            return queryPairs;
        }
        for (String pair : pairs = query.split("&")) {
            String key;
            int idx = pair.indexOf("=");
            if (idx > 0 && idx < pair.length() - 1) {
                key = URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8);
                String value = URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8);
                queryPairs.put(key, value);
                continue;
            }
            key = URLDecoder.decode(pair, StandardCharsets.UTF_8);
            queryPairs.put(key, null);
        }
        return queryPairs;
    }
}

